﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using CookComputing.XmlRpc;

namespace SpaceBuilder.Blog.MetaWeblogAPI
{
    /// <summary>
    /// 客户端博客编辑器接口
    /// </summary>
    public interface IMetaWeblog
    {

        [XmlRpcMethod("metaWeblog.newPost",
           Description = "Makes a new post to a designated blog using the "
           + "metaWeblog API. Returns postid as a string.")]
        string newPost(
          string blogid,
          string username,
          string password,
          Post post,
          bool publish);

        [XmlRpcMethod("metaWeblog.editPost",
           Description = "Updates and existing post to a designated blog "
           + "using the metaWeblog API. Returns true if completed.")]
        object editPost(
          string postid,
          string username,
          string password,
          Post post,
          bool publish);

        [XmlRpcMethod("metaWeblog.getCategories",
           Description = "Retrieves a list of valid categories for a post "
           + "using the metaWeblog API. Returns the metaWeblog categories "
           + "struct collection.")]
        CategoryInfo[] getCategories(
          string blogid,
          string username,
          string password);

        [XmlRpcMethod("metaWeblog.getPost",
           Description = "Retrieves an existing post using the metaWeblog "
           + "API. Returns the metaWeblog struct.")]
        Post getPost(
          string postid,
          string username,
          string password);

        [XmlRpcMethod("metaWeblog.getRecentPosts",
           Description = "Retrieves a list of the most recent existing post "
           + "using the metaWeblog API. Returns the metaWeblog struct collection.")]
        Post[] getRecentPosts(
          string blogid,
          string username,
          string password,
          int numberOfPosts);

        //  [XmlRpcMethod("metaWeblog.newMediaObject",
        //Description = "Makes a new file to a designated blog using the "
        //+ "metaWeblog API. Returns url as a string of a struct.")]
        //  UrlData newMediaObject(
        //    string blogid,
        //    string username,
        //    string password,
        //    FileData file);


     //   //由于博客附件必须与文章关联因此当前不能实现附件上传
     //   [XmlRpcMethod("metaWeblog.newMediaObject",
     //Description = "Makes a new post to a designated blog using the "
     //+ "MetaWeblog API. Returns file url as a string.")]
     //   MediaObjectInfo newMediaObject(
     //       string blogid,
     //       string username,
     //       string password,
     //       MediaObject mediaObject);

        #region LiveWriter API

        /// <summary> 
        /// Returns information about the user’s space. An empty array is returned if the user does not have a space. 
        /// </summary> 
        /// <param name="appKey"> This value is ignored. </param> 
        /// <param name="postid"> The ID of the post to update. </param> 
        /// <param name="username"> The name of the user’s space. </param> 
        /// <returns> An array of structs that represents each of the user’s blogs. The array will contain a maximum of one struct, since a user can only have a single space with a single blog. </returns> 
        [XmlRpcMethod("blogger.getUsersBlogs")]
        UserBlog[] getUsersBlogs(
        string appKey,
        string username,
        string password);


        /// <summary> 
        /// Returns basic user info (name, e-mail, userid, and so on). 
        /// </summary> 
        /// <param name="appKey"> This value is ignored. </param> 
        /// <param name="postid"> The ID of the post to update. </param> 
        /// <param name="username"> The name of the user’s space. </param> 
        /// <returns> A struct containing profile information about the user. 
        /// Each struct will contain the following fields: nickname, userid, url, e-mail, 
        /// lastname, and firstname. </returns> 
        [XmlRpcMethod("blogger.getUserInfo")]
        UserInfo getUserInfo(
        string appKey,
        string username,
        string password);

        [XmlRpcMethod("blogger.deletePost",
     Description = "Deletes a post.")]
        [return: XmlRpcReturnValue(Description = "Always returns true.")]
        bool deletePost(
            string appKey,
            string postid,
            string username,
            string password,
            [XmlRpcParameter(
                 Description = "Where applicable, this specifies whether the weblog "
                 + "should be republished after the post has been deleted.")]
			bool publish);


        #endregion

    }
}


