﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using CookComputing.XmlRpc;

namespace SpaceBuilder.Blog.MetaWeblogAPI
{

    [XmlRpcMissingMapping(MappingAction.Ignore)]
    public struct Enclosure
    {
        /// <summary>
        /// 长度
        /// </summary>
        public int length;

        /// <summary>
        /// 类型
        /// </summary>
        public string type;

        /// <summary>
        /// 相应Url
        /// </summary>
        public string url;
    }

    [XmlRpcMissingMapping(MappingAction.Ignore)]
    public struct Source
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string name;

        /// <summary>
        /// 链接
        /// </summary>
        public string url;
    }

    [XmlRpcMissingMapping(MappingAction.Ignore)]
    public struct Post
    {
        [XmlRpcMissingMapping(MappingAction.Error)]
        [XmlRpcMember(Description = "Required when posting.")]
        public DateTime dateCreated;
        [XmlRpcMissingMapping(MappingAction.Error)]
        [XmlRpcMember(Description = "Required when posting.")]
        public string description;
        [XmlRpcMissingMapping(MappingAction.Error)]
        [XmlRpcMember(Description = "Required when posting.")]
        public string title;

        public string[] categories;
        public Enclosure enclosure;
        public string link;
        public string permalink;
        [XmlRpcMember(
           Description = "Not required when posting. Depending on server may "
           + "be either string or integer. "
           + "Use Convert.ToInt32(postid) to treat as integer or "
           + "Convert.ToString(postid) to treat as string")]
        public object postid;
        public Source source;
        public string userid;

        public object mt_allow_comments;
        public object mt_allow_pings;
        public object mt_convert_breaks;
        public string mt_text_more;
        public string mt_excerpt;

        [XmlRpcMember(Description = "Optional when posting.")]
        public string mt_keywords;
    }

    public struct CategoryInfo
    {
        public string description;
        public string htmlUrl;
        public string rssUrl;
        public string title;
        public string categoryid;
    }

    public struct Category
    {
        public string categoryId;
        public string categoryName;
    }

    //public struct FileData
    //{
    //    public byte[] bits;
    //    public string name;
    //    public string type;
    //}

    //public struct UrlData
    //{
    //    public string url;
    //}

    [XmlRpcMissingMapping(MappingAction.Ignore)]
    public struct MediaObject
    {
        public byte[] bits;
        public string name;
        public string type;
    }

    [Serializable]
    public struct MediaObjectInfo
    {
        public string url;
    }

    #region LiveWriter API

    /// <summary> 
    /// This struct represents information about a user's blog. 
    /// </summary> 
    [XmlRpcMissingMapping(MappingAction.Ignore)]
    public struct UserBlog
    {
        /// <summary>
        /// blog相应的Url
        /// </summary>
        public string url;
        public string blogid;
        public string blogName;
    }


    /// <summary> 
    /// This struct represents information about a user. 
    /// </summary> 
    [XmlRpcMissingMapping(MappingAction.Ignore)]
    public struct UserInfo
    {
        public string url;
        public string blogid;
        public string blogName;
        public string firstname;
        public string lastname;
        public string email;
        public string nickname;
    } 

    #endregion


}
