﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Club
{
    /// <summary>
    /// 群组中的Cookie缓存
    /// </summary>
    public static class ClubUserCookie
    {
        private static readonly string ClubMemberListSortBy = "ClubMemberSortBy";

        /// <summary>
        /// 保存群组成员排序方式
        /// </summary>
        public static void SaveClubMemberListSortBy(this UserCookie userCookieObject, ClubMembersSortBy sortBy)
        {
            if (userCookieObject != null)
            {
                userCookieObject.Cookie[ClubMemberListSortBy] = Convert.ToString((int)sortBy) ;
                userCookieObject.WriteCookie();
            }
        }

        /// <summary>
        /// 获取群组成员排序方式
        /// </summary>
        public static ClubMembersSortBy GetClubMemberListSortBy(this UserCookie userCookieObject)
        {
            ClubMembersSortBy sortBy = ClubMembersSortBy.JoinDate;
            if (userCookieObject != null)
            {
                string sortByString = userCookieObject.Cookie[ClubMemberListSortBy];
                if (!string.IsNullOrEmpty(sortByString))
                {
                    try
                    {
                        sortBy = (ClubMembersSortBy)(Convert.ToInt32(sortByString));
                    }
                    catch
                    { }
                }
            }
            return sortBy;
        }
    }
}
