﻿using System;
using System.Collections.Generic;
//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System.Linq;
using System.Text;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.Common
{
    /// <summary>
    /// 导航实体的扩展方法
    /// </summary>
    public static class NavigationExtensions
    {
        /// <summary>
        /// 群组空间获取导航的方法
        /// </summary>
        public static string GetClubNavigationUrl(this OwnerNavigation ownerNavigation, string clubDomainName)
        {
            if (string.IsNullOrEmpty(ownerNavigation.NavigationUrl))
            {
                if (ownerNavigation.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                {
                    return Globals.GetFullUrlInMainSite(SPBUrlHelper.RouteUrl(ownerNavigation.UrlRouteName, new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
                }
            }
            return ownerNavigation.ResolvedNavigationUrl;
        }
    }
}