﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Club;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.Club
{
    public static class SiteUrlsExtensions
    {
        /// <summary>
        /// 显示群组logo url
        /// </summary>
        /// <param name="clubLogoSizeTypes">clubLogoSizeTypes</param>
        /// <param name="enableClientCaching">是否启用客户端缓存</param>
        public static string ClubLogoUrl(this SiteUrls siteUrls, int clubID, ClubLogoSizeTypes clubLogoSizeTypes, bool enableClientCaching)
        {
            Club club = Clubs.GetClub(clubID, false);
            if (club == null)
                return string.Empty;
            bool isRealTime = ClubPermission.Validate(club, Globals.GetCurrentUser(), PermissionItemKeys.Instance().EditClub());
            club = Clubs.GetClub(clubID, isRealTime);
            if (!club.HasLogo)
            {
                switch (clubLogoSizeTypes)
                {
                    case ClubLogoSizeTypes.Small:
                        return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/club_nophoto_small.gif");
                    case ClubLogoSizeTypes.Normal:
                    default:
                        return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/club_nophoto.gif");
                }
            }

            if (enableClientCaching && (clubLogoSizeTypes != ClubLogoSizeTypes.Original) && FileStorageProvider.Instance(ClubLogos.StorageProviderName).EnableDirectlyUrl)
                return ClubLogos.GetDirectlyUrl(clubID, clubLogoSizeTypes);

            if (enableClientCaching)
                return WebUtils.ResolveUrl(string.Format("~/services/Club/ClubLogo.ashx?clubID={0}&clubLogoSizeType={1}", clubID, (int)clubLogoSizeTypes));
            else
                return WebUtils.ResolveUrl(string.Format("~/services/Club/ClubLogo.ashx?clubID={0}&clubLogoSizeType={1}&enableCaching={2}", clubID, (int)clubLogoSizeTypes, enableClientCaching));
        }

        /// <summary>
        /// 显示群组Banner
        /// </summary>
        /// <param name="siteUrls"></param>
        /// <param name="clubID"></param>
        /// <param name="clubLogoSizeTypes"></param>
        /// <param name="enableClientCaching"></param>
        /// <returns></returns>
        public static string ClubBannerUrl(this SiteUrls siteUrls, int clubID, bool enableClientCaching)
        {
            Club club = Clubs.GetClub(clubID, false);
            if (club == null)
                return string.Empty;
            bool isRealTime = ClubPermission.Validate(club, Globals.GetCurrentUser(), PermissionItemKeys.Instance().EditClub());
            club = Clubs.GetClub(clubID, isRealTime);
            if (!club.HasBanner)
                return string.Empty;

            return WebUtils.ResolveUrl(string.Format("~/services/Club/ClubBanner.ashx?clubID={0}&enableCaching={1}", clubID, enableClientCaching));
        }

        #region 需重复配置的Url

        /// <summary>
        /// 群组频道首页
        /// </summary>
        public static string ChannelClubHome(this SiteUrls siteUrls)
        {
            return SPBUrlHelper.RouteUrl("Channel_Club_Home");
        }

        /// <summary>
        /// 管理群组成员
        /// </summary>
        public static string ManageClubMembers(this SiteUrls siteUrls, string clubDomainName, ClubMemberStatuses? status, ClubMembersSortBy? sortBy, SortOrder? sortOrder)
        {
            return SPBUrlHelper.RouteUrl("ClubDomain_Member_Home", new RouteValueDictionary { { "ClubDomainName", clubDomainName }, { "Status", status ?? ClubMemberStatuses.Pending }, { "SortBy", sortBy ?? ClubMembersSortBy.JoinDate }, { "SortOrder", sortOrder ?? SortOrder.Ascending } });
        }

        /// <summary>
        /// 发送群组邀请
        /// </summary>
        /// <param name="userDomainName">当前登录用户的DomainName</param>
        /// <param name="relativeItemID">群组ID</param>
        public static string CreateJoinClubInvitation(this SiteUrls siteUrls, string userDomainName, int relativeItemID)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "NewJoinClubInvitation" }, { "RelativeItemID", relativeItemID } });
        }

        /// <summary>
        /// 根据地区显示群组
        /// </summary>
        /// <param name="siteUrls"></param>
        /// <param name="areaCode"></param>
        /// <returns></returns>
        public static string ListClubsByArea(this SiteUrls siteUrls, string areaCode)
        {
            return SPBUrlHelper.RouteUrl("Channel_Club_Common", new RouteValueDictionary { { "action", "ListClubsByArea" }, { "areaCode", areaCode } });
        }

        /// <summary>
        /// 根据类别显示群组
        /// </summary>
        /// <param name="siteUrls"></param>
        /// <param name="categoryID"></param>
        /// <returns></returns>
        public static string ListClubsByCategory(this SiteUrls siteUrls, int categoryID)
        {
            return SPBUrlHelper.RouteUrl("Channel_Club_Common", new RouteValueDictionary { { "action", "ListClubsByCategory" }, { "categoryID", categoryID } });
        }

        /// <summary>
        /// 分享到群组
        /// </summary>
        public static string ShareToMyClubs(this SiteUrls siteUrls, int applicationID, string contentSubject, string contentBody, string contentImgUrl, string contentUrl, string contentAuthor, string shareAuthor, int contentUserID, int shareAuthorID)
        {
            return SPBUrlHelper.RouteUrl("Channel_Club_Common", new RouteValueDictionary { { "action", "ShareToMyClubs" }, { "applicationID", applicationID }, { "contentImgUrl", WebUtils.UrlEncode(contentImgUrl) }, { "contentUrl", WebUtils.UrlEncode(contentUrl) }, { "contentAuthor", WebUtils.UrlEncode(contentAuthor) }, { "shareAuthor", WebUtils.UrlEncode(shareAuthor) }, { "contentUserID", contentUserID }, { "shareAuthorID", shareAuthorID }, { "contentSubject", WebUtils.UrlEncode(contentSubject) }, { "contentBody", WebUtils.UrlEncode(contentBody) } });
        }

        #endregion
    }
}
