﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Common.Controllers;
using SpaceBuilder.Club;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using SpaceBuilder.Utils;
using SpaceBuilder.Club.Controllers;
using System.Drawing;
using System.Web.Routing;
using System.Web.Script.Serialization;
using SpaceBuilder.Forum;
using System.Web.UI;

namespace SpaceBuilder.Club.Controllers
{
    [HttpCompress]
    public class ClubManageController : ClubDomainControllerBase
    {

        //protected override void Authorize(SpaceBuilder.Clubs.Components.Club club)
        //{
        //    base.Authorize(club);
        //    if (!ClubMembers.IsClubAssistant(CurrentUser, club.ClubID))
        //        PermissionBase.RedirectOrExcpetion(SBExceptionType.AccessDenied);
        //}

        int clubApplicationID = ApplicationIDs.Instance().Club();
        /// <summary>
        /// 群组管理首页
        /// </summary>
        public ActionResult Home(string clubDomainName)
        {
            SetPageTitle(GetResourceString("Title_ClubManagerPage", clubApplicationID), clubDomainName);
            Club currentClub = GetCurrentClub(clubDomainName);

            if (!ClubMembers.HasClubManagerPermission(currentClub.ClubID, CurrentUser))
            {
                if (HttpContext.Request.IsAuthenticated)
                    throw new SPBException(ExceptionTypes.Instance().AccessDenied());
                else
                    HttpContext.Response.Redirect(SiteUrls.Instance().Login(true), true);
                return new EmptyResult();
            }

            string applicationNameInclub = GetResourceString("Title_Manager", clubApplicationID);
            BreadCrumb.AddBreadCrumbItem(currentClub.ClubName, SPBUrlHelper.Action("Home", "ClubDomain", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(applicationNameInclub, SPBUrlHelper.Action("Home", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            PagingDataSet<ClubMember> pds = ClubMembers.GetMembersForAdmin(currentClub.ClubID, ClubMemberStatuses.Pending, null, null, 100, 1);

            ViewData["requireJoinMemberCount"] = pds.TotalRecords;

            return this.View("Pages/Manage/Home.aspx", "Masters/Manage.master", currentClub);
            //return RedirectToAction("ClubInfo", "ClubManage",new RouteValueDictionary { {"clubDomainName",clubDomainName } });
        }

        #region Manage

        #region 群组公告

        /// <summary>
        /// 编辑群组公告
        /// </summary>
        public ActionResult EditClubPlacard(string clubDomainName)
        {
            Club currentClub = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(currentClub, CurrentUser, PermissionItemKeys.Instance().EditClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            SetPageTitle(GetResourceString("Title_EditClubPlacard", clubApplicationID));
            BreadCrumb.AddBreadCrumbItem(currentClub.ClubName, SPBUrlHelper.Action("Home", "ClubDomain", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_Manager", clubApplicationID), SPBUrlHelper.Action("Home", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_EditClubPlacard", clubApplicationID), SPBUrlHelper.Action("EditClubPlacard", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));

            return View("Pages/Manage/EditClubPlacard.aspx", "Masters/Manage.master", currentClub);
        }

        /// <summary>
        /// 更新群组公告
        /// </summary>
        public ActionResult UpdateClubNews(string clubDomainName)
        {
            Club currentClub = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(currentClub, CurrentUser, PermissionItemKeys.Instance().EditClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            currentClub.NewsForDataTransmission = HtmlScrubber.Clean(Request.Form.Get<string>("clubPlacardText", string.Empty), false, true);

            try
            {
                Clubs.UpdateClub(currentClub);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            }
            catch (Exception)
            {

                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
            }

            return EditClubPlacard(clubDomainName);
        }

        #endregion

        #region 群组菜单设置

        /// <summary>
        /// 显示菜单
        /// </summary>
        public ActionResult ManageClubNavigations(string clubDomainName)
        {
            SetPageTitle(GetResourceString("Title_ManageClubNavigations", clubApplicationID), clubDomainName);
            SpaceBuilder.Club.Club currentClub = Clubs.GetClub(clubDomainName, false);
            if (!ClubPermission.AccessCheck(currentClub, CurrentUser, PermissionItemKeys.Instance().EditClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();
            BreadCrumb.AddBreadCrumbItem(currentClub.ClubName, SPBUrlHelper.Action("Home", "ClubDomain", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_Manager", clubApplicationID), SPBUrlHelper.Action("Home", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_ManageClubNavigations", clubApplicationID), SPBUrlHelper.Action("ClubMenus", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));

            IList<OwnerNavigation> clubNavigations = Navigations.GetOwnerNavigations(PresentAreaIDs.Instance().ClubDomain(), currentClub.ClubID, true);
            return this.View("Pages/Manage/ManageClubNavigations.aspx", "Masters/Manage.master", clubNavigations);
        }

        /// <summary>
        /// 删除导航
        /// </summary>
        public ActionResult DeleteClubNavigation(string clubDomainName, int ownerNavigationID)
        {
            if (ownerNavigationID > 0)
                Navigations.DeleteOwnerNavigation(ownerNavigationID);
            return new EmptyResult();
        }

        /// <summary>
        /// 更新菜单
        /// </summary>
        public ActionResult UpdateClubNavigations(string clubDomainName)
        {
            Club currentClub = Clubs.GetClub(clubDomainName, false);
            if (currentClub == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_ClubNotExist", clubApplicationID), clubDomainName)));
            }

            if (!ClubPermission.AccessCheck(currentClub, CurrentUser, PermissionItemKeys.Instance().EditClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            int count = Request.Form.GetInt("totalOptionCount", 0);
            List<OwnerNavigation> ownerNavigations = new List<OwnerNavigation>();
            for (int i = 0; i < count; i++)
            {
                OwnerNavigation ownerNavigation = null;
                int navID = Request.Form.GetInt(string.Format("navID_{0}", i), 0);
                int defaultNavID = Request.Form.GetInt(string.Format("DefaultNavID_{0}", i), 0);
                if (navID > 0)
                {
                    ownerNavigation = Navigations.GetOwnerNavigation(navID, true);
                    if (ownerNavigation != null)
                    {
                        ownerNavigation.NavigationText = Request.Form.GetString(string.Format("navigationText_{0}", i), ownerNavigation.NavigationText);
                        ownerNavigation.NavigationTarget = Request.Form.GetBool(string.Format("navigationTarget_{0}", i), false) ? "_blank" : "_self";
                        ownerNavigation.NavigationUrl = Request.Form.GetString(string.Format("navigationLink_{0}", i), ownerNavigation.NavigationUrl);
                        ownerNavigation.DisplayOrder = Request.Form.GetInt(string.Format("displayOrder_{0}", i), ownerNavigation.DisplayOrder);
                        if (!ownerNavigation.IsLocked)
                            ownerNavigation.IsEnabled = Request.Form.GetBool(string.Format("isEnabled_{0}", i), false);
                        ownerNavigation.NavigationText = Formatter.FormatSingleLinePlainTextForStorage(ownerNavigation.NavigationText);
                    }
                }
                else
                {
                    if (defaultNavID > 0)
                    {
                        Navigation navigation = Navigations.GetDefaultNavigation(defaultNavID, false);
                        if (navigation != null)
                            ownerNavigation = new OwnerNavigation(currentClub.ClubID, navigation);
                    }
                    else
                    {
                        ownerNavigation = new OwnerNavigation();
                        ownerNavigation.OwnerID = currentClub.ClubID;
                        ownerNavigation.NavigationType = NavigationTypes.HyperLink;
                        ownerNavigation.PresentAreaID = PresentAreaIDs.Instance().ClubDomain();
                    }

                    ownerNavigation.NavigationText = Request.Form.GetString(string.Format("navigationText_{0}", i), ownerNavigation.NavigationText);
                    ownerNavigation.NavigationUrl = Request.Form.GetString(string.Format("navigationLink_{0}", i), ownerNavigation.NavigationUrl);
                    if (string.IsNullOrEmpty(ownerNavigation.NavigationText))
                        continue;
                    ownerNavigation.NavigationTarget = Request.Form.GetBool(string.Format("navigationTarget_{0}", i), false) ? "_blank" : "_self";
                    ownerNavigation.DisplayOrder = Request.Form.GetInt(string.Format("displayOrder_{0}", i), ownerNavigation.DisplayOrder);
                    if (!ownerNavigation.IsLocked)
                        ownerNavigation.IsEnabled = Request.Form.GetBool(string.Format("isEnabled_{0}", i), false);
                    ownerNavigation.NavigationText = Formatter.FormatSingleLinePlainTextForStorage(ownerNavigation.NavigationText);
                }
                ownerNavigations.Add(ownerNavigation);
            }

            Navigations.UpdateOwnerNavigations(PresentAreaIDs.Instance().ClubDomain(), currentClub.ClubID, ownerNavigations);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;

            return RedirectToAction("ManageClubNavigations", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } });
        }


        /// <summary>
        /// 更新保存群组导航
        /// </summary>
        public ActionResult UpdateClubNavigation(string clubDomainName, int? navigationID)
        {
            Club currentClub = GetCurrentClub(clubDomainName);
            OwnerNavigation clubNavigation = null;
            if (navigationID.HasValue && navigationID.Value > 0)
            {
                clubNavigation = Navigations.GetOwnerNavigation(navigationID.Value, true);
            }
            else
            {
                clubNavigation = new OwnerNavigation();
                clubNavigation.NavigationType = NavigationTypes.HyperLink;
                clubNavigation.OwnerID = currentClub.ClubID;
            }
            clubNavigation.NavigationText = Request.Form.GetString("navigationText", clubNavigation.NavigationText);
            clubNavigation.NavigationUrl = Request.Form.GetString("navigationUrl", clubNavigation.NavigationUrl);
            clubNavigation.NavigationTarget = Request.Form.GetString("navigationTarget", clubNavigation.NavigationTarget);
            clubNavigation.IsEnabled = Request.Form.GetBool("isEnabled", clubNavigation.IsEnabled);
            if (navigationID.HasValue && navigationID.Value > 0)
            {
                Navigations.UpdateOwnerNavigation(clubNavigation);
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, GetResourceString("Message_UpdateClubLinkSuccess", clubApplicationID));
            }
            else
            {
                Navigations.CreateOwnerNavigation(clubNavigation);
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, GetResourceString("Message_CreateClubLinkSuccess", clubApplicationID));
            }
            return RedirectToAction("Control_EditClubNavigation", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "navigationID", clubNavigation.OwnerNavigationID } });
        }

        #endregion

        #region 群组资料更新

        /// <summary>
        /// 显示资料
        /// </summary>
        /// <param name="clubDomainName"></param>
        /// <returns></returns>
        public ActionResult ClubInfo(string clubDomainName)
        {
            SetPageTitle(GetResourceString("Title_UpdateClubInfo", clubApplicationID), clubDomainName);
            SpaceBuilder.Club.Club userClub = Clubs.GetClub(clubDomainName, true);
            if (!ClubPermission.AccessCheck(userClub, CurrentUser, PermissionItemKeys.Instance().EditClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            BreadCrumb.AddBreadCrumbItem(userClub.ClubName, SPBUrlHelper.Action("Home", "ClubDomain", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_Manager", clubApplicationID), SPBUrlHelper.Action("Home", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_UpdateClubInfo", clubApplicationID), SPBUrlHelper.Action("ClubInfo", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));

            ViewData["UserClub"] = userClub;
            User currentUser = Globals.GetCurrentUser();
            if (currentUser.IsContentAdministrator)
                ViewData["isManager"] = true;
            else
                ViewData["isManager"] = false;

            if (userClub.HasLogo)
                ViewData["canCropLogo"] = true;

            ForumSectionGroup group = ForumSectionGroups.GetGroup(PresentAreaIDs.Instance().ClubDomain(), userClub.ClubID, true);
            if (group != null)
                ViewData["allowEnableClub"] = true;

            return this.View("Pages/Manage/ManageUpdateClubInfo.aspx", "Masters/Manage.master");
        }

        /// <summary>
        /// 更新资料
        /// </summary>
        /// <param name="clubDomainName"></param>
        /// <returns></returns>
        public ActionResult UpdateClubInfo(string clubDomainName)
        {
            SpaceBuilder.Club.Club userClub = Clubs.GetClub(clubDomainName, true);
            if (!ClubPermission.AccessCheck(userClub, CurrentUser, PermissionItemKeys.Instance().EditClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            userClub.ClubName = Request.Form.GetString("ClubName", string.Empty);
            userClub.Brief = Request.Form.GetString("Brief", string.Empty);
            if (string.IsNullOrEmpty(userClub.ClubName) || string.IsNullOrEmpty(userClub.Brief))
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_ClubInfoUpdateError", clubApplicationID);
            }
            else
            {
                userClub.CategoryID = Request.Form.GetInt("CategoryID", -1);
                userClub.AuditingStatus = (AuditingStatuses)Request.Form.GetInt("AuditingStatus", (int)userClub.AuditingStatus);
                userClub.AreaCode = Request.Form.GetString("areaCode", string.Empty);
                //UserClub.AboutUs = Request.Form.GetString("AboutUs", string.Empty);
                userClub.JoinNotice = Request.Form.GetString("JoinNotice", string.Empty);
                userClub.ClubHeaderShowTypes = (ClubHeaderShowTypes)Request.Form.GetInt("headerShowType", (int)ClubHeaderShowTypes.ShowBannerAndText);
                userClub.IsPublic = Request.Form.Get<bool>("clubSecrecyType", true);
                if (userClub.IsPublic)
                    userClub.IsMemberNeedAuthorize = Request.Form.Get<bool>("needApproveCheckbox", false);

                bool isEnabled = Request.Form.GetBool("IsEnabled", userClub.IsEnabled);
                if (!userClub.IsEnabled && isEnabled)
                {
                    ForumSectionGroup group = ForumSectionGroups.GetGroup(PresentAreaIDs.Instance().ClubDomain(), userClub.ClubID, true);
                    if (group != null)
                        userClub.IsEnabled = isEnabled;
                }
                else
                    userClub.IsEnabled = isEnabled;

                Clubs.UpdateClub(userClub);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                if (userClub.AuditingStatus == AuditingStatuses.Again)
                    TempData["StatusMessageContent"] = GetResourceString("Message_ClubInfoUpdateSuccessNeedAudit", clubApplicationID);
                else
                    TempData["StatusMessageContent"] = GetResourceString("Message_ClubInfoUpdateSuccess", clubApplicationID);
            }
            return RedirectToAction("ClubInfo", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } });
        }

        public ActionResult ClubLogo(string clubDomainName)
        {
            SetPageTitle(GetResourceString("Title_UpdateClubLogo", clubApplicationID), clubDomainName);
            SpaceBuilder.Club.Club UserClub = Clubs.GetClub(clubDomainName, true);
            if (UserClub == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_ClubNotExist", clubApplicationID), clubDomainName)));
            }
            if (!ClubPermission.AccessCheck(UserClub, CurrentUser, PermissionItemKeys.Instance().EditClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            BreadCrumb.AddBreadCrumbItem(UserClub.ClubName, SPBUrlHelper.Action("Home", "ClubDomain", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_Manager", clubApplicationID), SPBUrlHelper.Action("Home", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_UpdateClubLogo", clubApplicationID), SPBUrlHelper.Action("ClubLogo", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));

            ViewData["UserClub"] = UserClub;
            if (UserClub.HasLogo)
                ViewData["canCropLogo"] = true;
            return View("Pages/Manage/ClubLogo.aspx", "Masters/Manage.master");
        }

        public ActionResult ClubBanner(string clubDomainName)
        {
            SetPageTitle(GetResourceString("Title_UpdateClubBanner", clubApplicationID), clubDomainName);
            SpaceBuilder.Club.Club UserClub = Clubs.GetClub(clubDomainName, true);
            if (UserClub == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_ClubNotExist", clubApplicationID), clubDomainName)));
            }
            if (!ClubPermission.AccessCheck(UserClub, CurrentUser, PermissionItemKeys.Instance().EditClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            ViewData["UserClub"] = UserClub;
            return View("Pages/Manage/ClubBanner.aspx", "Masters/Manage.master");
        }

        /// <summary>
        /// 处理图像上传
        /// </summary>
        //[AcceptVerbs(HttpVerbs.Post)]
        //public ContentResult UploadClubLogo(string clubDomainName)
        //{
        //    //System.Threading.Thread.Sleep(5000);

        //    System.Web.HttpPostedFileBase LogoFile = null;

        //    if (Request.Files != null && Request.Files.Count > 0)
        //        LogoFile = Request.Files[0];

        //    Club clubedit = Clubs.GetClub(clubDomainName);
        //    if (!ClubPermission.AccessCheck(clubedit, CurrentUser, PermissionItemKeys.Instance().EditClub(), HttpContext, SiteUrls.Instance().Login(true)))
        //        return new ContentResult();

        //    //string jsoncall = Request.QueryString.GetString("jsoncallback", string.Empty);
        //    //JavaScriptSerializer serializer = new JavaScriptSerializer();

        //    if (clubedit == null)
        //    {
        //        return Content(string.Format(GetResourceString("Exception_Pattern_ClubNotExist", clubApplicationID), clubDomainName));
        //        //return Content(string.Format("{0}({1})", jsoncall, serializer.Serialize(string.Format(GetResourceString("Exception_Pattern_ClubNotExist", clubApplicationID), clubDomainName))));
        //        //return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_ClubNotExist", clubApplicationID), clubDomainName)));
        //    }


        //    if (LogoFile == null || LogoFile.ContentLength == 0)
        //    {
        //        return Content(GetResourceString("Message_PleaseChooseUploadPhoto", clubApplicationID));
        //        //return Content(string.Format("{0}({1})", jsoncall, serializer.Serialize(GetResourceString("Message_PleaseChooseUploadPhoto", clubApplicationID))));
        //        // TempData["StatusMessageType"] = (int)StatusMessageType.Error;
        //        //TempData["StatusMessageContent"] = GetResourceString("Message_PleaseChooseUploadPhoto", clubApplicationID);
        //        //return RedirectToAction("ClubLogo", new RouteValueDictionary { { "clubDomainName", clubDomainName } });
        //    }

        //    if (LogoFile.ContentLength > 5 * 1024 * 1024)
        //    {
        //        return Content(string.Format(GetResourceString("Message_UploadNotAllow", clubApplicationID), "5"));
        //        //return Content(string.Format("{0}({1})", jsoncall, serializer.Serialize(string.Format(GetResourceString("Message_UploadNotAllow", clubApplicationID), "5"))));
        //        //TempData["StatusMessageType"] = (int)StatusMessageType.Error;
        //        //TempData["StatusMessageContent"] = string.Format(GetResourceString("Message_UploadNotAllow", clubApplicationID), "5");
        //        //return RedirectToAction("ClubLogo", new RouteValueDictionary { { "clubDomainName", clubDomainName } });
        //    }

        //    if (LogoFile.ContentType.IndexOf("image") == -1)
        //    {
        //        return Content(GetResourceString("Message_PleaseChooseUploadPhoto", clubApplicationID));
        //        //return Content(string.Format("{0}({1})", jsoncall, serializer.Serialize(GetResourceString("Message_PleaseChooseUploadPhoto", clubApplicationID))));
        //        //TempData["StatusMessageType"] = (int)StatusMessageType.Error;
        //        //TempData["StatusMessageContent"] = GetResourceString("Message_PleaseChooseUploadPhoto", clubApplicationID);
        //        // return RedirectToAction("ClubLogo", new RouteValueDictionary { { "clubDomainName", clubDomainName } });
        //    }
        //    else
        //    {
        //        //SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
        //        try
        //        {
        //            using (Bitmap bitmapOriginal = new Bitmap(LogoFile.InputStream))
        //            {
        //                if (bitmapOriginal.Width < ClubDomainConfiguration.Instance().SmallLogoWidth || bitmapOriginal.Height < ClubDomainConfiguration.Instance().SmallLogoHeight)
        //                {
        //                    return Content(string.Format(GetResourceString("Message_UploadPhotoSize", clubApplicationID), ClubDomainConfiguration.Instance().SmallLogoWidth, ClubDomainConfiguration.Instance().SmallLogoHeight));
        //                    //return Content(string.Format("{0}({1})", jsoncall, serializer.Serialize(string.Format(GetResourceString("Message_UploadPhotoSize", clubApplicationID), ClubDomainConfiguration.Instance().SmallLogoWidth, ClubDomainConfiguration.Instance().SmallLogoHeight))));
        //                    //TempData["StatusMessageType"] = (int)StatusMessageType.Error;
        //                    //TempData["StatusMessageContent"] = string.Format(GetResourceString("Message_UploadPhotoSize", clubApplicationID), ClubDomainConfiguration.Instance().SmallLogoWidth, ClubDomainConfiguration.Instance().SmallLogoHeight);
        //                    //return RedirectToAction("ClubLogo", new RouteValueDictionary { { "clubDomainName", clubDomainName } });
        //                }
        //            }
        //        }
        //        catch { }
        //    }

        //    ClubLogos.UploadOriginalClubLogo(clubedit.ClubID, LogoFile.InputStream);
        //    return Content("success");
        //    //return Content(string.Format("{0}({1})", jsoncall, serializer.Serialize("success")));
        //    // return RedirectToAction("CropClubLogo", new RouteValueDictionary { { "clubDomainName", clubDomainName } });
        //}

        /// <summary>
        /// 裁剪图像
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult CropClubLogo(string clubDomainName)
        {
            SetPageTitle(GetResourceString("Title_CutClubLogo", clubApplicationID), clubDomainName);
            Club clubedit = Clubs.GetClub(clubDomainName, true);
            if (clubedit == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_ClubNotExist", clubApplicationID), clubDomainName)));
            }
            if (!ClubPermission.AccessCheck(clubedit, CurrentUser, PermissionItemKeys.Instance().EditClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            if (!clubedit.HasLogo)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_NoPhotoToCut", clubApplicationID);
            }
            ViewData["CLubID"] = clubedit.ClubID;
            return View("Pages/Manage/CropClubLogo.aspx", "Masters/Manage.master");
        }

        /// <summary>
        /// 裁剪图像处理
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ContentResult CropClubLogoAction(string clubDomainName)
        {
            //System.Threading.Thread.Sleep(5000);

            string jsoncall = Request.QueryString.GetString("jsoncallback", string.Empty);
            JavaScriptSerializer serializer = new JavaScriptSerializer();

            Club clubedit = Clubs.GetClub(clubDomainName, false);
            if (clubedit == null)
            {
                return Content(string.Format("{0}({1})", jsoncall, serializer.Serialize(new { Status = "Error", Message = string.Format(GetResourceString("Exception_Pattern_ClubNotExist", clubApplicationID), clubDomainName) })));
                //return Json(new { Status = "Error", Message = string.Format(GetResourceString("Exception_Pattern_ClubNotExist", clubApplicationID), clubDomainName) });
                //return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_ClubNotExist", clubApplicationID), clubDomainName)));
            }
            if (!ClubPermission.AccessCheck(clubedit, CurrentUser, PermissionItemKeys.Instance().EditClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new ContentResult();


            bool autoCrop = Request.QueryString.GetBool("autoCrop", true);
            //            bool autoCrop = Request.Form.GetBool("autoCrop", true);
            if (autoCrop)
            {
                ClubLogos.CropClubLogo(clubedit.ClubID);
                return Content(string.Format("{0}({1})", jsoncall, serializer.Serialize(new { Status = "Success", Message = GetResourceString("Message_CutLogoSuccess", clubApplicationID) })));
                //return Json(new { Status = "Success", Message = GetResourceString("Message_CutLogoSuccess", clubApplicationID) });
                //TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                //TempData["StatusMessageContent"] = GetResourceString("Message_CutLogoSuccess", clubApplicationID);
                //return RedirectToAction("ClubLogo", new RouteValueDictionary { { "clubDomainName", clubDomainName } });
            }
            else
            {
                //float cropImageWidth = Request.Form.GetFloat("cropImageWidth", ClubDomainConfiguration.Instance().LogoWidth);
                float cropImageWidth = Request.QueryString.GetFloat("cropImageWidth", ClubDomainConfiguration.Instance().LogoWidth);
                float cropImageHeight = cropImageWidth / ClubDomainConfiguration.Instance().LogoWidth * ClubDomainConfiguration.Instance().LogoHeight;
                //float cropImageX = Request.Form.GetFloat("cropImageX", 0F);
                //float cropImageY = Request.Form.GetFloat("cropImageY", 0F);
                float cropImageX = Request.QueryString.GetFloat("cropImageX", 0F);
                float cropImageY = Request.QueryString.GetFloat("cropImageY", 0F);

                ClubLogos.CropClubLogo(clubedit.ClubID, cropImageWidth, cropImageHeight, cropImageX, cropImageY);
                return Content(string.Format("{0}({1})", jsoncall, serializer.Serialize(new { Status = "Success", Message = GetResourceString("Message_CutLogoSuccess", clubApplicationID) })));
                //return Json(new { Status = "Success", Message = GetResourceString("Message_CutLogoSuccess", clubApplicationID) });
                //TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                //TempData["StatusMessageContent"] = GetResourceString("Message_CutLogoSuccess", clubApplicationID);
                //return RedirectToAction("ClubLogo", new RouteValueDictionary { { "clubDomainName", clubDomainName } });
            }
        }
        #endregion

        #region 广告管理

        #region Show

        /// <summary>
        /// 广告管理
        /// </summary>
        /// <param name="clubDomainName"></param>
        /// <param name="pageIndex"></param>
        /// <returns></returns>
        public ActionResult ManageAdvertisings(string clubDomainName, int? pageIndex)
        {
            if (!SiteSettingsManager.GetSiteSettings().EnableClubAD)
            {
                throw new SPBException(ExceptionTypes.Instance().AccessDenied());
            }

            Club currentClub = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(currentClub, CurrentUser, PermissionItemKeys.Instance().ManageClubAdvertising(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            SetPageTitle(GetResourceString("Title_ManageAdvertisings", clubApplicationID), clubDomainName);
            BreadCrumb.AddBreadCrumbItem(currentClub.ClubName, SPBUrlHelper.Action("Home", "ClubDomain", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_Manager", clubApplicationID), SPBUrlHelper.Action("Home", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_ManageAdvertisings", clubApplicationID), "");

            PagingDataSet<Advertising> pds = Advertisings.GetAdvertisings(10, pageIndex ?? 1, PresentAreaIDs.Instance().ClubDomain(), currentClub.ClubID);

            return View("Pages/Manage/ManageAdvertisings.aspx", "Masters/Manage.master", pds);
        }

        /// <summary>
        /// 编辑广告
        /// </summary>
        /// <param name="clubDomainName"></param>
        /// <param name="advertisingID"></param>
        /// <returns></returns>
        public ActionResult EditAdvertising(string clubDomainName, int? advertisingID)
        {
            if (!SiteSettingsManager.GetSiteSettings().EnableClubAD)
            {
                throw new SPBException(ExceptionTypes.Instance().AccessDenied());
            }

            Club currentClub = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(currentClub, CurrentUser, PermissionItemKeys.Instance().EditClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            BreadCrumb.AddBreadCrumbItem(currentClub.ClubName, SPBUrlHelper.Action("Home", "ClubDomain", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_Manager", clubApplicationID), SPBUrlHelper.Action("Home", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_EditAdvertising", clubApplicationID), "");

            Advertising advertising = new Advertising();

            if (advertisingID.HasValue && advertisingID.Value > 0)
            {
                SetPageTitle(GetResourceString("Title_EditAdvertising", clubApplicationID), clubDomainName);
                advertising = Advertisings.GetAdvertising(advertisingID.Value, true);
                if (advertising == null)
                {
                    return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_AdvertisingNotFind", clubApplicationID), advertisingID)));

                }
            }
            else
            {
                SetPageTitle(GetResourceString("Title_CreateAdvertising", clubApplicationID), clubDomainName);
                if (TempData["Advertising"] != null)
                {
                    advertising = TempData["Advertising"] as Advertising;
                }
                else
                {
                    advertising.EffectiveDateFrom = DateTime.Now;
                    advertising.EffectiveDateTo = advertising.EffectiveDateFrom.AddMonths(1);
                }
            }

            return View("Pages/Manage/EditAdvertising.aspx", "Masters/Manage.master", advertising);
        }

        /// <summary>
        /// 广告投放时显示的广告位列表
        /// </summary>
        /// <param name="advertisingID"></param>
        /// <param name="width"></param>
        /// <returns></returns>
        public ActionResult Control_ListAdvertisingPositions(string clubDomainName, int? advertisingID, int? width)
        {
            if (!SiteSettingsManager.GetSiteSettings().EnableClubAD)
            {
                throw new SPBException(ExceptionTypes.Instance().AccessDenied());
            }

            List<AdvertisingPosition> position = Advertisings.GetAdvertisingPositions(PresentAreaIDs.Instance().ClubDomain());

            List<int> widthList = Advertisings.GetAdvertisingPositionWidths();
            ViewData["widthList"] = widthList;

            if (advertisingID.HasValue && advertisingID.Value > 0)
            {
                Advertising advertising = Advertisings.GetAdvertising(advertisingID.Value, true);
                if (advertising == null)
                {
                    return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_AdvertisingNotFind", clubApplicationID), advertisingID)));
                }

                ViewData["selectedPosition"] = advertising.UsedAdvertisingPositions;
            }

            if (width.HasValue && width.Value > 0)
            {
                ViewData["currentWidth"] = width.Value;
            }

            return PartialView("Controls/Manage/ListAdvertisingPositions.ascx", position);
        }

        #endregion

        #region Manage

        /// <summary>
        /// 创建更新广告
        /// </summary>
        /// <param name="advertisingID"></param>
        /// <returns></returns>
        public ActionResult CreateUpdateAdvertising(string clubDomainName, int? advertisingID)
        {
            if (!SiteSettingsManager.GetSiteSettings().EnableClubAD)
            {
                throw new SPBException(ExceptionTypes.Instance().AccessDenied());
            }

            Club currentClub = GetCurrentClub(clubDomainName);

            if (!ClubPermission.AccessCheck(currentClub, Globals.GetCurrentUser(), PermissionItemKeys.Instance().ManageClubAdvertising(), this.HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            Advertising advertising = new Advertising();

            if (advertisingID.HasValue && advertisingID.Value > 0)
            {
                advertising = Advertisings.GetAdvertising(advertisingID.Value, true);
                if (advertising == null)
                {
                    return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_AdvertisingNotFind", clubApplicationID), advertisingID)));

                }
            }

            advertising.AdvertisingName = Request.Form.GetString("advertisingName", string.Empty).Trim();
            advertising.AdvertisingType = (AdvertisingTypes)Request.Form.GetInt("advertisingType", 0);
            advertising.IsEnabled = Request.Form.GetBool("isEnabled", true);
            advertising.PresentAreaID = PresentAreaIDs.Instance().ClubDomain();
            advertising.OwnerID = currentClub.ClubID;
            advertising.Script = Request.Form.GetString("script", string.Empty).Trim();

            DateTime datetime;
            if (DateTime.TryParse(Request.Form.GetString("effectiveDateFrom", string.Empty).Trim(), out datetime))
            {
                advertising.EffectiveDateFrom = datetime;
            }
            else
            {
                if (!advertisingID.HasValue || advertisingID.Value <= 0)
                {
                    TempData["Advertising"] = advertising;
                }

                TempData["StatusMessageType"] = (int)StatusMessageType.Hint;
                TempData["StatusMessageContent"] = GetResourceString("Message_StartTimeFormatError", clubApplicationID);
                return RedirectToAction("EditAdvertising", new RouteValueDictionary { { "advertisingID", advertisingID } });
            }

            if (DateTime.TryParse(Request.Form.GetString("effectiveDateTo", string.Empty).Trim(), out datetime))
            {
                advertising.EffectiveDateTo = datetime;
            }
            else
            {
                if (!advertisingID.HasValue || advertisingID.Value <= 0)
                {
                    TempData["Advertising"] = advertising;
                }

                TempData["StatusMessageType"] = (int)StatusMessageType.Hint;
                TempData["StatusMessageContent"] = GetResourceString("Message_EndTimeFormatError", clubApplicationID);
                return RedirectToAction("EditAdvertising", new RouteValueDictionary { { "advertisingID", advertisingID } });
            }

            if (advertising.EffectiveDateFrom > advertising.EffectiveDateTo)
            {
                if (!advertisingID.HasValue || advertisingID.Value <= 0)
                {
                    TempData["Advertising"] = advertising;
                }

                TempData["StatusMessageType"] = (int)StatusMessageType.Hint;
                TempData["StatusMessageContent"] = GetResourceString("Message_StartTimeCannotLessEndTime", clubApplicationID);
                return RedirectToAction("EditAdvertising", new RouteValueDictionary { { "advertisingID", advertisingID } });
            }

            if (advertisingID.HasValue && advertisingID.Value > 0)
            {
                Advertisings.UpdateAdvertising(advertising);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            }
            else
            {
                try
                {
                    Advertisings.CreateAdvertising(advertising);

                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                }
                catch (Exception)
                {
                    TempData["Advertising"] = advertising;
                    TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                    TempData["StatusMessageContent"] = GetResourceString("Message_CreateAdvertisingError", clubApplicationID);
                }
            }

            string[] positionCodes = null;
            List<string> positionCodeList = new List<string>();
            //bool isError = false;
            if (!string.IsNullOrEmpty(Request.Form.GetString("positionCheckBoxGroup", string.Empty)))
            {
                positionCodes = Request.Form.GetString("positionCheckBoxGroup", string.Empty).Split(',');
                if (positionCodes != null && positionCodes.Length > 0)
                {
                    //List<AdvertisingPosition> selectPosition = advertising.UsedAdvertisingPositions;
                    foreach (var positionCode in positionCodes)
                    {
                        //AdvertisingPosition position = Advertisings.GetAdvertisingPosition(positionCode);
                        //if (selectPosition.Contains(position) || position.CanAddAdvertisings())
                        //{
                        positionCodeList.Add(positionCode);
                        //}
                        //else
                        //{
                        //    if (isError)
                        //        continue;
                        //    isError = true;
                        //}
                    }
                }
            }

            //if (isError)
            //{
            //    if (!advertisingID.HasValue || advertisingID.Value <= 0)
            //        TempData["Advertising"] = advertising;

            //    TempData["StatusMessageType"] = (int)StatusMessageType.Hint;
            //    TempData["StatusMessageContent"] = "投放的广告数超过广告位最大限制，部分广告会投放失败";
            //}

            Advertisings.UpdatePositionsOfAdvertising(advertising.AdvertisingID, positionCodeList);

            return RedirectToAction("EditAdvertising", new RouteValueDictionary { { "advertisingID", advertisingID } });
        }

        /// <summary>
        /// 删除广告
        /// </summary>
        /// <returns></returns>
        public ActionResult DeleteAdvertisings(string clubDomainName)
        {
            if (!SiteSettingsManager.GetSiteSettings().EnableClubAD)
            {
                throw new SPBException(ExceptionTypes.Instance().AccessDenied());
            }

            Club currentClub = GetCurrentClub(clubDomainName);

            if (!ClubPermission.AccessCheck(currentClub, Globals.GetCurrentUser(), PermissionItemKeys.Instance().ManageClubAdvertising(), this.HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            string[] advertisingCodes = null;
            if (!string.IsNullOrEmpty(Request.Form.GetString("advertisingCheckBoxGroup", string.Empty)))
            {
                advertisingCodes = Request.Form.GetString("advertisingCheckBoxGroup", string.Empty).Split(',');
                if (advertisingCodes != null && advertisingCodes.Length > 0)
                {
                    List<int> advertisingIDs = new List<int>();
                    foreach (var id in advertisingCodes)
                    {
                        if (Convert.ToInt32(id) > 0)
                            advertisingIDs.Add(Convert.ToInt32(id));
                    }
                    Advertisings.DeleteAdvertisings(PresentAreaIDs.Instance().ClubDomain(), advertisingIDs.ToArray());
                }
            }

            return RedirectToAction("ManageAdvertisings");
        }

        #endregion

        #endregion

        #region 友情连接
        /// <summary>
        /// 显示友情连接
        /// </summary>
        /// <param name="clubDomainName">群组clubDomainName</param>
        /// <returns></returns>
        [OutputCache(Location = OutputCacheLocation.None)]
        public ActionResult ManageClubLinks(string clubDomainName)
        {
            SetPageTitle(GetResourceString("Title_ManageFriendlyLink", clubApplicationID), clubDomainName);
            Club c = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(c, CurrentUser, PermissionItemKeys.Instance().ManageClubLink(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            BreadCrumb.AddBreadCrumbItem(c.ClubName, SPBUrlHelper.Action("Home", "ClubDomain", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_Manager", clubApplicationID), SPBUrlHelper.Action("Home", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_ManageFriendlyLink", clubApplicationID), SPBUrlHelper.Action("ClubMenus", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            ViewData["ClubLinks"] = ClubLinkManager.Instance().GetLinksForManage(c.ClubID);
            return View("Pages/Manage/ManageLinks.aspx", "Masters/Manage.master");
        }
        /// <summary>
        /// 显示添加友情连接
        /// </summary>
        /// <param name="clubDomainName">群组clubDomainName</param>
        /// <returns></returns>
        public ActionResult Control_AddLink(string clubDomainName)
        {
            Club c = GetCurrentClub(clubDomainName);
            ClubLinkManager ClManage = ClubLinkManager.Instance();
            List<LinkCategory> listLinkCate = ClManage.GetLinkCategoriesByOwnerID(c.ClubID, true);
            if (listLinkCate == null || listLinkCate.Count <= 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Hint;
                TempData["StatusMessageContent"] = GetResourceString("Message_NoLinkCategoryPleaseAddFirst", clubApplicationID);
                return RedirectToAction("Control_AddLinkCategory", "ClubManage");
            }
            ViewData["LinkCategories"] = listLinkCate;

            int statusMessageType = Request.QueryString.GetInt("StatusMessageType", -2);
            string statusMessageContent = WebUtils.UrlDecode(Request.QueryString.GetString("StatusMessageContent", string.Empty));
            if (statusMessageType > -2)
            {
                TempData["StatusMessageType"] = statusMessageType;
            }

            if (!string.IsNullOrEmpty(statusMessageContent))
            {
                TempData["StatusMessageContent"] = statusMessageContent;
            }

            return PartialView("Controls/Manage/EditClubLink.ascx");
        }
        /// <summary>
        /// 添加友情连接
        /// </summary>
        /// <param name="clubDomainName">群组clubDomainName</param>
        /// <returns></returns>
        public ActionResult Control_AddLinkAction(string clubDomainName)
        {
            Club c = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(c, CurrentUser, PermissionItemKeys.Instance().ManageClubLink(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            Link l = new Link();
            l.OwnerID = c.ClubID;
            l.Title = Request.Form.GetString("Title", string.Empty);
            l.LinkHref = Request.Form.GetString("linkUrl", string.Empty);
            l.LinkTitle = Request.Form.GetString("linkTitle", string.Empty);
            l.CategoryID = Request.Form.GetInt("linkcate", 0);
            l.LinkType = (LinkTypes)Request.Form.GetInt("UserLinkTypes", 1);
            l.IsEnabled = Request.Form.GetBool("isenable", false);
            l.DisplayOrder = Request.Form.GetInt("displayorder", 0);

            if (!string.IsNullOrEmpty(l.Title))
                l.Title = Formatter.FormatSingleLinePlainTextForStorage(l.Title);
            if (!string.IsNullOrEmpty(l.LinkTitle))
                l.LinkTitle = Formatter.FormatSingleLinePlainTextForStorage(l.LinkTitle);

            ClubLinkManager ClManage = ClubLinkManager.Instance();
            if (l.LinkType == LinkTypes.Image)
            {
                System.Web.HttpPostedFileBase picFile = null;
                if (Request.Files != null && Request.Files.Count > 0)
                    picFile = Request.Files[0];
                if (picFile == null)
                {
                    return Redirect(SPBConfig.Instance().MainSiteRootUrl + SPBUrlHelper.Action("Control_AddLink", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "StatusMessageType", (int)StatusMessageType.Hint }, { "StatusMessageContent", WebUtils.UrlEncode(GetResourceString("Message_PleaseChooseUploadPhoto", clubApplicationID)) } }));
                }
                if (picFile.ContentType.IndexOf("image") == -1)
                {
                    return Redirect(SPBConfig.Instance().MainSiteRootUrl + SPBUrlHelper.Action("Control_AddLink", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "StatusMessageType", (int)StatusMessageType.Hint }, { "StatusMessageContent", WebUtils.UrlEncode(GetResourceString("Message_PleaseChooseUploadPhoto", clubApplicationID)) } }));
                }
                ClManage.CreateLink(l, picFile);
            }
            else
            {
                ClManage.CreateLink(l, null);
            }

            return Redirect(SPBConfig.Instance().MainSiteRootUrl + SPBUrlHelper.Action("Control_AddLink", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "StatusMessageType", (int)StatusMessageType.Success }, { "StatusMessageContent", WebUtils.UrlEncode(GetResourceString("Message_UploadSuccess", clubApplicationID)) } }));
        }
        /// <summary>
        /// 删除友情连接
        /// </summary>
        /// <param name="clubDomainName">群组clubDomainName</param>
        /// <returns></returns>
        public ActionResult DeleteLinkAction(string clubDomainName)
        {
            Club c = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(c, CurrentUser, PermissionItemKeys.Instance().ManageClubLink(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            string strLinks = Request.Form.GetString("LinkGroup", string.Empty);
            string[] UserLinks = strLinks.Split(',');
            List<int> LinkIDs = new List<int>();
            foreach (var item in UserLinks)
            {
                try
                {
                    LinkIDs.Add(Convert.ToInt32(item));
                }
                catch { }
            }
            ClubLinkManager ClManage = ClubLinkManager.Instance();
            ClManage.DeleteLinks(LinkIDs);
            return RedirectToAction("ManageClubLinks", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } });
        }
        /// <summary>
        /// 显示编辑友情连接
        /// </summary>
        /// <param name="clubDomainName">群组clubDomainName</param>
        /// <returns></returns>
        public ActionResult Control_EditLink(string clubDomainName, int linkID)
        {
            Club c = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(c, CurrentUser, PermissionItemKeys.Instance().ManageClubLink(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            List<LinkCategory> listLinkCate = ClubLinkManager.Instance().GetLinkCategoriesByOwnerID(c.ClubID, true);
            if (listLinkCate == null || listLinkCate.Count <= 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_NoLinkCategoryPleaseAddFirst", clubApplicationID);
                return RedirectToAction("Control_AddLinkCategory", "ClubManage");
            }
            ViewData["LinkCategories"] = listLinkCate;
            Link userlink = ClubLinkManager.Instance().GetLink(linkID, true);
            ViewData["UserLink"] = userlink;

            int statusMessageType = Request.QueryString.GetInt("StatusMessageType", -2);
            string statusMessageContent = WebUtils.UrlDecode(Request.QueryString.GetString("StatusMessageContent", string.Empty));
            if (statusMessageType > -2)
            {
                TempData["StatusMessageType"] = statusMessageType;
            }

            if (!string.IsNullOrEmpty(statusMessageContent))
            {
                TempData["StatusMessageContent"] = statusMessageContent;
            }

            return PartialView("Controls/Manage/EditClubLink.ascx");
        }
        /// <summary>
        /// 编辑友情连接
        /// </summary>
        /// <param name="clubDomainName">群组clubDomainName</param>
        /// <returns></returns>
        public ActionResult Control_EditLinkAction(string clubDomainName, int linkID)
        {
            Club c = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(c, CurrentUser, PermissionItemKeys.Instance().ManageClubLink(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            Link l = ClubLinkManager.Instance().GetLink(linkID, true);
            l.Title = Request.Form.GetString("Title", string.Empty);
            l.LinkHref = Request.Form.GetString("linkUrl", string.Empty);
            l.LinkTitle = Request.Form.GetString("linkTitle", string.Empty);
            l.CategoryID = Request.Form.GetInt("linkcate", 0);

            l.IsEnabled = Request.Form.GetBool("isenable", false);
            l.DisplayOrder = Request.Form.GetInt("displayorder", 0);

            if (!string.IsNullOrEmpty(l.Title))
                l.Title = Formatter.FormatSingleLinePlainTextForStorage(l.Title);
            if (!string.IsNullOrEmpty(l.LinkTitle))
                l.LinkTitle = Formatter.FormatSingleLinePlainTextForStorage(l.LinkTitle);

            //  l.LinkType = (LinkTypes)Request.Form.GetInt("UserLinkTypes", 1);

            if (l.LinkType == LinkTypes.Image)
            {
                l.LinkType = (LinkTypes)Request.Form.GetInt("UserLinkTypes", 1);
                if (l.LinkType == LinkTypes.Image)
                {
                    System.Web.HttpPostedFileBase picFile = null;
                    if (Request.Files != null && Request.Files.Count > 0)
                        picFile = Request.Files[0];
                    if (picFile != null && !string.IsNullOrEmpty(picFile.FileName))
                    {
                        if (picFile.ContentType.IndexOf("image") == -1)
                        {
                            return Redirect(SPBConfig.Instance().MainSiteRootUrl + SPBUrlHelper.Action("Control_EditLink", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "linkID", linkID }, { "StatusMessageType", (int)StatusMessageType.Hint }, { "StatusMessageContent", WebUtils.UrlEncode(GetResourceString("Message_PleaseChooseUploadPhoto", clubApplicationID)) } }));
                        }
                        ClubLinkManager.Instance().UpdateLink(l, picFile);
                    }
                    else
                    {
                        ClubLinkManager.Instance().UpdateLink(l, null);
                    }
                }
                else
                {
                    ClubLinkManager.Instance().UpdateLink(l, null);
                }
            }
            else
            {
                l.LinkType = (LinkTypes)Request.Form.GetInt("UserLinkTypes", 1);
                if (l.LinkType == LinkTypes.Image)
                {
                    System.Web.HttpPostedFileBase picFile = null;
                    if (Request.Files != null && Request.Files.Count > 0)
                        picFile = Request.Files[0];
                    if (picFile != null)
                    {
                        if (picFile.ContentType.IndexOf("image") == -1)
                        {
                            return Redirect(SPBConfig.Instance().MainSiteRootUrl + SPBUrlHelper.Action("Control_EditLink", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "linkID", linkID }, { "StatusMessageType", (int)StatusMessageType.Hint }, { "StatusMessageContent", WebUtils.UrlEncode(GetResourceString("Message_PleaseChooseUploadPhoto", clubApplicationID)) } }));
                        }
                        ClubLinkManager.Instance().UpdateLink(l, picFile);
                    }
                }
                else
                {
                    ClubLinkManager.Instance().UpdateLink(l, null);
                }
            }

            return Redirect(SPBConfig.Instance().MainSiteRootUrl + SPBUrlHelper.Action("Control_EditLink", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "linkID", linkID }, { "StatusMessageType", (int)StatusMessageType.Success }, { "StatusMessageContent", WebUtils.UrlEncode(GetResourceString("Message_EditSuccess", clubApplicationID)) } }));
        }

        #region 链接类别
        /// <summary>
        /// 显示友情连接类别
        /// </summary>
        /// <param name="clubDomainName">群组clubDomainName</param>
        /// <returns></returns>
        [OutputCache(Location = OutputCacheLocation.None)]
        public ActionResult ManageClubLinkCategories(string clubDomainName)
        {
            SetPageTitle(GetResourceString("Title_ManageFriendlyLinkCategory", clubApplicationID), clubDomainName);
            Club c = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(c, CurrentUser, PermissionItemKeys.Instance().ManageClubLink(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            BreadCrumb.AddBreadCrumbItem(c.ClubName, SPBUrlHelper.Action("Home", "ClubDomain", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_Manager", clubApplicationID), SPBUrlHelper.Action("Home", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Title_ManageFriendlyLinkCategory", clubApplicationID), SPBUrlHelper.Action("ClubMenus", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }));

            ClubLinkManager ClManage = ClubLinkManager.Instance();
            ViewData["LinkCategories"] = ClManage.GetLinkCategoriesByOwnerID(c.ClubID, true);
            return View("Pages/Manage/ManageLinkCategories.aspx", "Masters/Manage.master");
        }
        /// <summary>
        /// 显示添加友情连接类别
        /// </summary>
        /// <param name="clubDomainName">群组clubDomainName</param>
        /// <returns></returns>
        public ActionResult Control_AddLinkCategory(string clubDomainName)
        {
            return PartialView("Controls/Manage/EditClubLinkCategory.ascx");
        }
        /// <summary>
        /// 显示编辑友情连接类别
        /// </summary>
        /// <param name="clubDomainName">类别id</param>
        /// <returns></returns>
        public ActionResult Control_EditLinkCategory(int CateID)
        {
            ClubLinkManager ClManage = ClubLinkManager.Instance();
            LinkCategory LinkCate = ClManage.GetLinkCategory(CateID, true);
            ViewData["LinkCate"] = LinkCate;
            return PartialView("Controls/Manage/EditClubLinkCategory.ascx");
        }
        /// <summary>
        /// 添加友情连接类别
        /// </summary>
        /// <param name="clubDomainName">群组clubDomainName</param>
        /// <returns></returns>
        public ActionResult Control_AddLinkCategoryAction(string clubDomainName)
        {
            Club c = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(c, CurrentUser, PermissionItemKeys.Instance().ManageClubLink(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            LinkCategory lc = new LinkCategory();
            lc.OwnerID = c.ClubID;
            lc.CategoryName = Request.Form.GetString("category", string.Empty);
            lc.DisplayOrder = Request.Form.GetInt("displayorder", -1);
            lc.Description = Request.Form.GetString("decript", string.Empty);


            if (!string.IsNullOrEmpty(lc.CategoryName))
                lc.CategoryName = Formatter.FormatSingleLinePlainTextForStorage(lc.CategoryName);
            if (!string.IsNullOrEmpty(lc.Description))
                lc.Description = Formatter.FormatMultiLinePlainTextForStorage(lc.Description, true);


            if (lc.DisplayOrder < 0 || string.IsNullOrEmpty(lc.CategoryName))
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_CreateErrorCategoryNameNotNull", clubApplicationID);
            }
            else
            {
                ClubLinkManager ClManage = ClubLinkManager.Instance();
                ClManage.CreateUserLinkCategory(lc);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                TempData["StatusMessageContent"] = GetResourceString("Message_UploadSuccess", clubApplicationID);
            }
            return RedirectToAction("Control_AddLinkCategory", "ClubManage");
        }
        /// <summary>
        /// 编辑友情类别
        /// </summary>
        /// <param name="CateID">类别id</param>
        /// <returns></returns>
        public ActionResult Control_EditLinkCategoryAction(int CateID)
        {
            LinkCategory lc = ClubLinkManager.Instance().GetLinkCategory(CateID, true);
            if (lc == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_LinkCategoryError", clubApplicationID), CateID)));
            }
            lc.CategoryName = Request.Form.GetString("category", string.Empty);
            lc.DisplayOrder = Request.Form.GetInt("displayorder", -1);
            lc.Description = Request.Form.GetString("decript", string.Empty);

            if (!string.IsNullOrEmpty(lc.CategoryName))
                lc.CategoryName = Formatter.FormatSingleLinePlainTextForStorage(lc.CategoryName);
            if (!string.IsNullOrEmpty(lc.Description))
                lc.Description = Formatter.FormatMultiLinePlainTextForStorage(lc.Description, true);

            if (lc.DisplayOrder < 0 || string.IsNullOrEmpty(lc.CategoryName))
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_EditErrorCategoryNameNotNull", clubApplicationID);
            }
            else
            {
                ClubLinkManager ClManage = ClubLinkManager.Instance();
                ClManage.UpdateCategory(lc);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                TempData["StatusMessageContent"] = GetResourceString("Message_EditSuccess", clubApplicationID);
            }
            return RedirectToAction("Control_EditLinkCategory", "ClubManage", new RouteValueDictionary { { "CateID", CateID } });
        }
        /// <summary>
        /// 删除友情类别
        /// </summary>
        /// <param name="clubDomainName">群组DomainName</param>
        /// <returns></returns>
        public ActionResult DeleteLinkCategoryAction(string clubDomainName)
        {
            Club c = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(c, CurrentUser, PermissionItemKeys.Instance().ManageClubLink(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            string strCategroies = Request.Form.GetString("CategroyGroup", string.Empty);
            string[] Categroies = strCategroies.Split(',');
            List<int> CateIDs = new List<int>();
            foreach (var item in Categroies)
            {
                try
                {
                    CateIDs.Add(Convert.ToInt32(item));
                }
                catch { }
            }
            ClubLinkManager ClManage = ClubLinkManager.Instance();
            ClManage.DeleteCategories(CateIDs);
            return RedirectToAction("ManageClubLinkCategories", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } });
        }
        #endregion

        #endregion

        #region 管理分享

        /// <summary>
        /// 管理分享
        /// </summary>
        public ActionResult Share()
        {
            SetPageTitle(GetResourceString("Title_ClunShareManage", clubApplicationID));
            return this.View("Pages/Manage/ManageShareContents.aspx", "Masters/Manage.master");
        }

        /// <summary>
        /// 分享内容列表
        /// </summary>
        public ActionResult Control_ListShareContents(string clubDomainName, int? pageIndex, int? applicationID)
        {
            Club currentClub = GetCurrentClub(clubDomainName);
            ViewData["applicationID"] = applicationID ?? -1;
            if (!pageIndex.HasValue || pageIndex.Value <= 0)
                pageIndex = 1;
            bool isRealTime = ClubPermission.Validate(currentClub, CurrentUser, PermissionItemKeys.Instance().ManageShareItemOfClub());
            PagingDataSet<ClubSharedContent> pds = ClubSharedContents.GetClubSharedContents(currentClub.ClubID, null, applicationID, null, null, pageIndex.Value, isRealTime);
            return PartialView("Controls/Manage/ListShareContents.ascx", pds);
        }

        /// <summary>
        /// 删除群组分享内容
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult DeleteShareContents(string clubDomainName, int? pageIndex, int? applicationID)
        {
            Club currentClub = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(currentClub, CurrentUser, PermissionItemKeys.Instance().ManageShareItemOfClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            string deleteShareContentIDs = Request.Form.Get<string>("commendItemsCheckBoxGroup", string.Empty);
            if (!string.IsNullOrEmpty(deleteShareContentIDs))
            {
                //ClubSharedContents cSharedContents = new ClubSharedContents();
                string[] itemIDStrings = deleteShareContentIDs.Split(',');
                foreach (string itemIDString in itemIDStrings)
                {
                    if (!string.IsNullOrEmpty(itemIDString))
                    {
                        ClubSharedContents.DeleteClubSharedContent(Convert.ToInt32(itemIDString));
                    }
                }
            }

            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = GetResourceString("Message_DeleteSuccess");

            return Control_ListShareContents(clubDomainName, pageIndex, applicationID);
        }

        /// <summary>
        /// 删除群组分享内容
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult DeleteShareContent(string clubDomainName, int contentID, string returnUrl)
        {
            Club currentClub = GetCurrentClub(clubDomainName);
            if (!ClubPermission.AccessCheck(currentClub, CurrentUser, PermissionItemKeys.Instance().ManageShareItemOfClub(), HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();
            ClubSharedContents.DeleteClubSharedContent(contentID);
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 分享设置置顶
        /// </summary>
        public ActionResult ShareContentSetSticky(int contentID, bool isSticky)
        {
            if (CurrentUser != null && CurrentUser.IsContentAdministrator)
            {
                ClubSharedContents.SetSticky(contentID, isSticky);
            }
            return new EmptyResult();
        }
        ///// <summary>
        ///// 分享取消置顶
        ///// </summary>
        //public ActionResult ShareContentCancelSticky(int contentID)
        //{
        //    if (!CurrentUser.IsContentAdministrator)
        //    {
        //        throw new ArgumentException("只有管理员才有设置置顶的权限！");
        //    }
        //    ClubSharedContents.SetSticky(contentID, false);
        //    return new EmptyResult();
        //}
        /// <summary>
        /// 分享设置精华
        /// </summary>
        public ActionResult ShareContentSetEssential(int contentID, bool isEssential)
        {
            if (CurrentUser != null && CurrentUser.IsContentAdministrator)
            {
                ClubSharedContents.SetEssential(contentID, isEssential);
            }
            return new EmptyResult();
        }

        #endregion

        #region 群组皮肤

        /// <summary>
        /// 群组装扮
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ModifyHome(string clubDomainName)
        {
            SetPageTitle(GetResourceString("Title_ModifyClubHome", clubApplicationID), clubDomainName);

            Club currentClub = GetCurrentClub(clubDomainName);

            if (!ClubPermission.AccessCheck(currentClub, Globals.GetCurrentUser(), PermissionItemKeys.Instance().EditClub(), this.HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            return View("Pages/Manage/ModifyHome.aspx", currentClub);
        }

        #endregion

        #region 应用管理

        /// <summary>
        /// 应用管理
        /// </summary>
        /// <returns></returns>
        public ActionResult ManageApplications(string clubDomainName)
        {
            SetPageTitle("应用管理");
            Club currentClub = GetCurrentClub(clubDomainName);

            if (!ClubPermission.AccessCheck(currentClub, Globals.GetCurrentUser(), PermissionItemKeys.Instance().EditClub(), this.HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            IList<Application> apps = Applications.GetInstalledApplicationsOfOwner(ThemeManager.PresentAreaID, currentClub.ClubID).Where(n => n.IsEnabled).ToList();
            ViewData["CurrentClub"] = currentClub;
            return View("Pages/Manage/ManageApplications.aspx", "Masters/Manage.master", apps);
        }

        public ActionResult UnInstallApplication(string clubDomainName, int applicationID)
        {

            Club currentClub = GetCurrentClub(clubDomainName);

            if (!ClubPermission.AccessCheck(currentClub, Globals.GetCurrentUser(), PermissionItemKeys.Instance().EditClub(), this.HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            try
            {
                Applications.UnInstallApplication(ThemeManager.PresentAreaID, currentClub.ClubID, applicationID);
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "卸载应用成功！");
            }
            catch (SPBException e)
            {
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Error, e.Message);
            }
            return RedirectToAction("ManageApplications", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } });
        }

        /// <summary>
        /// 浏览应用
        /// </summary>
        /// <returns></returns>
        public ActionResult ListApplications(string clubDomainName)
        {

            SetPageTitle("添加应用");
            Club currentClub = GetCurrentClub(clubDomainName);

            if (!ClubPermission.AccessCheck(currentClub, Globals.GetCurrentUser(), PermissionItemKeys.Instance().EditClub(), this.HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            IList<Application> apps = Applications.GetAvailableApplications(ThemeManager.PresentAreaID).Where(n => n.IsEnabled).ToList();
            bool tipInstall = Request.QueryString.GetBool("tipInstall", false);
            if (tipInstall)
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Hint, GetResourceString("Message_PleaseInstallApplication"));

            ViewData["CurrentClub"] = currentClub;
            return View("Pages/Manage/ListApplications.aspx", "Masters/Manage.master", apps);
        }

        public ActionResult InstallApplication(string clubDomainName, int applicationID)
        {
            Club currentClub = GetCurrentClub(clubDomainName);

            if (!ClubPermission.AccessCheck(currentClub, Globals.GetCurrentUser(), PermissionItemKeys.Instance().EditClub(), this.HttpContext, SiteUrls.Instance().Login(true)))
                return new EmptyResult();

            try
            {
                Applications.InstallApplication(ThemeManager.PresentAreaID, currentClub.ClubID, applicationID);
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "添加应用成功！");
            }
            catch (SPBException e)
            {
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Error, e.Message);
            }
            return RedirectToAction("ListApplications", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } });
        }

        #endregion

        #endregion
    }

    #region ClubSubMenu

    public enum ManageClubMenu
    {
        /// <summary>
        /// 内容管理
        /// </summary>
        ManageContent = 100,

        /// <summary>
        /// 基础设置
        /// </summary>
        BasicSetting = 101,

        /// <summary>
        /// 管理成员
        /// </summary>
        ManageMember = 102,
    }

    public enum ManageClubSubMenu
    {
        /// <summary>
        ///分享内容管理
        /// </summary>
        ManageShare = 1,

        /// <summary>
        /// 添加话题管理
        /// </summary>
        EditForumSection = 2,

        /// <summary>
        ///  管理话题版块
        /// </summary>
        ManageForumSections = 3,

        /// <summary>
        ///编辑群组公告
        /// </summary>
        EditClubPlacard = 4,

        /// <summary>
        /// 群组个性装扮
        /// </summary>
        ModifyHome = 5,

        /// <summary>
        ///  更新群组资料
        /// </summary>
        ManageClubInfo = 6,

        /// <summary>
        ///更新群组Logo
        /// </summary>
        ClubLogo = 7,

        /// <summary>
        /// 更新群组菜单
        /// </summary>
        ManageClubNavigations = 8,

        /// <summary>
        ///  广告管理
        /// </summary>
        ManageAdvertisings = 9,

        /// <summary>
        /// 友情链接
        /// </summary>
        ManageClubLinks = 10,

        /// <summary>
        ///  友情链接类别
        /// </summary>
        ManageClubLinkCategories = 11,

        /// <summary>
        /// 管理群组成员
        /// </summary>
        ManageClubMembers = 12,

        /// <summary>
        ///  待批准的成员
        /// </summary>
        ManagePendingClubMembers = 13,

        /// <summary>
        ///更新群组Banner
        /// </summary>
        ClubBanner = 14,

        /// <summary>
        /// 管理投票评论
        /// </summary>
        ManageVoteComments = 15,

        /// <summary>
        /// 帖子管理
        /// </summary>
        ManageForumPost = 16,
        /// <summary>
        /// 主题分类管理
        /// </summary>
        ManageForumCategories = 17,

        /// <summary>
        /// 论坛主题管理
        /// </summary>
        ManageForumThreads,

        /// <summary>
        /// 应用管理
        /// </summary>
        ManageApplications
    }

    #endregion
}