﻿//------------------------------------------------------------------------------
//<copyright company="Tunynet">
// Copyright (c) Tunynet Inc.  All rights reserved.
//</copyright> 
//------------------------------------------------------------------------------ 
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common.Controllers;
using System.Web.Mvc;
using SpaceBuilder.Common;
using System.Web.Routing;
using SpaceBuilder.Web;

namespace SpaceBuilder.Club.Controllers
{
    [UserDomainGuideInstallApplication(ApplicationID = 231)]
    [HttpCompress]
    public class ClubUserDomainController : UserDomainControllerBase
    {
        int applicationID = ApplicationIDs.Instance().Club();

        /// <summary>
        /// 显示我的群组列表
        /// </summary>
        [UserDomainPrivacy(IsAuthentication = true)]
        public ActionResult ListMyClubs(string userDomainName)
        {
            bool isCreater = Request.QueryString.GetBool("isCreater", false);
            if (isCreater)
                SetPageTitle(GetResourceString("Title_MyCreatedClub", applicationID));
            else
                SetPageTitle(GetResourceString("Title_MyClub", applicationID));

            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            if (CurrentUser != null && currentDomainUser.UserID == CurrentUser.UserID)
                ViewData["isCurrentDomainUser"] = true;
            else
            {
                ViewData["isCurrentDomainUser"] = false;
            }
            ViewData["isCreater"] = isCreater;
            return View("Pages/Clubs/ListMyClubs.aspx", "Masters/Club.master");
        }

        /// <summary>
        /// 显示我的群组列表控件
        /// </summary>
        public ActionResult Control_ListMyClubs(string userDomainName, bool isCreater, int? pageIndex)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            PagingDataSet<Club> clubs = null;
            if (HasManagePermission(userDomainName))
                clubs = Clubs.GetMyClubs(currentDomainUser.UserID, !isCreater, pageIndex.HasValue ? pageIndex.Value : 1);
            else
                clubs = Clubs.GetClubs(currentDomainUser.UserID, !isCreater, pageIndex.HasValue ? pageIndex.Value : 1);

            return PartialView("Controls/Clubs/ListMyClubs.ascx", clubs);
        }

        public ActionResult Control_ClubCountBlock(string userDomainName)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            ClubUserData userData = ClubUserDatas.GetUserData(currentDomainUser.UserID, false);
            return PartialView("Controls/Clubs/ClubCountBlock.ascx", userData);
        }

        #region 群组动态

        /// <summary>
        /// 显示群组动态模块
        /// </summary>
        public ActionResult Control_ListClubActivitiesBlock(string userDomainName, int? displayItemCount)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            IList<ClubActivity> pds = ClubActivities.GetTopClubActivitiesForUser(currentDomainUser.UserID, null, displayItemCount ?? 10, HasManagePermission(currentDomainUser));
            int totalRecords = pds.Count;
            ViewData["displayItemCount"] = displayItemCount ?? 10;
            ViewData["totalRecords"] = totalRecords;
            return PartialView("Controls/Clubs/ListClubActivitiesBlock.ascx", pds);
        }


        #endregion
    }
}