﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Club;
using SpaceBuilder.Common.Controllers;
using SpaceBuilder.Web;
using SpaceBuilder.Common;
using System.Web.Routing;
using SpaceBuilder.Forum;


namespace SpaceBuilder.Club.Controllers
{
    [ManageAuthorize]
    [HttpCompress]
    public class ManageClubController : ManageControllerBase
    {
        #region 群组管理
        /// <summary>
        ///  群组列表
        /// </summary>
        /// <param name="status"></param>
        /// <param name="pageIndex"></param>
        /// <returns></returns>
        public ActionResult ListClubs(AuditingStatusesForDisplay? status, int? pageIndex)
        {
            SetPageTitle("群组管理");

            #region OLD

            //int pageSize = 17;

            //ViewData["status"] = AuditingStatusesForDisplay.Success;
            //if (status.HasValue)
            //    ViewData["status"] = (AuditingStatusesForDisplay)status;

            //ClubQuery cq = new ClubQuery();
            //cq.EnablePaging = true;

            //int sta = Request.QueryString.GetInt("QuerySta", -1);
            //if (sta > 0)
            //{
            //    cq.AuditingStatus = (AuditingStatusesForDisplay)sta;
            //    ViewData["status"] = (AuditingStatusesForDisplay)sta;
            //}
            //else
            //{
            //    cq.AuditingStatus = (AuditingStatusesForDisplay)(status ?? AuditingStatusesForDisplay.Success);
            //}

            //if (pageIndex.HasValue && (int)pageIndex > 0)
            //    cq.PageIndex = (int)pageIndex;
            //else
            //    cq.PageIndex = 0;
            //cq.CategoryID = Request.QueryString.GetInt("ClubCategoryID", -1);
            //cq.ClubOwnerUserID = Request.QueryString.GetInt("SearchClubUserID", -1);
            //if (cq.ClubOwnerUserID > 0)
            //    ViewData["ClubOwnerUserID"] = cq.ClubOwnerUserID;

            //int SearchClubSecrecyType = Request.QueryString.GetInt("SearchClubSecrecyType", -1);
            //if (SearchClubSecrecyType > 0)
            //    cq.IsPublic = true;


            //cq.PageSize = pageSize;

            //cq.SortBy = ClubsSortBy.CreateDate;
            //int sortB = Request.QueryString.GetInt("selectSortBy", -1);
            //if (sortB > 0)
            //    cq.SortBy = (ClubsSortBy)sortB;

            //cq.SortOrder = SortOrder.Descending;
            //int sortO = Request.QueryString.GetInt("selectSortOreder", -1);
            //if (sortO >= 0)
            //    cq.SortOrder = (SortOrder)sortO;

            //cq.AreaCode = Request.QueryString.GetString("areaCode", string.Empty);
            //cq.IncludeAreaDescendant = true;
            //cq.ClubNameFilter = Request.QueryString.GetString("SearchClubName", string.Empty).Trim();

            //PagingDataSet<Club> pds = Clubs.GetClubs(cq);
            //ViewData["PgClubs"] = pds;
            #endregion

            int categoryID = Request.QueryString.GetInt("ClubCategoryID", -1);
            int clubOwnerUserID = Request.QueryString.GetInt("SearchClubUserID", -1);
            string clubNameFilter = Request.QueryString.GetString("SearchClubName", string.Empty).Trim();
            int searchClubSecrecyType = Request.QueryString.GetInt("SearchClubSecrecyType", -1);
            string areaCode = Request.QueryString.GetString("areaCode", string.Empty);
            status = (AuditingStatusesForDisplay)(status ?? AuditingStatusesForDisplay.Pending);
            ViewData["status"] = status;
            if (clubOwnerUserID > 0)
                ViewData["ClubOwnerUserID"] = clubOwnerUserID;
            bool? isPublic = null;
            if (searchClubSecrecyType >= 0)
                isPublic = searchClubSecrecyType > 0;
            PagingDataSet<Club> pds = Clubs.GetClubsForAdmin(17, pageIndex.HasValue ? pageIndex.Value : 1, status, clubOwnerUserID, clubNameFilter, categoryID, isPublic, areaCode);
            ViewData["PgClubs"] = pds;
            return View("Pages/Club/ManageClubs.aspx", "Masters/Club.master");
        }

        /// <summary>
        /// 删除一个群组
        /// </summary>
        /// <param name="status"></param>
        /// <param name="pageIndex"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult DeleteClub(AuditingStatusesForDisplay? status, int? pageIndex)
        {
            int clubID = Request.QueryString.GetInt("clubID", -1);
            if (clubID < 0)
                throw new ArgumentException("群组clubID错误！");
            Clubs.DeleteClub(clubID);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "群组删除成功";
            return RedirectToAction("ListClubs", "ManageClub", new RouteValueDictionary { { "status", status.HasValue ? (AuditingStatusesForDisplay)status : AuditingStatusesForDisplay.Success }, { "pageIndex", pageIndex ?? 0 } });
        }

        /// <summary>
        /// 批量删除群组
        /// </summary>
        /// <param name="returnUrl"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult DeleteClubs(string returnUrl)
        {
            string selectedClubIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedClubIDsString))
            {
                string[] selectedClubIDsStringArray = selectedClubIDsString.Split(',');
                if (selectedClubIDsStringArray != null && selectedClubIDsStringArray.Length > 0)
                {
                    int clubID;
                    foreach (string Id in selectedClubIDsStringArray)
                    {
                        try
                        {
                            clubID = int.Parse(Id);
                            Clubs.DeleteClub(clubID);
                        }
                        catch { }
                    }
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = "群组批量删除成功";
                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "请选中要删除的群组";
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 批量更新群组的状态
        /// </summary>
        /// <param name="returnUrl"></param>
        /// <param name="auditingStatus"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult UpdateClubAuditingStatus(string returnUrl, AuditingStatuses auditingStatus)
        {
            string selectedClubIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedClubIDsString))
            {
                string[] selectedClubIDsStringArray = selectedClubIDsString.Split(',');
                if (selectedClubIDsStringArray != null && selectedClubIDsStringArray.Length > 0)
                {
                    int clubID;
                    List<int> ListClubID = new List<int>();
                    foreach (string Id in selectedClubIDsStringArray)
                    {
                        try
                        {
                            clubID = int.Parse(Id);
                            ListClubID.Add(clubID);
                        }
                        catch { }
                    }

                    try
                    {
                        Clubs.UpdateAuditingStatus(ListClubID, auditingStatus);
                        TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                        TempData["StatusMessageContent"] = "群组批量操作成功";
                    }
                    catch
                    {
                        TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                        TempData["StatusMessageContent"] = "群组批量操作失败";
                    }
                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "请选中要操作的群组";
            }
            return Redirect(returnUrl);
        }
        /// <summary>
        /// 将群组转化为论坛
        /// </summary>
        /// <param name="clubID"></param>
        /// <param name="returnUrl"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ClubToForumGroup(int clubID, string returnUrl)
        {
            int groupID = OwnerID2GroupIDDictionary.Instance(ApplicationIDs.Instance().Club()).GetGroupID(clubID);
            if (groupID <= 0)
            {
                Club club = Clubs.GetClub(clubID, true);
                if (club != null)
                {
                    //创建默认板块组
                    ForumSectionGroup group = new ForumSectionGroup();
                    group.OwnerID = club.ClubID;
                    group.GroupName = club.ClubName;
                    group.PresentAreaID = PresentAreaIDs.Instance().Channel();
                    ForumSectionGroups.CreateGroup(group);

                    //创建默认板块
                    ForumSection forumSection = new ForumSection();
                    forumSection.GroupID = group.GroupID;
                    forumSection.SectionName = "默认版块";
                    ForumSections.Create(forumSection, null);
                }
            }
            else
                ForumSectionGroups.ConvertClubToSectionGroup(clubID);

            Clubs.ConvertClubToSectionGroup(clubID);

            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "群组转化为论坛成功";
            return Redirect(returnUrl);
        }
        /// <summary>
        /// 更换群主
        /// </summary>
        /// <param name="clubID"></param>
        /// <param name="newClubOwner"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult Control_ChangeClubOwner(int clubID)
        {
            Club clubConvert = Clubs.GetClub(clubID, false);
            if (clubConvert == null)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "群组不存在";
            }
            else
            {
                ViewData["ChangeClub"] = clubConvert;
            }
            return PartialView("Controls/Club/ChangeClubOwner.ascx");
        }
        /// <summary>
        /// 更换群主
        /// </summary>
        /// <param name="clubID"></param>
        /// <param name="newClubOwner"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult ChangeClubOwnerAction(int clubID, string newClubOwner)
        {
            Club clubConvert = Clubs.GetClub(clubID, false);
            // ViewData["ChangeClub"] = clubConvert;
            if (clubConvert == null)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "群组不存在";
                return RedirectToAction("Control_ChangeClubOwner", new RouteValueDictionary { { "clubID", clubID } });
            }
            User u = Users.GetUser(newClubOwner, true);
            if (u == null)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = string.Format("用户{0}不存在", newClubOwner);
                return RedirectToAction("Control_ChangeClubOwner", new RouteValueDictionary { { "clubID", clubID } });
            }
            Clubs.ChangeClubOwner(clubID, newClubOwner);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "更换群主成功";
            return RedirectToAction("Control_ChangeClubOwner", new RouteValueDictionary { { "clubID", clubID } });
        }
        #endregion

        #region 群组类别

        /// <summary>
        /// 群组类别
        /// </summary>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ClubCategories()
        {
            SetPageTitle("群组类别管理");
            ViewData["SiteCategoryDepth"] = ClubDomainConfiguration.Instance().SiteCategoryLevel - 1;
            return View("Pages/Club/ManageClubCategories.aspx", "Masters/Club.master");
        }

        #endregion


        /// <summary>
        /// 获取群组统计数据
        /// </summary>      
        public JsonResult GetManageableCounts()
        {
            Dictionary<ClubManageableCounts, int> dictionary = Clubs.GetManageableCounts();
            Application clubApplication = Applications.GetApplication(ApplicationIDs.Instance().Club());
            List<ManageableCount> list = new List<ManageableCount>();
            list.Add(new ManageableCount { Name = "新增群组", Value = clubApplication.CountInPast24Hours });
            if (dictionary.ContainsKey(ClubManageableCounts.PendingThreadCount))
                list.Add(new ManageableCount { Name = "待审核群组", Value = dictionary[ClubManageableCounts.PendingThreadCount], Url = SPBUrlHelper.Action("ListClubs", "ManageClub", new RouteValueDictionary { { "status", AuditingStatuses.Pending } }) });
            if (dictionary.ContainsKey(ClubManageableCounts.AgainThreadCount))
                list.Add(new ManageableCount { Name = "需再审核群组", Value = dictionary[ClubManageableCounts.AgainThreadCount], Url = SPBUrlHelper.Action("ListClubs", "ManageClub", new RouteValueDictionary { { "status", AuditingStatuses.Again } }) });
            list.Add(new ManageableCount { Name = "总群组", Value = clubApplication.TotalCount });
            return Json(list, JsonRequestBehavior.AllowGet);
        }

    }

    #region ClubSubMenu

    public enum ClubSubMenu
    {
        /// <summary>
        /// 群组管理
        /// </summary>
        ManageClubs = 2201,

        /// <summary>
        /// 群组类别管理
        /// </summary>
        ManageClubCategories = 2206,

        /// <summary>
        /// 群组留言管理
        /// </summary>
        ManageGuestBook = 2209
    }

    #endregion


}
