﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Mvc;
using System.IO;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using SpaceBuilder.Common.Handlers;

namespace SpaceBuilder.Club.Handlers
{
    /// <summary>
    /// 显示ClubLogo
    /// </summary>
    public class ClubBannerHandler : DownloadFileHandlerBase
    {
        public override void ProcessRequest(HttpContext context)
        {
            //防盗链检测
            if (SPBConfig.Instance().EnableAntiLeech && !Globals.IsAllowableReferrer(context.Request))
            {
                context.Response.Redirect(Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/anti-Leech.gif"), true);
                return;
            }

            int clubID = context.Request.QueryString.GetInt("clubID", -1);
            bool enableCaching = context.Request.QueryString.GetBool("enableCaching", true);

            if (clubID <= 0)
            {
                WebUtils.Return404(context);
                return;
            }

            IFile clubBannerFile = ClubLogos.GetClubBanner(clubID);
            if (clubBannerFile != null)
            {
                DateTime lastModified = clubBannerFile.LastModified.ToUniversalTime();
                if (enableCaching && IsCacheOK(context, lastModified))
                {
                    WebUtils.Return304(context);
                    return;
                }
                else
                {
                    context.Response.ContentType = MimeTypeConfiguration.GetMimeType(clubBannerFile.FileName);

                    FileSystemFile fileSystemFile = clubBannerFile as FileSystemFile;
                    if (fileSystemFile != null && (!fileSystemFile.FullLocalPath.StartsWith(@"\")))
                    {
                        // Send files stored on UNC paths explicitly to avoid a bug with TransmitFile.
                        context.Response.TransmitFile(fileSystemFile.FullLocalPath);
                    }
                    else
                    {
                        context.Response.AddHeader("Content-Length", clubBannerFile.ContentLength.ToString("0"));
                        context.Response.Buffer = false;
                        context.Response.BufferOutput = false;
                        Stream stream = null;
                        try
                        {
                            stream = clubBannerFile.OpenReadStream();
                            if (stream == null)
                            {
                                WebUtils.Return404(context);
                                return;
                            }

                            int bufferLength = clubBannerFile.ContentLength <= DownloadFileHandlerBase.BufferLength ? clubBannerFile.ContentLength : DownloadFileHandlerBase.BufferLength;
                            byte[] buffer = new byte[bufferLength];
                            int readedSize;
                            while ((readedSize = stream.Read(buffer, 0, bufferLength)) > 0)
                            {
                                if (!context.Response.IsClientConnected)
                                    break;

                                context.Response.OutputStream.Write(buffer, 0, readedSize);
                                context.Response.OutputStream.Flush();
                            }

                            context.Response.OutputStream.Flush();
                            context.Response.Flush();
                        }
                        catch (Exception ex)
                        {
                            context.Response.Redirect(SiteUrls.Instance().Error(ex.ToString()), true);
                            return;
                        }
                        finally
                        {
                            if (stream != null)
                                stream.Close();
                        }
                    }

                    if (enableCaching)
                    {
                        // Browser cache settings
                        context.Response.Cache.SetCacheability(HttpCacheability.Private);
                        context.Response.Cache.SetLastModified(lastModified);
                        context.Response.Cache.SetETag(lastModified.Ticks.ToString());
                        context.Response.Cache.SetAllowResponseInBrowserHistory(true);
                        context.Response.Cache.SetValidUntilExpires(true);
                    }
                    else
                    {
                        context.Response.Cache.SetExpires(DateTime.Now.AddMonths(-1));
                    }
                }
            }

            context.Response.Cache.VaryByParams["clubID"] = true;
            context.Response.Cache.VaryByParams["enableCaching"] = true;
            context.Response.End();
        }
    }
}