﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Common;
using System.Drawing;

namespace SpaceBuilder.Club.Handlers
{
    public class UploadClubBannerHandler : IHttpHandler
    {
        #region IHttpHandler 成员

        public void ProcessRequest(HttpContext context)
        {
            int currentUserID = int.Parse(EncryptManager.DecryptTokenForInviteFriend(context.Request.Form["currentUserID"]));
            int currentAssociateID = Convert.ToInt32(context.Request["associateID"]);

            if (currentAssociateID < 1)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }
            User currentUser = Users.GetUser(currentUserID, false);
            if (currentUser == null)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            Club clubedit = Clubs.GetClub(currentAssociateID, false);
            if (clubedit == null)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            if (!ClubPermission.Validate(clubedit, currentUser, PermissionItemKeys.Instance().EditClub()))
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            System.Web.HttpPostedFile LogoFile = context.Request.Files["Filedata"];

            if (LogoFile == null || LogoFile.ContentLength == 0)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            if (LogoFile.ContentLength > 5 * 1024 * 1024)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            //Todo: 类型判断
            string uploadPhotoTypes = "gif,jpg,jpeg,png,bmp;";
            string[] types = uploadPhotoTypes.Split(',');
            string fileTypeString = LogoFile.FileName.Substring(LogoFile.FileName.LastIndexOf(".") + 1);
            if (types.Count(n => string.Compare(n, fileTypeString, true) == 0) <= 0)
            {
                context.Response.StatusCode = 403;
                context.Response.End();
            }

            context.Response.StatusCode = 200;
            try
            {
                using (Bitmap bitmapOriginal = new Bitmap(LogoFile.InputStream))
                {
                    if (bitmapOriginal.Width < ClubDomainConfiguration.Instance().SmallLogoWidth || bitmapOriginal.Height < ClubDomainConfiguration.Instance().SmallLogoHeight)
                    {
                        context.Response.Write(string.Format("{{message:'上传图片低于最小尺寸限制：{0}×{1}'}}", ClubDomainConfiguration.Instance().SmallLogoWidth, ClubDomainConfiguration.Instance().SmallLogoHeight));
                        context.Response.End();
                    }
                    else
                    {
                        ClubLogos.UploadClubBanner(clubedit.ClubID, LogoFile.InputStream);
                        context.Response.Write("{refresh:true}");
                        context.Response.End();
                    }
                }
            }
            catch { }
        }

        public bool IsReusable
        {
            get { return false; }
        }

        #endregion
    }
}
