﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;


namespace SpaceBuilder.Club.Modules
{
    public class ClubFomatting : IClubModule
    {
        #region IClubModule 成员

        public void Init(ClubEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforeClubChange += new ClubEventHandler(em_BeforeClubChange);
        }

        void em_BeforeClubChange(Club club, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                #region 检查发帖时间间隔,防灌水
                User user = club.ClubOwner;
                if (!user.IsAdministrator && !user.IsContentAdministrator)
                    Globals.CheckPostDate();
                #endregion

                //标签和脚本处理
                club.Brief = WebUtils.HtmlEncode(club.Brief);
                club.NewsForDataTransmission = HtmlScrubber.Clean(club.NewsForDataTransmission, false, true);
                club.JoinNotice = WebUtils.HtmlEncode(club.JoinNotice);
                club.ClubName = Formatter.FormatSingleLinePlainTextForStorage(club.ClubName);
                club.DomainName = WebUtils.HtmlEncode(club.DomainName.Replace('/', '_'));

                //敏感词处理
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    club.Brief = Censors.CensorPost(club.Brief);
                    club.NewsForDataTransmission = Censors.CensorPost(club.NewsForDataTransmission);
                    club.JoinNotice = Censors.CensorPost(club.JoinNotice);
                    club.DomainName = Censors.CensorPost(club.DomainName);
                }
            }
        }

        #endregion
    }
}
