﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Common.Mail;
using SpaceBuilder.Utils;
using SpaceBuilder.Web;
using SpaceBuilder.Common;

namespace SpaceBuilder.Club.Modules
{
    /// <summary>
    /// 处理与留言的动态、通知
    /// </summary>
    public class DisposeActivityForGuestBook : IServiceModule
    {

        #region IServiceModule 成员

        public void Init(ServiceEventManager em, System.Xml.Linq.XElement node)
        {
            em.AfterGuestbookPostChange += new GuestbookPostEventHandler(em_AfterGuestbookPostChange);
        }
        /// <summary>
        /// 处理用户留言簿
        /// </summary>
        void em_AfterGuestbookPostChange(GuestbookPost post, GlobalEventArgs e)
        {
            if ((e.ApplicationID == ApplicationIDs.Instance().Club()) && (e.State == ObjectState.Create))
            {
                User user = Users.GetUser(post.UserID, false);
                if (user == null )
                    return;

                Club guestBookOwner = Clubs.GetClub(post.GuestbookID, false);
                if (guestBookOwner == null)
                    return;

                string itemKey = ActivityItemKeys.Instance().NewClubGuestbookPost();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);

                if (activityItem == null)
                    return;

                #region 处理个人动态

                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewClubGuestbookPost", user.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), ClubNameLink(guestBookOwner));
                userActivity.Body = HtmlUtils.TrimHtml(post.Body, 250);

                userActivity.RelativeItemID = post.PostID;
                userActivity.RelativeItemName = post.Subject;

                if (post.IsApproved)
                    userActivity.IsPublic = true;
                else
                    userActivity.IsPublic = false;

                Activities.CreateUserActivity(userActivity);
                #endregion
            }
        }

        /// <summary>
        /// 获取带链接的显示用户DisplayName的html代码
        /// </summary>
        /// <remarks>辅助生成个人动态/朋友动态</remarks>
        private string ClubNameLink(Club club)
        {
            if (club == null)
                return string.Empty;
            string hyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;
            return string.Format("<a {0} href=\"{1}\">{2}</a>", hyperlinkTargetOfUserActivity, SiteUrls.Instance().ClubDomainHome(club.DomainName), club.ClubName);
        }

        #endregion
    }
}