﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;


namespace SpaceBuilder.Club.Modules
{
    public class DisposeClubMemberForClubInvitation : IServiceModule
    {
        #region IServiceModule 成员

        public void Init(ServiceEventManager gem, System.Xml.Linq.XElement node)
        {
            gem.InvitationStatusChange += new InvitationEventHandler(gem_InvitationStatusChange);
        }

        void gem_InvitationStatusChange(Invitation invitation, GlobalEventArgs e)
        {
            if (e.ApplicationID == ApplicationIDs.Instance().Club())
            {
                User receiver = Users.GetUser(invitation.ReceiverUserID, false);
                if (receiver == null)
                    return;

                if (invitation.Status == InvitationStatuses.Accept)
                {
                    ClubMember clubMember = new ClubMember();
                    clubMember.ClubID = invitation.RelativeItemID;
                    clubMember.InviteUserDisplayName = invitation.Sender;
                    clubMember.InviteUserID = invitation.SenderUserID;
                    clubMember.DisplayName = receiver.DisplayName;
                    clubMember.UserID = receiver.UserID;
                    clubMember.Status = ClubMemberStatuses.IsApproved;
                    ClubMembers.CreateClubMember(clubMember);
                }
            }
        }

        #endregion
    }
}
