//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Club;
using SpaceBuilder.Common;
using SpaceBuilder.Common.Mail;

using SpaceBuilder.Web;
using SpaceBuilder.Utils;
using System.Web.Routing;

namespace SpaceBuilder.Club.Modules
{
    /// <summary>
    /// ȺصĶ̬֪ͨ
    /// </summary>
    public class DisposeNoticeForClub : IClubModule
    {
        #region IClubModule Ա

        /// <summary>
        /// ע¼
        /// </summary>
        public void Init(ClubEventManager em, System.Xml.Linq.XElement node)
        {
            em.AfterClubMemberChange += new ClubMemberEventHandler(em_AfterClubMemberChange);
        }

        #endregion

        /// <summary>
        /// ȺԱ
        /// </summary>
        void em_AfterClubMemberChange(ClubMember clubMember, GlobalEventArgs e)
        {
            Club club = Clubs.GetClub(clubMember.ClubID, false);
            if (club == null)
                return;

            if (e.State == ObjectState.Create && clubMember.Status == ClubMemberStatuses.Pending)
            {
                ClubMember clubOwner = ClubMembers.GetClubOwner(clubMember.ClubID);
                if (clubOwner != null)
                {
                    string itemKey = NoticeItemKeys.Instance().NewClubMember();
                    NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                    if (noticeItem == null)
                        return;
                    User toUser = null;
                    toUser = Users.GetUser(clubOwner.UserID, false);
                    if (toUser == null)
                        return;
                    NoticeRecord record = new NoticeRecord();
                    record.ApplicationID = ApplicationIDs.Instance().Club();
                    record.NoticeItemID = noticeItem.ItemID;
                    record.NoticeItemKey = noticeItem.ItemKey;
                    record.UserID = toUser.UserID;
                    record.Receiver = toUser.DisplayName;
                    record.LeadingActorUserID = clubMember.UserID;
                    record.LeadingActor = clubMember.DisplayName;
                    record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Club());
                    record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewClubMember", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(clubMember.User, true), GetClubNameWithHyperlink(club));
                    record.RelativeItemID = club.ClubID;
                    record.RelativeItemName = club.ClubName;
                    record.RelativeItemUrl = SiteUrls.Instance().ClubDomainHome(club.DomainName);
                    record.ProcessUrl = SPBUrlHelper.Action("ManagePendingClubMembers", "ClubMember", new RouteValueDictionary { { "clubDomainName", club.DomainName } });
                    record.Body = clubMember.ApplyRemark;
                    NoticeProcessorFactory.Instance().ProcessNotice(record);
                }
            }
        }

        /// <summary>
        /// ȡӵȺƵhtml
        /// </summary>
        private static string GetClubNameWithHyperlink(Club club)
        {
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ClubDomainHome(club.DomainName), club.ClubName);
        }

        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;

    }
}
