//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Common.Mail;

using SpaceBuilder.Club;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Web;

namespace SpaceBuilder.Club.Modules
{
    /// <summary>
    /// ص֪ͨ
    /// </summary>
    public class DisposeNoticeForService : IServiceModule
    {
        #region IServiceModule Ա

        public void Init(ServiceEventManager em, System.Xml.Linq.XElement node)
        {
            em.NewInvitation += new InvitationEventHandler(em_NewInvitation);
        }

        void em_NewInvitation(Invitation invitation, GlobalEventArgs e)
        {
            if (e.ApplicationID == ApplicationIDs.Instance().Club() && e.State == ObjectState.Create)
            {
                string itemKey = NoticeItemKeys.Instance().InvitedJoinClub();

                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;
                User user = null;
                user = Users.GetUser(invitation.SenderUserID, false);
                User toUser = null;
                toUser = Users.GetUser(invitation.ReceiverUserID, false);
                if (user == null || toUser == null  )
                    return;
                Club club = Clubs.GetClub(invitation.RelativeItemID, false);
                if (club == null)
                    return;
                NoticeRecord record = new NoticeRecord();
                record.ApplicationID = ApplicationIDs.Instance().Club();
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.UserID = toUser.UserID;
                record.Receiver = toUser.UserName;
                record.LeadingActorUserID = invitation.SenderUserID;
                record.LeadingActor = invitation.Sender;
                record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Club());
                record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_InvitedJoinClub", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), GetClubNameWithHyperlink(club));
                record.RelativeItemID = invitation.RelativeItemID;
                record.RelativeItemName = invitation.RelativeItemName;
                record.RelativeItemUrl = SiteUrls.Instance().ClubDomainHome(invitation.RelativeItemID);
                record.ProcessUrl = SiteUrls.Instance().InvitationInbox(toUser.UserName);

                record.Body = invitation.Body;
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }

        /// <summary>
        /// ȡӵȺƵhtml
        /// </summary>
        private static string GetClubNameWithHyperlink(Club club)
        {
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().ClubDomainHome(club.DomainName), club.ClubName);
        }
        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;


        #endregion
    }
}
