//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Club.Modules
{
    /// <summary>
    /// ȺصĻ
    /// </summary>
    public class DisposePointForClub : IClubModule
    {
        #region IClubModule Ա

        public void Init(ClubEventManager em, System.Xml.Linq.XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                em.AfterClubMemberPointChange += new PointChangeOfClubMemberEventHandler(em_AfterClubMemberPointChange);
                em.AfterClubPointChange += new PointChangeOfClubEventHandler(em_AfterClubPointChange);
                em.ApproveClubMember += new PointChangeOfClubMemberEventHandler(em_ApproveClubMember);
            }
        }

        void em_AfterClubPointChange(Club club, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            if (e.State == ObjectState.Create)
            {
                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateClub());
                if (role == null)
                    return;

                if (userPointDirection == UserPointDirection.Input)
                {
                    if (e.State == ObjectState.Create)
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateClub", club.ClubOwner.Language, e.ApplicationID), club.ClubName);
                    else
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_ClubAuditingSuccess", club.ClubOwner.Language, e.ApplicationID), club.ClubName);
                }
                else
                {
                    if (e.State == ObjectState.Delete)
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteClub", club.ClubOwner.Language, e.ApplicationID), club.ClubName);
                    else
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_ClubAuditingFail", club.ClubOwner.Language, e.ApplicationID), club.ClubName);
                }

                if (role.HasTradePoints)
                    ClubUserDatas.ChanageExperiencePoints(club.ClubOwnerUserID, role.TradePoints);

                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, club.ClubOwnerUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

                Points.CreateUserPointRecords(records);
            }
        }

        #endregion

        void em_AfterClubMemberPointChange(ClubMember clubMember, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            List<UserPointRecord> records = new List<UserPointRecord>();
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;

            Club club = Clubs.GetClub(clubMember.ClubID, false);

            if (clubMember.ClubMemberRole != ClubMemberRoles.ClubOwner)
            {
                if (userPointDirection == UserPointDirection.Input)
                {
                    if (e.State == ObjectState.Create)
                    {
                        role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().JoinClub());
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_JoinClub", clubMember.User.Language, e.ApplicationID), club.ClubName);
                    }
                    else
                    {
                        role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().JoinClub());
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_JoinClubSuccess", clubMember.User.Language, e.ApplicationID), club.ClubName);
                    }
                }
                else
                {
                    if (e.State == ObjectState.Delete)
                    {
                        role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().QuitClub());
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_QuitClub", clubMember.User.Language, e.ApplicationID), club.ClubName);
                    }
                    else
                    {
                        role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().QuitClub());
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteClubFail", clubMember.User.Language, e.ApplicationID), club.ClubName);
                    }
                }

                if (role == null)
                    return;
                records = Points.PopulateUserPointRecords(role, clubMember.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
            }

            Points.CreateUserPointRecords(records);
        }

        /// <summary>
        /// û׼Ⱥ
        /// </summary>
        void em_ApproveClubMember(ClubMember clubMember, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            if (userPointDirection == UserPointDirection.Input)
            {
                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;

                Club club = Clubs.GetClub(clubMember.ClubID, false);

                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().JoinClub());
                if (role == null)
                    return;

                userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_JoinClub", clubMember.User.Language, e.ApplicationID), club.ClubName);
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, clubMember.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

                Points.CreateUserPointRecords(records);
            }
        }
    }
}
