//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Common;

namespace SpaceBuilder.Club.Modules
{
    /// <summary>
    /// ƼϢصĻ
    /// </summary>
    public class DisposePointForReCommendedClub : IServiceModule
    {
        #region IServiceModule Ա

        public void Init(ServiceEventManager gem, System.Xml.Linq.XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                gem.RecommendedItemChange += new RecommendedItemEventHandler(gem_RecommendedItemChange);
            }
        }
        #endregion


        void gem_RecommendedItemChange(RecommendedItem commendedItem, GlobalEventArgs e)
        {
            if ((e.ApplicationID == ApplicationIDs.Instance().Club()) && (e.State == ObjectState.Create))
            {
                User user = Users.GetUser(commendedItem.AuthorUserID, false);
                if (user == null)
                    return;
                string userPointRecordDescription = string.Empty;
                string itemKey = string.Empty;
                UserPointItemRole role = null;

                itemKey = UserPointItemKeys.Instance().RecommendedClub();
                role = Points.GetUserPointItemRole(itemKey);

                if (role == null)
                    return;

                userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_RecommendedClub", user.Language, e.ApplicationID), commendedItem.ItemName);
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, commendedItem.AuthorUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                Points.CreateUserPointRecords(records);
            }
        }
    }
}