﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using System.Web.Routing;
using SpaceBuilder.Web;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;



namespace SpaceBuilder.Club
{
    public static class SPBHtmlHelperExtensions
    {

        public static string ClubSecrecyTypesRadioButton(this SPBHtmlHelper spbHtmlHelper, string controlName, bool isPublic)
        {
            string radioButtonString = string.Empty;

            radioButtonString = "<input type=\"radio\" " + (isPublic ? "checked=\"checked\"" : "") + " value=\"1\" id=\"clubtyperadio\" name=\"" + controlName + "\" class=\"radiobutton\" />公开型 <br />";
            radioButtonString = radioButtonString + "<input type=\"radio\" " + ((!isPublic) ? "checked=\"checked\"" : "") + " value=\"0\" id=\"clubtyperadio2\" class=\"radiobutton\" name=\"" + controlName + "\" />私密型 ";

            return radioButtonString;
        }

        ///<overloads>显示群组logo</overloads>
        /// <summary>
        /// 显示群组logo
        /// </summary>
        /// <returns>&lt;img src='' /&gt;</returns>
        public static string ShowClubLogo(this SPBHtmlHelper spbHtmlHelper, int clubID, ClubLogoSizeTypes clubLogoSizeTypes)
        {
            return ShowClubLogo(spbHtmlHelper, clubID, clubLogoSizeTypes, true, null);
        }

        ///<overloads>显示群组logo</overloads>
        /// <summary>
        /// 显示群组logo
        /// </summary>
        /// <returns>&lt;img src='' /&gt;</returns>
        public static string ShowClubLogo(this SPBHtmlHelper spbHtmlHelper, int clubID, ClubLogoSizeTypes clubLogoSizeTypes, RouteValueDictionary htmlAttributes)
        {
            return ShowClubLogo(spbHtmlHelper, clubID, clubLogoSizeTypes, true, htmlAttributes);
        }

        ///<overloads>显示群组logo</overloads>
        /// <summary>
        /// 显示群组logo
        /// </summary>
        ///<param name="clubLogoSizeTypes">尺寸大小</param>
        /// <returns>&lt;img src='' /&gt;</returns>
        public static string ShowClubLogo(this SPBHtmlHelper spbHtmlHelper, int clubID, ClubLogoSizeTypes clubLogoSizeTypes, bool enableCachingInClient, RouteValueDictionary htmlAttributes)
        {
            TagBuilder img = new TagBuilder("img");
            if (htmlAttributes != null)
                img.MergeAttributes(htmlAttributes);

            img.MergeAttribute("src", SiteUrls.Instance().ClubLogoUrl(clubID, clubLogoSizeTypes, enableCachingInClient));

            return img.ToString(TagRenderMode.SelfClosing);
        }

        /// <summary>
        /// 显示群组标识
        /// </summary>
        /// <param name="spbHtmlHelper"></param>
        /// <param name="clubID"></param>
        /// <param name="enableCachingInClient"></param>
        /// <param name="htmlAttributes"></param>
        /// <returns></returns>
        public static string ShowClubBanner(this SPBHtmlHelper spbHtmlHelper, int clubID, bool enableCachingInClient, RouteValueDictionary htmlAttributes)
        {

            if (string.IsNullOrEmpty(SiteUrls.Instance().ClubBannerUrl(clubID, enableCachingInClient)))
                return string.Empty;

            TagBuilder img = new TagBuilder("img");
            if (htmlAttributes != null)
                img.MergeAttributes(htmlAttributes);
            img.MergeAttribute("src", SiteUrls.Instance().ClubBannerUrl(clubID, enableCachingInClient));
            return img.ToString(TagRenderMode.SelfClosing);

        }
    }
}
