﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SpaceBuilder.Common
{
    public class ClubDomainSpecialAppIDs
    {
        #region Instance
        private static volatile ClubDomainSpecialAppIDs _instance = null;
        private static readonly object lockObject = new object();

        public static ClubDomainSpecialAppIDs Instance()
        {
            if (_instance == null)
            {
                lock (lockObject)
                {
                    if (_instance == null)
                    {
                        _instance = new ClubDomainSpecialAppIDs();
                    }
                }
            }
            return _instance;
        }

        private ClubDomainSpecialAppIDs()
        { }
        #endregion

        public int None()
        {
            return -100;
        }

        /// <summary>
        /// 群组首页
        /// </summary>
        public int Home()
        {
            return -201;
        }
        /// <summary>
        /// 管理
        /// </summary>
        public int Manage()
        {
            return -202;
        }
        /// <summary>
        /// 分享
        /// </summary>
        public int Share()
        {
            return -203;
        }
        /// <summary>
        /// 动态
        /// </summary>
        public int Activities()
        {
            return -204;
        }
        /// <summary>
        /// 成员
        /// </summary>
        public int Members()
        {
            return -205;
        }
    }
}
