﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SpaceBuilder.Common
{
    public class CodeSetCodes
    {
        #region Instance
        private static volatile CodeSetCodes _instance = null;
        private static readonly object lockObject = new object();

        public static CodeSetCodes Instance()
        {
            if (_instance == null)
            {
                lock (lockObject)
                {
                    if (_instance == null)
                    {
                        _instance = new CodeSetCodes();
                    }
                }
            }
            return _instance;
        }

        private CodeSetCodes()
        { }
        #endregion

        ///// <summary>
        ///// 动态项
        ///// </summary>
        //public string ActivityItem()
        //{
        //    return "ActivityItem";
        //}

        ///// <summary>
        ///// 通知项
        ///// </summary>
        //public string NoticeItem()
        //{
        //    return "NoticeItem";
        //}

        ///// <summary>
        ///// 积分项
        ///// </summary>
        //public string UserPointItem()
        //{
        //    return "UserPointItem";
        //}

        ///// <summary>
        ///// 隐私项
        ///// </summary>
        //public string PrivacyItem()
        //{
        //    return "PrivacyItem";
        //}
        
        /// <summary>
        /// 审核项
        /// </summary>
        public string AuditingItem()
        {
            return "AuditingItem";
        }

        /// <summary>
        /// 权限项
        /// </summary>
        public string PermissionItem()
        {
            return "PermissionItem";
        }

        /// <summary>
        /// 学历
        /// </summary>
        public string Degree()
        {
            return "Degree";
        }

        /// <summary>
        /// 体型
        /// </summary>
        public string Shape()
        {
            return "Shape";
        }

        /// <summary>
        /// 血型
        /// </summary>
        public string Blood()
        {
            return "Blood";
        }

        /// <summary>
        /// 抽烟情况
        /// </summary>
        public string Smoke()
        {
            return "Smoke";
        }

        /// <summary>
        /// 喝酒情况
        /// </summary>
        public string Drink()
        {
            return "Drink";
        }

        /// <summary>
        /// 婚姻状况
        /// </summary>
        public string Marriage()
        {
            return "Marriage";
        }

        /// <summary>
        /// 健康状况
        /// </summary>
        public string Health()
        {
            return "Health";
        }

        /// <summary>
        /// 月薪
        /// </summary>
        public string Salary()
        {
            return "Salary";
        }

        /// <summary>
        /// 行业
        /// </summary>
        public string Trade()
        {
            return "Trade";
        }

        /// <summary>
        /// 朋友间的亲密程度
        /// </summary>
        public string Friendliness()
        {
            return "Friendliness";
        }

        /// <summary>
        /// 性别
        /// </summary>
        public string Gender()
        {
            return "Gender";
        }

        /// <summary>
        /// 身份识别卡的类型
        /// </summary>
        public string CardType()
        {
            return "CardType";
        }

        /// <summary>
        /// 企业性质
        /// </summary>
        public string CompanyProperty()
        {
            return "CompanyProperty";
        }

        /// <summary>
        /// 雇员数量分类
        /// </summary>
        public string EmployeeCount()
        {
            return "EmployeeCount";
        }

        /// <summary>
        /// 注册资金分类
        /// </summary>
        public string Fund()
        {
            return "Fund";
        }

        /// <summary>
        /// 语言类型
        /// </summary>
        public string Language()
        {
            return "Language";
        }

        /// <summary>
        /// 英语等级
        /// </summary>
        public string EnglishGrade()
        {
            return "EnglishGrade";
        }

        /// <summary>
        /// 专业类别
        /// </summary>
        public string MajorSort()
        {
            return "MajorSort";
        }

        /// <summary>
        /// 职务等级
        /// </summary>
        public string TitleLevel()
        {
            return "TitleLevel";
        }

        /// <summary>
        /// 日期范围
        /// </summary>
        public string DateScope()
        {
            return "DateScope";
        }

        /// <summary>
        /// 用户级别类型
        /// </summary>
        public string UserRankType()
        {
            return "UserRankType";
        }

        /// <summary>
        /// 时区
        /// </summary>
        public string TimeZone()
        {
            return "TimeZone";
        }

        /// <summary>
        /// 有效期
        /// </summary>
        public string ActiveDate()
        {
            return "ActiveDate";
        }
    }
}