//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using SpaceBuilder.Common;

namespace SpaceBuilder.Common
{
    /// <summary>
    /// ģʵ
    /// </summary>
    public class InvitationTemplate
    {
        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="node">xmlڵ</param>
        public InvitationTemplate(XmlNode node)
        {
            int.TryParse(node.Attributes["ApplicationID"].Value, out applicationID);
            transportMode = (InvitationTransportModes)Enum.Parse(transportMode.GetType(), node.Attributes["TransportMode"].Value);
            Subject = node.SelectSingleNode("Subject").InnerText;
            Body = node.SelectSingleNode("Body").InnerXml;
        }

        #region 
        
        private string subject = string.Empty;
        private string body = string.Empty;
        private int applicationID = ApplicationIDs.Instance().Friend();
        private InvitationTransportModes transportMode = InvitationTransportModes.Email;

        /// <summary>
        /// ģ
        /// </summary>
        public string Subject
        {
            get { return subject; }
            set { subject = value; }
        }

        /// <summary>
        /// ģ
        /// </summary>
        public string Body
        {
            get { return body; }
            set { body = value; }
        }

        /// <summary>
        /// ӦID
        /// </summary>
        public int ApplicationID
        {
            get { return applicationID; }
            set { applicationID = value; }
        }

        /// <summary>
        /// ϢĴģʽ
        /// </summary>
        public InvitationTransportModes TransportMode
        {
            get { return transportMode; }
            set { transportMode = value; }
        }

        #endregion

    }
}
