//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.Web.Caching;
using System.Xml;
using System.Text.RegularExpressions;
using System.Web;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using SpaceBuilder.Caching;

namespace SpaceBuilder.Common
{
    /// <summary>
    /// ģҵ߼
    /// </summary>
    public static class InvitationTemplates
    {

        /// <summary>
        /// ʽûEmail
        /// </summary>
        /// <param name="stringToFormat">Ҫʽı</param>
        /// <param name="sender">û</param>
        /// <returns></returns>
        public static string EmailFormatterForPersonUser(string stringToFormat, User sender)
        {
            DateTime time = DateTime.Now;
            stringToFormat = Regex.Replace(stringToFormat, "\\[TimeSent\\]", time.ToString(time.ToString(string.Format("dddd, yyyy-MM-dd hh:mm tt [GMT {0}]", SiteSettingsManager.GetSiteSettings().SiteTimezone.ToString()))), RegexOptions.IgnoreCase | RegexOptions.Compiled);
            stringToFormat = Regex.Replace(stringToFormat, "\\[SiteName\\]", SiteSettingsManager.GetSiteSettings().SiteName, RegexOptions.IgnoreCase | RegexOptions.Compiled);
            stringToFormat = Regex.Replace(stringToFormat, "\\[SiteUrl\\]", WebUtils.FullPath(SiteUrls.Instance().Home()), RegexOptions.IgnoreCase | RegexOptions.Compiled);
            if (sender != null)
            {
                stringToFormat = Regex.Replace(stringToFormat, "\\[UserAvatarUrl\\]", WebUtils.FullPath(SiteUrls.Instance().UserAvatarUrl(sender.UserID)), RegexOptions.IgnoreCase | RegexOptions.Compiled);
                stringToFormat = Regex.Replace(stringToFormat, "\\[DisplayName\\]", sender.DisplayName, RegexOptions.IgnoreCase | RegexOptions.Compiled);
                stringToFormat = Regex.Replace(stringToFormat, "\\[InviteUrl\\]", WebUtils.FullPath(SiteUrls.Instance().InviteFriendAction(sender.UserID)), RegexOptions.IgnoreCase | RegexOptions.Compiled);
                stringToFormat = Regex.Replace(stringToFormat, "\\[UserProfileUrl\\]", WebUtils.FullPath(SiteUrls.Instance().UserDomainHome(sender)), RegexOptions.IgnoreCase | RegexOptions.Compiled);

                if (sender.UserType == UserTypes.PersonUser)
                {
                    stringToFormat = Regex.Replace(stringToFormat, "\\[JobTitle\\]", ((PersonUser)sender).Title, RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    stringToFormat = Regex.Replace(stringToFormat, "\\[CompanyName\\]", ((PersonUser)sender).CompanyName, RegexOptions.IgnoreCase | RegexOptions.Compiled);
                }
            }
            return stringToFormat;
        }

        /// <summary>
        /// ʽȺûEmial
        /// </summary>
        public static string EmailFormatterForClub(string stringToFormat, User sender, string clubDomainName, string clubName, int clubID)
        {
            DateTime time = DateTime.Now;
            stringToFormat = Regex.Replace(stringToFormat, "\\[SiteName\\]", SiteSettingsManager.GetSiteSettings().SiteName, RegexOptions.IgnoreCase | RegexOptions.Compiled);
            stringToFormat = Regex.Replace(stringToFormat, "\\[SiteUrl\\]", WebUtils.FullPath(SiteUrls.Instance().Home()), RegexOptions.IgnoreCase | RegexOptions.Compiled);
            stringToFormat = Regex.Replace(stringToFormat, "\\[ClubName\\]", clubName, RegexOptions.IgnoreCase | RegexOptions.Compiled);

            if (sender != null)
            {
                stringToFormat = Regex.Replace(stringToFormat, "\\[UserAvatarUrl\\]", WebUtils.FullPath(SiteUrls.Instance().UserAvatarUrl(sender.UserID)), RegexOptions.IgnoreCase | RegexOptions.Compiled);
                stringToFormat = Regex.Replace(stringToFormat, "\\[DisplayName\\]", sender.DisplayName, RegexOptions.IgnoreCase | RegexOptions.Compiled);
                stringToFormat = Regex.Replace(stringToFormat, "\\[InviteUrl\\]", WebUtils.FullPath(SiteUrls.Instance().InviteJoinClubAction(sender.UserID, clubID)), RegexOptions.IgnoreCase | RegexOptions.Compiled);
                stringToFormat = Regex.Replace(stringToFormat, "\\[UserProfileUrl\\]", WebUtils.FullPath(SiteUrls.Instance().UserDomainHome(sender)), RegexOptions.IgnoreCase | RegexOptions.Compiled);

                if (sender.UserType == UserTypes.PersonUser)
                {
                    stringToFormat = Regex.Replace(stringToFormat, "\\[JobTitle\\]", ((PersonUser)sender).Title, RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    stringToFormat = Regex.Replace(stringToFormat, "\\[CompanyName\\]", ((PersonUser)sender).CompanyName, RegexOptions.IgnoreCase | RegexOptions.Compiled);
                }
            }
            return stringToFormat;

        }
        /// <summary>
        /// ʽĸע
        /// </summary>
        /// <param name="stringToFormat">Ҫʽı</param>
        /// <param name="invitationBody">ע</param>
        public static string EmailFormatterForBody(string stringToFormat, string invitationBody)
        {
            stringToFormat = Regex.Replace(stringToFormat, "\\[InvitationBody\\]", invitationBody, RegexOptions.IgnoreCase | RegexOptions.Compiled);
            return stringToFormat;
        }

        /// <summary>
        /// ȡģ
        /// </summary>
        /// <param name="templateName">ģ</param>
        public static InvitationTemplate GetInvitationTemplate(int applicationID)
        {
            User currentUser = Globals.GetCurrentUser();
            string userLanguage = currentUser.Language;

            string defaultLanguage = SPBConfig.Instance().DefaultLanguage;

            // Ensure the user has a language set
            if (string.IsNullOrEmpty(userLanguage))
                userLanguage = defaultLanguage;

            string cacheKey = "InvitationTemplates:" + userLanguage;

            // Attempt to get the resources from the Cache
            //
            Dictionary<int, InvitationTemplate> resources = CacheRepository.Get(cacheKey, false) as Dictionary<int, InvitationTemplate>;
            if (resources == null)
            {
                resources = LoadResource(userLanguage, cacheKey);
            }

            if (resources.ContainsKey(applicationID))
                return (InvitationTemplate)resources[applicationID];
            else
                return null;
        }

        /// <summary>
        /// ȡģ弯
        /// </summary>
        /// <param name="requestType">Ϣ</param>
        ///<param name="transportMode">ϢĴģʽ</param>
        /// <returns></returns>
        public static List<InvitationTemplate> GetInvitationTemplates(int applicationID, InvitationTransportModes transportMode)
        {
            return GetInvitationTemplates(applicationID, transportMode, Globals.GetCurrentUser().Language);
        }

        /// <summary>
        /// ȡģ弯
        /// </summary>
        /// <param name="requestType">Ϣ</param>
        ///<param name="transportMode">ϢĴģʽ</param>
        ///<param name="userLanguage">ûõ</param>
        /// <returns></returns>
        public static List<InvitationTemplate> GetInvitationTemplates(int applicationID, InvitationTransportModes transportMode, string userLanguage)
        {
            string defaultLanguage = SPBConfig.Instance().DefaultLanguage;

            // Ensure the user has a language set
            if (string.IsNullOrEmpty(userLanguage))
                userLanguage = defaultLanguage;

            string cacheKey = "InvitationTemplates:" + userLanguage;

            // Attempt to get the resources from the Cache
            //
            Dictionary<int, InvitationTemplate> resources = CacheRepository.Get(cacheKey, false) as Dictionary<int, InvitationTemplate>;
            if (resources == null)
            {
                resources = LoadResource(userLanguage, cacheKey);
            }

            List<InvitationTemplate> selectedTemplates = new List<InvitationTemplate>();
            foreach (InvitationTemplate m in resources.Values)
            {
                if (m.ApplicationID == applicationID && m.TransportMode == transportMode)
                    selectedTemplates.Add(m);
            }

            return selectedTemplates;
        }

        /// <summary>
        /// ԴļȡϢ
        /// </summary>
        /// <param name="cacheKey">ļ</param>
        /// <param name="language"></param>
        private static Dictionary<int, InvitationTemplate> LoadResource(string language, string cacheKey)
        {
            Dictionary<int, InvitationTemplate> target = new Dictionary<int, InvitationTemplate>();

            string filePath = HttpContext.Current.Server.MapPath(string.Format("~/Languages/" + language + "/emails/{0}", "InvitationTemplates.xml"));

            XmlDocument d = new XmlDocument();
            try
            {
                d.Load(filePath);
            }
            catch
            {
                return target;
            }

            foreach (XmlNode n in d.SelectSingleNode("InvitationTemplates").ChildNodes)
            {
                if (n.NodeType != XmlNodeType.Comment)
                {
                    InvitationTemplate m = new InvitationTemplate(n);
                    target.Add(m.ApplicationID, m);
                }
            }

            CacheDependency dep = new CacheDependency(filePath);
            CacheRepository.Add(cacheKey, target, CachingExpirationTypes.Invariable);

            return target;
        }

    }
}
