﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SpaceBuilder.Common
{
    public class ManageSpecialAppIDs
    {
        #region Instance
        private static volatile ManageSpecialAppIDs _instance = null;
        private static readonly object lockObject = new object();

        public static ManageSpecialAppIDs Instance()
        {
            if (_instance == null)
            {
                lock (lockObject)
                {
                    if (_instance == null)
                    {
                        _instance = new ManageSpecialAppIDs();
                    }
                }
            }
            return _instance;
        }

        private ManageSpecialAppIDs()
        { }
        #endregion

        /// <summary>
        /// 消息
        /// </summary>
        public int Message()
        {
            return -201;
        }
        /// <summary>
        /// 推荐
        /// </summary>
        public int ReCommend()
        {
            return -202;
        }
        /// <summary>
        /// 其他
        /// </summary>
        public int Other()
        {
            return -203;
        }

        /// <summary>
        /// 设置
        /// </summary>
        /// <returns></returns>
        public int Settings()
        {
            return -204;
        }

        /// <summary>
        /// 礼品
        /// </summary>
        public int Gift()
        {
            return 9999;
        }
    }
}
