﻿using System;
using System.Collections.Generic;
//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System.Linq;
using System.Text;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.Common
{
    /// <summary>
    /// 导航实体的扩展方法
    /// </summary>
    public static class NavigationExtensions
    {
        /// <summary>
        /// 空间获取导航的方法
        /// </summary>
        public static string GetUserNavigationUrl(this OwnerNavigation ownerNavigation, string userDomainName)
        {
            if (string.IsNullOrEmpty(ownerNavigation.NavigationUrl))
            {
                if (ownerNavigation.PresentAreaID == PresentAreaIDs.Instance().UserDomain() || ownerNavigation.PresentAreaID == PresentAreaIDs.Instance().CompanyUserDomain())
                {
                    return Globals.GetFullUrlInMainSite(SPBUrlHelper.RouteUrl(ownerNavigation.UrlRouteName, new RouteValueDictionary { { "userDomainName", userDomainName } }));
                }
            }
            return ownerNavigation.ResolvedNavigationUrl;
        }

        /// <summary>
        /// 频道、后台获取导航地址的方法
        /// </summary>
        public static string GetNavigationUrl(this Navigation navigation)
        {
            if (string.IsNullOrEmpty(navigation.NavigationUrl))
            {
                if (navigation.NavigationType == NavigationTypes.Application)
                {
                    if (navigation.PresentAreaID == PresentAreaIDs.Instance().Channel() || navigation.PresentAreaID == PresentAreaIDs.Instance().Manage())
                    {
                        return Globals.GetFullUrlInMainSite(SPBUrlHelper.RouteUrl(navigation.UrlRouteName));
                    }
                }
            }
            return navigation.ResolvedNavigationUrl;
        }
    }
}