﻿//------------------------------------------------------------------------------
//<copyright company="Tunynet">
// Copyright (c) Tunynet Inc.  All rights reserved.
//</copyright> 
//------------------------------------------------------------------------------ 

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.IO;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;

using System.Collections.Specialized;
using System.Configuration;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.Common
{
    /// <summary>
    /// 站点Url配置
    /// </summary>
    /// <remarks>站点大部分url都可以通过Controller/Action来获得，但是还有一部分无法通过Controller/Action来获取的url需要在此进行管理</remarks>
    public class SiteUrls
    {
        #region Instance
        private static volatile SiteUrls _instance = null;
        private static readonly object lockObject = new object();

        public static SiteUrls Instance()
        {
            if (_instance == null)
            {
                lock (lockObject)
                {
                    if (_instance == null)
                    {
                        _instance = new SiteUrls();
                    }
                }
            }
            return _instance;
        }

        private SiteUrls()
        { }
        #endregion

        /// <summary>
        /// 站点首页
        /// </summary>
        public string Home()
        {
            return Globals.GetFullUrlInMainSite("~/");
        }

        /// <summary>
        /// 帮助首页
        /// </summary>
        public string HelpHome()
        {
            return Globals.GetFullUrlInResourceSite("~/help/home.html");
        }

        /// <summary>
        /// 站点favicon.ico图标路径
        /// </summary>
        public string Favicon()
        {
            return Globals.GetFullUrlInResourceSite("~/favicon.ico");
        }

        /// <summary>
        /// 站点共用样式表
        /// </summary>
        public string CommonCss()
        {
            return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/common.css");
        }
        /// <summary>
        /// 站点共用样式表
        /// </summary>
        public string TN_CoreCss()
        {
            return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/tn.core_src.css");
        }
        /// <summary>
        /// 站点共用样式表
        /// </summary>
        public string TN_ThemeCss()
        {
            return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/tn.theme_src.css");
        }
        /// <summary>
        /// 站点共用样式表
        /// </summary>
        public string TN_WidgetsCss()
        {
            return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/tn.widgets_src.css");
        }

        ///// <summary>
        ///// 验证码图片路径
        ///// </summary>
        ///// <param name="codeLength">验证码长度</param>
        ///// <param name="fontSize">验证码字体大小</param>
        ///// <param name="enableChaos">是否允许噪点</param>
        //public string VerifyCodeImage(int codeLength, int fontSize, bool enableChaos)
        //{
        //    return Globals.GetFullUrlInMainSite(string.Format("~/Services/VerifyCodeImage.ashx?codeLength={0}&fontSize={1}&enableChaos={2}", codeLength, fontSize, enableChaos));
        //}

        /// <summary>
        /// 生成RSS阅读计数的图片链接
        /// </summary>
        /// <param name="conterType">计数器对象</param>
        /// <param name="itemID">增加rss计数的ItemID</param>
        public string AggView(Type conterType, int itemID)
        {
            return Globals.GetFullUrlInMainSite(string.Format("~/Services/AggView.ashx?ItemID={0}&ConterType={1}", itemID, WebUtils.UrlEncode(conterType.AssemblyQualifiedName)));
        }

        #region User

        ///<overloads>用户头像url</overloads>
        /// <summary>
        /// 用户头像url
        /// </summary>
        public string UserAvatarUrl(int userID)
        {
            return UserAvatarUrl(userID, AvatarSizeTypes.Normal);
        }

        ///<overloads>用户头像url</overloads>
        /// <summary>
        /// 用户头像url
        /// </summary>
        public string UserAvatarUrl(int userID, AvatarSizeTypes avatarSizeType)
        {
            return UserAvatarUrl(userID, avatarSizeType, true);
        }

        ///<overloads>用户头像url</overloads>
        /// <summary>
        /// 用户头像url
        /// </summary>
        public string UserAvatarUrl(int userID, AvatarSizeTypes avatarSizeType, bool enableClientCaching)
        {
            UserAvatarType userAvatarType = UserAvatarType.NoAvatar_Default;
            User user = Users.GetUser(userID, false);
            User currentUser = Globals.GetCurrentUser();
            bool hasManagePermession = currentUser != null && (currentUser.UserID == userID || currentUser.IsContentAdministrator);
            if (user != null)
            {
                if (!user.HasAvatar || !user.EnableAvatar && !hasManagePermession)
                {
                    if (user.UserType == UserTypes.CompanyUser)
                        userAvatarType = UserAvatarType.NoAvatar_DefaultForCompany;
                    else
                    {
                        PersonUser pu = user as PersonUser;
                        if (pu.Gender == Genders.Male)
                            userAvatarType = UserAvatarType.NoAvatar_Male;
                        else if (pu.Gender == Genders.Female)
                            userAvatarType = UserAvatarType.NoAvatar_Female;
                        else
                            userAvatarType = UserAvatarType.NoAvatar_Default;
                    }
                }
                else
                {
                    userAvatarType = UserAvatarType.Normal;
                }
            }

            //如果禁用客户端缓存，则使用Handler地址
            if (!enableClientCaching)
                return Globals.GetFullUrlInFileHandlerSite(Avatars.StorageProviderName, string.Format("~/services/UserAvatar.ashx?UserID={0}&AvatarType={1}&AvatarSizeType={2}&enableCaching={3}", userID, (int)userAvatarType, (int)avatarSizeType, enableClientCaching));

            if (userAvatarType != UserAvatarType.Normal)
            {
                string avatarFileName;
                switch (userAvatarType)
                {
                    case UserAvatarType.HideAvatar:
                        switch (avatarSizeType)
                        {
                            case AvatarSizeTypes.Card:
                                avatarFileName = "portrait_hide_medium.png";
                                break;
                            case AvatarSizeTypes.Normal:
                                avatarFileName = "portrait_hide.gif";
                                break;
                            case AvatarSizeTypes.Small:
                                avatarFileName = "portrait_hide_small.gif";
                                break;
                            default:
                                avatarFileName = "portrait_hide.gif";
                                break;
                        }
                        break;
                    case UserAvatarType.NoAvatar_Default:
                        switch (avatarSizeType)
                        {
                            case AvatarSizeTypes.Card:
                                avatarFileName = "portrait_default_medium.png";
                                break;
                            case AvatarSizeTypes.Normal:
                                avatarFileName = "portrait_default.gif";
                                break;
                            case AvatarSizeTypes.Small:
                                avatarFileName = "portrait_default_small.gif";
                                break;
                            default:
                                avatarFileName = "portrait_default.gif";
                                break;
                        }
                        break;
                    case UserAvatarType.NoAvatar_Male:
                        switch (avatarSizeType)
                        {
                            case AvatarSizeTypes.Card:
                                avatarFileName = "portrait_boy_medium.png";
                                break;
                            case AvatarSizeTypes.Normal:
                                avatarFileName = "portrait_boy.gif";
                                break;
                            case AvatarSizeTypes.Small:
                                avatarFileName = "portrait_boy_small.gif";
                                break;
                            default:
                                avatarFileName = "portrait_boy.gif";
                                break;
                        }
                        break;
                    case UserAvatarType.NoAvatar_Female:
                        switch (avatarSizeType)
                        {
                            case AvatarSizeTypes.Card:
                                avatarFileName = "portrait_girl_medium.png";
                                break;
                            case AvatarSizeTypes.Normal:
                                avatarFileName = "portrait_girl.gif";
                                break;
                            case AvatarSizeTypes.Small:
                                avatarFileName = "portrait_girl_small.gif";
                                break;
                            default:
                                avatarFileName = "portrait_girl.gif";
                                break;
                        }
                        break;
                    case UserAvatarType.NoAvatar_DefaultForCompany:
                        switch (avatarSizeType)
                        {
                            case AvatarSizeTypes.Card:
                                avatarFileName = "portrait_company_medium.png";
                                break;
                            case AvatarSizeTypes.Normal:
                                avatarFileName = "portrait_company.gif";
                                break;
                            case AvatarSizeTypes.Small:
                                avatarFileName = "portrait_company_small.gif";
                                break;
                            default:
                                avatarFileName = "portrait_company.gif";
                                break;
                        }
                        break;
                    default:
                        switch (avatarSizeType)
                        {
                            case AvatarSizeTypes.Card:
                                avatarFileName = "portrait_default_medium.png";
                                break;
                            case AvatarSizeTypes.Normal:
                                avatarFileName = "portrait_default.gif";
                                break;
                            case AvatarSizeTypes.Small:
                                avatarFileName = "portrait_default_small.gif";
                                break;
                            default:
                                avatarFileName = "portrait_default.gif";
                                break;
                        }
                        break;
                }
                return Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Images/" + avatarFileName);
            }

            if (FileStorageProvider.Instance(Avatars.StorageProviderName).EnableDirectlyUrl)
                return Avatars.GetDirectlyUrl(userID, avatarSizeType);

            return Globals.GetFullUrlInFileHandlerSite(Avatars.StorageProviderName, string.Format("~/services/UserAvatar.ashx?UserID={0}&AvatarType={1}&AvatarSizeType={2}", userID, (int)userAvatarType, (int)avatarSizeType));

        }

        /// <summary>
        /// 下载电子名片
        /// </summary>
        /// <param name="userID">UserID</param>
        public string DownloadVCard(int userID)
        {
            return Globals.GetFullUrlInMainSite(string.Format("~/services/DownloadVCard.ashx?UserID={0}", userID));
        }

        /// <summary>
        /// 企业LogoUrl
        /// </summary>
        public string CompanyLogoUrl(int userID)
        {
            return CompanyLogoUrl(userID, true);
        }

        /// <summary>
        /// 企业LogoUrl
        /// </summary>
        public string CompanyLogoUrl(int userID, bool enableClientCaching)
        {
            if (enableClientCaching)
                return Globals.GetFullUrlInFileHandlerSite(Avatars.StorageProviderName, string.Format("~/Services/CompanyLogo.ashx?UserID={0}", userID));
            else
                return Globals.GetFullUrlInFileHandlerSite(Avatars.StorageProviderName, string.Format("~/Services/CompanyLogo.ashx?UserID={0}&enableCaching={1}", userID, enableClientCaching));
        }

        /// <summary>
        /// 根据站点标签列表显示文件
        /// </summary>
        public string ListUsersByTag(string tagName)
        {
            return SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary { { "TagName", WebUtils.UrlEncode(tagName) } });
        }

        #endregion

        #region 第三方账号

        public string LoginToQQ()
        {
            return SPBUrlHelper.RouteUrl("Common", new RouteValueDictionary { { "action", "LoginToQQ" }, { "controller", "ChannelUser" } });
        }

        public string LoginToSina()
        {
            return SPBUrlHelper.RouteUrl("Common", new RouteValueDictionary { { "action", "LoginToSina" }, { "controller", "ChannelUser" } });
        }

        #endregion

        #region 友情链接

        /// <summary>
        /// 友情链接图片链接
        /// </summary>
        /// <param name="linkID"></param>
        /// <param name="linkPositionCurrent"></param>
        /// <returns></returns>
        public string LinkPhoto(Link link, LinkPosition linkPosition)
        {
            if (FileStorageProvider.Instance(LinkManager.StorageProviderName).EnableDirectlyUrl)
            {
                LinkManager linkManager = null;
                switch (linkPosition)
                {
                    case LinkPosition.Site:
                        linkManager = SiteLinkManager.Instance();
                        break;
                    case LinkPosition.User:
                        linkManager = UserLinkManager.Instance();
                        break;
                    case LinkPosition.Club:
                        linkManager = SpaceBuilder.Club.ClubLinkManager.Instance();
                        break;
                }

                return linkManager.GetLinkPhotoDirectlyUrl(link);
            }

            return Globals.GetFullUrlInFileHandlerSite(LinkManager.StorageProviderName, string.Format("~/Services/LinkPhoto.ashx?linkPosition={0}&linkID={1}", (int)linkPosition, link.LinkID));
        }

        #endregion

        #region 礼品图片


        public string GiftPhoto(ConvertibleGift gift)
        {
            if (FileStorageProvider.Instance(ConvertibleGifts.StorageProviderName).EnableDirectlyUrl)
            {
                return ConvertibleGifts.GetGiftPhotoDirectlyUrl(gift);
            }

            return Globals.GetFullUrlInFileHandlerSite(ConvertibleGifts.StorageProviderName, string.Format("~/Services/giftPhoto.ashx?giftID={0}", gift.GiftID));
        }


        #endregion

        #region 礼品图片


        public string IdentityIcon(Identity identity, IdentityIconTypes iconType)
        {
            if (identity == null)
                return string.Empty;
            if (FileStorageProvider.Instance(Identities.StorageProviderName).EnableDirectlyUrl)
            {
                return Identities.GetIdentityIconDirectlyUrl(identity, iconType);
            }

            return Globals.GetFullUrlInFileHandlerSite(Identities.StorageProviderName, string.Format("~/Services/IdentityIcon.ashx?identityID={0}&iconType={1}", identity.IdentityID, iconType));
        }


        #endregion

        #region 广告
        /// <summary>
        /// 下载临时附件
        /// </summary>
        public string AdvertisingPositionImage(string positionCode)
        {
            return Globals.GetFullUrlInFileHandlerSite(Advertisings.StorageProviderName, "~/Services/ADPositionPhoto.ashx?positionCode=" + positionCode);
        }

        #endregion

        #region 需重复配置的URL

        #region 不同版本IIS，URL也是相同的
        #region Manage

        /// <summary>
        ///  站点装扮
        /// </summary>
        public string ModifyHome()
        {
            return Globals.GetFullUrlInMainSite("~/Channel.aspx/ModifyHome");
        }

        /// <summary>
        /// 后台管理首页
        /// </summary>
        public string ManageHome()
        {
            return Globals.GetFullUrlInMainSite("~/Manage/Default.aspx");
        }

        /// <summary>
        /// 后台登录
        /// </summary>        
        public string ManageLogin()
        {
            HttpContext httpContext = HttpContext.Current;

            string currentPath = httpContext.Request.Url.PathAndQuery;
            string returnUrl = SiteUrls.ExtractQueryParams(currentPath)["ReturnUrl"];

            if (string.IsNullOrEmpty(returnUrl))
                return Globals.GetFullUrlInMainSite(string.Format("~/Manage/Manage.aspx/ManageLogin?ReturnUrl={0}", WebUtils.UrlEncode(HttpContext.Current.Request.RawUrl)));     //把ReturnUrl进行 UrlEncode
            else
                return Globals.GetFullUrlInMainSite(string.Format("~/Manage/Manage.aspx/ManageLogin?ReturnUrl={0}", returnUrl));
        }

        /// <summary>
        /// 管理信息
        /// </summary>
        /// <returns></returns>
        public string ManageMessage()
        {
            return Globals.GetFullUrlInMainSite("~/Manage/Auxiliaries.aspx/MessageInBox");
        }

        /// <summary>
        /// 管理
        /// </summary>
        /// <returns></returns>
        public string ManageSettings()
        {
            return Globals.GetFullUrlInMainSite("~/Manage/ManageSettings.aspx/DataBackup");
        }

        #endregion

        #region ChannelUser

        /// <summary>
        /// 用户注册
        /// </summary>
        public string UserRegister()
        {
            return Globals.GetFullUrlInMainSite(string.Format("~/User/Register.aspx"));
        }

        /// <summary>
        /// 邀请注册
        /// </summary>
        /// <param name="inviteUserID">邀请人用户ID</param>
        public string RegisterByUserInvite(int inviteUserID)
        {
            string token = EncryptManager.EncryptTokenForInviteFriend(inviteUserID.ToString());
            token = WebUtils.UrlEncode(token);

            return Globals.GetFullUrlInMainSite(string.Format("~/User/Register.aspx?Token={0}", token));
        }

        /// <summary>
        /// 邀请注册
        /// </summary>
        /// <param name="inviteUserID">邀请人用户ID</param>
        public string RegisterByUserInvite(string token)
        {
            return Globals.GetFullUrlInMainSite(string.Format("~/User/Register.aspx?Token={0}", token));
        }

        /// <summary>
        /// 登录
        /// </summary>
        public string Login()
        {
            return Login(string.Empty, string.Empty);
        }

        /// <summary>
        /// 用户登录成功后自动转到站点首页
        /// </summary>
        public string LoginReturnHome()
        {
            return Login(WebUtils.UrlEncode(Home()), string.Empty);
        }

        /// <summary>
        /// 登录
        /// </summary>
        public string LoginByInvite(int inviteUserID)
        {
            string token = EncryptManager.EncryptTokenForInviteFriend(inviteUserID.ToString());
            token = WebUtils.UrlEncode(token);

            return Login(string.Empty, token);
        }

        /// <summary>
        /// 登录
        /// </summary>
        public string LoginByInvite(string token)
        {
            return Login(string.Empty, token);
        }

        /// <summary>
        /// 登录
        /// </summary>
        /// <param name="includeReturnUrl">是否包含returnUrl</param>
        public string Login(bool includeReturnUrl)
        {
            if (includeReturnUrl)
            {
                HttpContext httpContext = HttpContext.Current;

                string currentPath = httpContext.Request.Url.PathAndQuery;
                string returnUrl = SiteUrls.ExtractQueryParams(currentPath)["ReturnUrl"];
                if (string.IsNullOrEmpty(returnUrl))
                {
                    return Login(WebUtils.UrlEncode(HttpContext.Current.Request.RawUrl), string.Empty);
                }
                else
                {
                    return Login(returnUrl, string.Empty);
                }
            }
            else
            {
                return Login();
            }
        }

        /// <summary>
        /// 登录
        /// </summary>
        public string EnterWizardMode(string userDomainName)
        {
            return SPBUrlHelper.RouteUrl("Channel_User_Common", new RouteValueDictionary { { "action", "UploadAvatar" }, { "userDomainName", userDomainName } });
        }

        /// <summary>
        /// 登录
        /// </summary>
        private string Login(string ReturnUrl, string Token)
        {
            return SPBUrlHelper.RouteUrl("Channel_User_Common", new RouteValueDictionary { { "action", "Login" }, { "ReturnUrl", ReturnUrl }, { "Token", Token } });
        }

        /// <summary>
        /// 登录框
        /// </summary>
        public string LoginInModal()
        {
            return SPBUrlHelper.RouteUrl("Channel_User_Common", new RouteValueDictionary { { "action", "LoginInModal" }, { "ReturnUrl", WebUtils.UrlEncode(HttpContext.Current.Request.RawUrl) } });
        }

        /// <summary>
        /// 重发验证码
        /// </summary>
        public string ResendVerificationCode(string userName)
        {
            return Globals.GetFullUrlInMainSite(string.Format("~/User/ResendVerificationCode.aspx?userName={0}", userName));
        }

        /// <summary>
        /// 用户注册后验证用户Email
        /// </summary>
        public string ValidateUserEmail(User user)
        {
            string token = EncryptManager.EncryptTokenForInviteFriend(string.Format("{0},{1}", user.MembershipID, DateTime.Now.AddDays(SPBConfig.Instance().Highlinktimeliness)));
            return Globals.GetFullUrlInMainSite(string.Format("~/User/ValidateUserEmail.aspx?userName={0}&token={1}", WebUtils.UrlEncode(user.UserName), token));
        }

        /// <summary>
        /// 用户重设密码
        /// </summary>
        public string UserResetPassword(User user)
        {
            string token = EncryptManager.EncryptTokenForInviteFriend(string.Format("{0},{1}", user.MembershipID, DateTime.Now.AddDays(SPBConfig.Instance().Highlinktimeliness)));
            return Globals.GetFullUrlInMainSite(string.Format("~/User/ResetPassword.aspx?userName={0}&token={1}", user.UserName, token));
        }

        /// <summary>
        /// 忘记密码
        /// </summary>
        public string ForgotPassword()
        {
            return Globals.GetFullUrlInMainSite("~/User/ForgotPassword.aspx");
        }

        /// <summary>
        /// 邀请朋友
        /// </summary>
        /// <param name="inviteUserID">邀请人用户ID</param>
        public string InviteFriendAction(int inviteUserID)
        {

            string token = EncryptManager.EncryptTokenForInviteFriend(string.Format("{0},{1}", inviteUserID.ToString(), DateTime.Now.AddDays(SPBConfig.Instance().Lowlinktimeliness)));
            token = WebUtils.UrlEncode(token);
            return Globals.GetFullUrlInMainSite(string.Format("~/User/InvitationFriend.aspx?Token={0}", token));
        }

        /// <summary>
        /// 邀请朋友
        /// </summary>
        /// <param name="inviteUserID">邀请人用户ID</param>
        public string InviteJoinClubAction(int inviteUserID, int inviteClubID)
        {

            string token = EncryptManager.EncryptTokenForInviteFriend(string.Format("{0},{1},{2}", inviteUserID.ToString(), DateTime.Now.AddDays(SPBConfig.Instance().Lowlinktimeliness), inviteClubID.ToString()));
            //token = WebUtils.UrlEncode(token);
            string dd = EncryptManager.DecryptTokenForInviteFriend(token);
            return Globals.GetFullUrlInMainSite(string.Format("~/User/InvitationJoinClub.aspx?Token={0}", token));
        }

        /// <summary>
        /// 邀请朋友加入群组
        /// </summary>

        public string InviteFriendAddClubAction(int inviteUserID, string clubDomainName)
        {

            string token = EncryptManager.EncryptTokenForInviteFriend(string.Format("{0},{1}", inviteUserID.ToString(), DateTime.Now.AddDays(SPBConfig.Instance().Lowlinktimeliness)));
            token = WebUtils.UrlEncode(token);
            return Globals.GetFullUrlInMainSite(string.Format("~/{0}/InvitationJoin.aspx?Token={1}", clubDomainName, token));
        }


        #endregion

        #region Channel

        /// <summary>
        /// 创建举报（必须用模式框）
        /// </summary>
        public string NewImpeachReport()
        {
            return Globals.GetFullUrlInMainSite(string.Format("~/Channel.aspx/NewImpeachReport"));
        }

        /// <summary>
        /// 站点暂停页面
        /// </summary>
        public string SitePause()
        {
            return Globals.GetFullUrlInMainSite(string.Format("~/Channel.aspx/SiteSuspended"));
        }

        /// <summary>
        /// 显示表情图片选择模式框
        /// </summary>
        /// <remarks>
        /// 用于HtmlEditor
        /// </remarks>
        public string SmileySelector()
        {
            return WebUtils.ResolveUrl("~/Channel.aspx/Control_SmileySelector");
        }

        /// <summary>
        /// 显示表情图片选择模式框
        /// </summary>
        public string SmileySelector(string textAreaID)
        {
            return WebUtils.ResolveUrl(string.Format("~/Channel.aspx/Control_SmileySelector?textAreaID={0}", textAreaID));
        }

        /// <summary>
        /// 用户内容选择器
        /// </summary>
        public string UserContentSelector(string manageAttachmentsUrl)
        {
            return UserContentSelector(manageAttachmentsUrl, true);
        }
        /// <summary>
        /// 用户内容选择器
        /// </summary>
        public string UserContentSelector(string manageAttachmentsUrl, bool isImage)
        {
            return SPBUrlHelper.RouteUrl("Common", new RouteValueDictionary { { "action", "UserContentSelector" }, { "manageAttachmentsUrl", WebUtils.UrlEncode(manageAttachmentsUrl) }, { "isImage", isImage } });
        }

        //管理员推荐
        public string RecommendItem(int applicationID, int domainUserID, int itemID, string itemName)
        {
            return RecommendItem(applicationID, domainUserID, itemID, itemName, null);
        }

        //管理员推荐
        public string RecommendItem(int applicationID, int domainUserID, int itemID, string itemName, string excludeTypeIDs)
        {
            return Globals.GetFullUrlInMainSite(string.Format("~/Channel.aspx/Control_RecommendItem?applicationID={0}&domainUserID={1}&itemID={2}&itemName={3}&excludeTypeIDs={4}", applicationID, domainUserID, itemID, WebUtils.UrlEncode(itemName), excludeTypeIDs));
        }

        //管理员推荐
        public string RecommendItem(int applicationID, int domainUserID, int itemID, string itemName, int onlyTypeID)
        {
            return Globals.GetFullUrlInMainSite(string.Format("~/Channel.aspx/Control_RecommendItem?applicationID={0}&domainUserID={1}&itemID={2}&itemName={3}&onlyTypeID={4}", applicationID, domainUserID, itemID, WebUtils.UrlEncode(itemName), onlyTypeID.ToString()));
        }

        #endregion

        #region UserDomain

        /// <summary>
        /// 用户空间OpenSocial应用列表
        /// </summary>
        /// <param name="isEnabled"></param>
        /// <returns></returns>
        public string OpenSocialApplications(string userDomainName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_OpenSocial_Common", new RouteValueDictionary { { "action", "ListOsApplications" }, { "userDomainName", userDomainName } });
        }

        /// <summary>
        /// 显示OpenSocial Application
        /// </summary>
        /// <param name="userDomainName"></param>
        /// <param name="applicationID"></param>
        /// <returns></returns>
        public string ShowOsApplication(string userDomainName, int applicationID)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_OpenSocial_ShowApplication", new RouteValueDictionary { { "userDomainName", userDomainName }, { "applicationID", applicationID } });
        }

        #endregion

        #endregion

        #region 不同版本IIS，需要显示友好URL的

        #region UserDomain User

        /// <summary>
        /// 用户更新密码
        /// </summary>
        public string UserChangePassword(User user)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_Settings_Common", new RouteValueDictionary { { "UserDomainName", user.UserName }, { "action", "ChangePassword" } });
        }

        /// <summary>
        /// 用户更新档案
        /// </summary>
        public string UserEditProfile(User user)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_Settings_Common", new RouteValueDictionary { { "UserDomainName", user.UserName } });
        }

        /// <summary>
        /// 用户看自己空间时的空间主页
        /// </summary>
        public string UserDomainMasterHome(string userDomainName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_MasterHome", new RouteValueDictionary { { "UserDomainName", userDomainName } });
        }

        /// <summary>
        /// 用户空间主页
        /// </summary>
        public string UserDomainHome(string userDomainName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_Home", new RouteValueDictionary { { "UserDomainName", userDomainName } });
        }

        /// <summary>
        /// 用户空间主页
        /// </summary>
        public string UserDomainHome(User user)
        {
            if (user == null)
                return string.Empty;
            return UserDomainHome(user.UserName);
        }

        /// <summary>
        /// 用户空间主页
        /// </summary>
        public string UserDomainHome(int userID)
        {
            string userName = UserID2UserNameDictionary.GetUserName(userID);
            return UserDomainHome(userName);
        }

        /// <summary>
        /// 用户空间信息中心首页
        /// </summary>
        public string UserMessageHome(User user)
        {
            User currentUser = Globals.GetCurrentUser();
            if (currentUser != null && (currentUser.UserID == user.UserID || currentUser.IsContentAdministrator))
            {
                return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", user.UserName }, { "action", "ListMessageInBox" } });
            }
            else
            {
                return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", user.UserName } });
            }
        }

        /// <summary>
        /// 查看用户档案
        /// </summary>
        public string UserProfile(User user)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_Home", new RouteValueDictionary { { "UserDomainName", user.UserName } });
        }

        /// <summary>
        /// 展示我的朋友(仅适用与个人用户)
        /// </summary>
        public string UserFriendHome(string userName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_Friend_Common", new RouteValueDictionary { { "UserDomainName", userName } });
        }

        /// <summary>
        /// 用户空间 基础设置首页
        /// </summary>
        public string UserSettingsHome(string userName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_Settings_Common", new RouteValueDictionary { { "UserDomainName", userName } });
        }

        /// <summary>
        /// 发消息
        /// </summary>
        public string NewMessage(string userDomainName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "NewMessage" } });
        }
        /// <summary>
        /// 向某个人发消息
        /// </summary>
        public string NewMessage(string userDomainName, int toUserID)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "NewMessage" }, { "toUserID", toUserID } });
        }

        /// <summary>
        /// 显示私信
        /// </summary>
        /// <param name="userName">用户个人空间的域名</param>
        ///<param name="threadID">私信主题ID</param>
        public string ShowPrivateMessage(string userDomainName, int threadID)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "ShowMessage" }, { "ThreadID", threadID } });
        }
        /// <summary>
        /// 私信收件箱
        /// </summary>
        public string ListMessageInBox(string userDomainName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "ListMessageInBox" } });
        }
        /// <summary>
        /// 收到的邀请
        /// </summary>
        public string ListInvitationInBox(string userDomainName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "ListInvitationInBox" } });
        }

        /// <summary>
        /// 通知列表
        /// </summary>
        public string ListNoticeRecords(string userDomainName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "ListNoticeRecords" } });
        }

        /// <summary>
        /// 积分列表
        /// </summary>
        public string ListPointRecords(string userDomainName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "ListPointRecords" } });
        }

        /// <summary>
        /// 通知设置 
        /// </summary>
        public string UserNoticeSettings(string userName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_Settings_Common", new RouteValueDictionary { { "UserDomainName", userName }, { "action", "NoticeSettings" } });
        }
        /// <summary>
        /// 隐私设置 
        /// </summary>
        public string UserPrivacySettings(string userDomainName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_Settings_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "PrivacySettings" } });
        }

        /// <summary>
        /// 接收的邀请
        /// </summary>
        public string InvitationInbox(string userDomainName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "ListInvitationInBox" } });
        }

        /// <summary>
        /// 显示用户的留言列表
        /// </summary>
        public string ListGuestBookPosts(string userDomainName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "ShowGuestBook" } });
        }

        /// <summary>
        /// 创建朋友邀请(Email)
        /// </summary>
        public string NewFriendInvitationByEmail(string userDomainName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "NewFriendInvitationByEmail" } });
        }
        /// <summary>
        /// 加为好友
        /// </summary>
        /// <param name="userDomainName">当前登录用户的DomainName</param>
        /// <param name="toUserID">被加为好友的UserID</param>
        public string NewFriendInvitation(string userDomainName, int toUserID)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_MessageCenter_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "NewFriendInvitation" }, { "toUserID", toUserID } });
        }

        #endregion

        #region Channel

        /// <summary>
        /// 异常信息显示页面
        /// </summary>
        /// <param name="exceptionType">异常信息类型<seealso cref="ExceptionType"/></param>
        public string ShowExceptionMessage(string exceptionType)
        {
            return ShowExceptionMessage(exceptionType, null, null);
        }

        public string ShowExceptionMessage(string exceptionType, string message)
        {
            return ShowExceptionMessage(exceptionType, message, null);
        }

        /// <summary>
        /// 异常信息显示页面
        /// </summary>
        /// <param name="exceptionType">异常信息类型<seealso cref="ExceptionType"/></param>
        /// <param name="message">错误提示信息</param>
        public string ShowExceptionMessage(string exceptionType, string message, int? applicationID)
        {
            if (string.IsNullOrEmpty(message))
                return SPBUrlHelper.RouteUrl("ShowExceptionMessage", new RouteValueDictionary { { "exceptionType", exceptionType }, { "applicationID", applicationID } });
            else
                return SPBUrlHelper.RouteUrl("ShowExceptionMessage", new RouteValueDictionary { { "exceptionType", exceptionType }, { "message", WebUtils.UrlEncode(message) }, { "applicationID", applicationID } });
        }
        /// <summary>
        /// 404错误页
        /// </summary>
        public string Error404()
        {
            return SPBUrlHelper.RouteUrl("Error404");
        }
        /// <summary>
        /// 404错误页
        /// </summary>
        public string Error404(string title)
        {
            return SPBUrlHelper.RouteUrl("Error404", new RouteValueDictionary { { "title", WebUtils.UrlEncode(title) } });
        }
        /// <summary>
        /// 404错误页
        /// </summary>
        public string Error404(string title, string body)
        {
            return SPBUrlHelper.RouteUrl("Error404", new RouteValueDictionary { { "title", WebUtils.UrlEncode(title) }, { "body", WebUtils.UrlEncode(body) } });
        }
        /// <summary>
        /// 错误页
        /// </summary>
        /// <param name="message">提示信息</param>
        public string Error(string message)
        {
            return SPBUrlHelper.RouteUrl("Error", new RouteValueDictionary { { "message", WebUtils.UrlEncode(message) } });
        }

        /// <summary>
        /// 提示页
        /// </summary>
        public string ShowValidationMessage(string exceptionType)
        {
            return SPBUrlHelper.RouteUrl("ShowValidationMessage", new RouteValueDictionary { { "exceptionType", exceptionType } });
        }

        /// <summary>
        /// 提示页
        /// </summary>
        /// <param name="message">提示信息</param>
        public string ShowValidationMessage(string exceptionType, string message)
        {
            return SPBUrlHelper.RouteUrl("ShowValidationMessage", new RouteValueDictionary { { "exceptionType", exceptionType }, { "message", WebUtils.UrlEncode(message) } });
        }

        /// <summary>
        /// 简洁主页
        /// </summary>
        public string SimpleHome()
        {
            return SPBUrlHelper.RouteUrl("SimpleHome");
        }

        /// <summary>
        /// 会员频道首页
        /// </summary>
        public string ChannelMemberHome()
        {
            return SPBUrlHelper.RouteUrl("Channel_Member_Home");
        }

        /// <summary>
        /// 群组频道首页
        /// </summary>
        public string ChannelClubHome()
        {
            return SPBUrlHelper.RouteUrl("Channel_Club_Home");
        }

        #endregion

        #region Club
        /// <summary>
        /// 显示群组首页
        /// </summary>
        public string ClubDomainHome(string clubDomainName)
        {
            return SPBUrlHelper.RouteUrl("ClubDomain_Home", new RouteValueDictionary { { "ClubDomainName", clubDomainName } });
        }

        /// <summary>
        /// 根据群组ID显示群组首页
        /// </summary>
        public string ClubDomainHome(int clubID)
        {
            string clubDomainName = Club.ClubID2ClubNameDictionary.GetClubDomainName(clubID);
            return ClubDomainHome(clubDomainName);
        }

        #endregion

        #region UserChannelHome

        /// <summary>
        /// 用户空间不同频道首页
        /// </summary>
        /// <param name="userID">谁的用户空间</param>
        public string UserChannelHome(int userID, int applicationID)
        {
            if (userID > 0)
            {
                User user = Users.GetUser(userID, false);
                return SiteUrls.Instance().UserChannelHome(user, applicationID);
            }
            else
                return string.Empty;
        }
        /// <summary>
        /// 用户空间不同频道首页
        /// </summary>
        /// <param name="userID">谁的用户空间</param>
        public string UserChannelHome(string userDomainName, int applicationID)
        {
            if (!string.IsNullOrEmpty(userDomainName))
            {
                User user = Users.GetUser(userDomainName, false);
                return SiteUrls.Instance().UserChannelHome(user, applicationID);
            }
            else
                return string.Empty;
        }

        /// <summary>
        /// 用户空间某应用的首页
        /// </summary>
        public string UserChannelHome(User user, int applicationID)
        {
            if (user != null)
            {
                if (applicationID == UserDomainSpecialAppIDs.Instance().Home())
                    return SiteUrls.Instance().UserDomainHome(user);
                else if (applicationID == UserDomainSpecialAppIDs.Instance().MessageHome())
                    return SiteUrls.Instance().UserMessageHome(user);
                else if (applicationID == UserDomainSpecialAppIDs.Instance().UserSettingsHome())
                    return SiteUrls.Instance().UserSettingsHome(user.UserName);
                else if (applicationID == UserDomainSpecialAppIDs.Instance().AboutCompany())
                    return SPBUrlHelper.RouteUrl("UserDomain_Common", new RouteValueDictionary { { "userDomainName", user.UserName }, { "action", "AboutCompany" } });

                if (user != null && applicationID > 0)
                {
                    int presentAreaID = PresentAreaIDs.Instance().UserDomain();
                    if (user.UserType == UserTypes.CompanyUser)
                        presentAreaID = PresentAreaIDs.Instance().CompanyUserDomain();
                    Navigation navigation = Navigations.GetDefaultNavigation(presentAreaID, applicationID);
                    if (navigation == null)
                        return SiteUrls.Instance().Home();
                    return SPBUrlHelper.RouteUrl(navigation.UrlRouteName, new RouteValueDictionary { { "UserDomainName", user.UserName } });
                }
            }
            return string.Empty;
        }

        #endregion

        #endregion

        #endregion

        #region 分享内容给好友
        /// <summary>
        /// 分享内容给好友
        /// </summary>
        public string ShareToMyFriends(int applicationID, string contentSubject, string contentBody, string contentImgUrl, string contentUrl, string contentAuthor, int contentUserID)
        {
            return SPBUrlHelper.RouteUrl("Common", new RouteValueDictionary { { "action", "ShareToMyFriends" }, { "applicationID", applicationID }, { "contentImgUrl", WebUtils.UrlEncode(contentImgUrl) }, { "contentUrl", WebUtils.UrlEncode(contentUrl) }, { "contentAuthor", WebUtils.UrlEncode(contentAuthor) }, { "contentUserID", contentUserID }, { "contentSubject", WebUtils.UrlEncode(contentSubject) }, { "contentBody", WebUtils.UrlEncode(contentBody) } });
        }
        #endregion
        #region 公告
        /// <summary>
        /// 显示公告
        /// </summary>
        public string ShowAnnouncement(int threadID)
        {
            return SPBUrlHelper.RouteUrl("Channel_Announcement_ShowAnnouncement", new RouteValueDictionary { { "threadID", threadID } });
        }
        #endregion

        #region Help Methods

        /// <summary>
        /// 获取url中的查询字符串参数
        /// </summary>
        public static NameValueCollection ExtractQueryParams(string url)
        {
            int startIndex = url.IndexOf("?");
            NameValueCollection values = new NameValueCollection();

            if (startIndex <= 0)
                return values;

            string[] nameValues = url.Substring(startIndex + 1).Split('&');

            foreach (string s in nameValues)
            {
                string[] pair = s.Split('=');

                string name = pair[0];
                string value = string.Empty;

                if (pair.Length > 1)
                    value = pair[1];

                values.Add(name, value);
            }

            return values;
        }


        private int iisVersion = -1;
        /// <summary>
        /// iis版本
        /// </summary>
        public int IISVersion
        {
            get
            {
                if (iisVersion == -1)
                {
                    int.TryParse(ConfigurationManager.AppSettings["IISVersion"], out iisVersion);
                }

                return iisVersion;
            }
        }

        #endregion
    }
}
