﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SpaceBuilder.Common
{
    public class UserDomainSpecialAppIDs
    {
        #region Instance
        private static volatile UserDomainSpecialAppIDs _instance = null;
        private static readonly object lockObject = new object();

        public static UserDomainSpecialAppIDs Instance()
        {
            if (_instance == null)
            {
                lock (lockObject)
                {
                    if (_instance == null)
                    {
                        _instance = new UserDomainSpecialAppIDs();
                    }
                }
            }

            return _instance;
        }

        private UserDomainSpecialAppIDs()
        { }
        #endregion

        /// <summary>
        /// 个人中心
        /// </summary>        
        public int MyHome()
        {
            return -201;
        }
        /// <summary>
        /// 空间主页
        /// </summary>
        public int Home()
        {
            return -202;
        }

        /// <summary>
        /// 信息中心
        /// </summary>
        public int MessageHome()
        {
            return -203;
        }

        /// <summary>
        /// 用户设置
        /// </summary>
        public int UserSettingsHome()
        {
            return -204;
        }
        /// <summary>
        /// 公司介绍
        /// </summary>
        public int AboutCompany()
        {
            return -205;
        }
        /// <summary>
        /// 个人档
        /// </summary>
        public int Profile()
        {
            return -206;
        }
    }
}
