﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.Common.Controllers
{
    /// <summary>
    /// 引导安装应用
    /// </summary>
    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, Inherited = true, AllowMultiple = true)]
    public class ChannelGuideInstallApplicationAttribute : FilterAttribute, IAuthorizationFilter
    {
        private int applicationID;
        /// <summary>
        /// 应用ID
        /// </summary>
        public int ApplicationID
        {
            get { return applicationID; }
            set { applicationID = value; }
        }

        #region IAuthorizationFilter 成员

        public void OnAuthorization(AuthorizationContext filterContext)
        {
            if (filterContext == null)
            {
                throw new ArgumentNullException("filterContext");
            }
            else
                GuideInstallApplication(filterContext);
        }

        #endregion

        private void GuideInstallApplication(AuthorizationContext filterContext)
        {
            if (filterContext.IsChildAction)
                return;

            if (filterContext.HttpContext.Request.IsAuthenticated)
            {
                User currentUser = Globals.GetCurrentUser();
                if (currentUser == null)
                    return;

                if (!currentUser.IsContentAdministrator && !Applications.IsEnabled(ApplicationID))
                    filterContext.Result = new RedirectResult(SiteUrls.Instance().Error(ResourceManager.GetString("Title_ApplicationNotEnabled", Globals.GetCurrentUserLanguage())));

                if (currentUser.UserType == UserTypes.PersonUser && Applications.IsInstalled(PresentAreaIDs.Instance().UserDomain(), currentUser.UserID, applicationID))
                    return;
                if (currentUser.UserType == UserTypes.CompanyUser && Applications.IsInstalled(PresentAreaIDs.Instance().CompanyUserDomain(), currentUser.UserID, applicationID))
                    return;

                filterContext.Result = new RedirectResult(SPBUrlHelper.Action("ListApplications", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", currentUser.UserName },{"tipInstall",true} }));
            }
            else
            {
                if (!Applications.IsEnabled(ApplicationID))
                    filterContext.Result = new RedirectResult(SiteUrls.Instance().Error(ResourceManager.GetString("Title_ApplicationNotEnabled", Globals.GetCurrentUserLanguage())));
            }
        }
    }
}
