﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Web;
using SpaceBuilder.Common;
using SpaceBuilder.Club;

namespace SpaceBuilder.Common.Controllers
{
    /// <summary>
    /// 群组中访问记录和访问计数
    /// </summary>
    public class ClubMemberVisitAndClubDomainHitTimeAttribute : ActionFilterAttribute
    {
        public override void OnResultExecuted(ResultExecutedContext filterContext)
        {
            string clubDomainName = filterContext.GetParameterFromRouteDateOrQueryString("clubDomainName");
            if (string.IsNullOrEmpty(clubDomainName))
                return;

            Club.Club currentClubDomain = Clubs.GetClub(clubDomainName, false);
            if (currentClubDomain == null)
                return;

            User currentUser = Globals.GetCurrentUser();
            if (currentUser == null)
                return;

            //群组浏览计数    
          
            CounterFactory.IncreaseCount<ClubCounter>(IncreasableCountTypes.WebView,currentClubDomain.ClubID);

            //针对群组成员进行访问记录
            if (currentUser != null && ClubMembers.IsClubMember(currentClubDomain.ClubID, currentUser.UserID))
            {
                ClubMemberVisit clubMemberVisit = new ClubMemberVisit(currentUser.UserID, currentClubDomain.ClubID);
                ClubMembers.AddClubMemberVisit(clubMemberVisit);
            }
        }

    }
}
