﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using System.Web;


namespace SpaceBuilder.Common.Controllers
{
    /// <summary>
    /// 后台身份验证
    /// </summary>
    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, Inherited = true, AllowMultiple = true)]
    public class ManageAuthorizeAttribute : FilterAttribute, IAuthorizationFilter
    {
        private bool requireSystemAdministrator = false;
        /// <summary>
        /// 是否需要系统管理员权限
        /// </summary>
        public bool RequireSystemAdministrator
        {
            get { return requireSystemAdministrator; }
            set { requireSystemAdministrator = value; }
        }

        private bool checkCookie = true;
        /// <summary>
        /// 是否需要检查Cookie
        /// </summary>
        public bool CheckCookie
        {
            get { return this.checkCookie; }
            set { this.checkCookie = value; }
        }

        #region IAuthorizationFilter 成员

        public void OnAuthorization(AuthorizationContext filterContext)
        {
            if (filterContext == null)
            {
                throw new ArgumentNullException("filterContext");
            }

            if (!AuthorizeCore(filterContext))
            {
                // auth failed, redirect to login page
                //filterContext.Cancel = true;
                filterContext.Result = new RedirectResult(SiteUrls.Instance().ManageLogin());
                return;
            }
        }

        #endregion

        // This method must be thread-safe since it is called by the thread-safe OnCacheAuthorization() method.
        protected virtual bool AuthorizeCore(AuthorizationContext filterContext)
        {
            if (CheckCookie)
            {
                HttpCookie adminCookie = filterContext.HttpContext.Request.Cookies["SpaceBuilderAdminCookie"];
                if (adminCookie != null)
                {
                    bool isLoginMarked = false;
                    try
                    {
                        bool.TryParse(EncryptManager.DecryptTokenForVerifyCode(adminCookie.Value), out isLoginMarked);
                    }
                    catch { }

                    if (!isLoginMarked)
                        return false;
                }
                else
                {
                    return false;
                }
            }
            User currentUser = Globals.GetCurrentUser();
            if (currentUser != null && currentUser != null)
            {
                if ((RequireSystemAdministrator && currentUser.IsAdministrator) || (!RequireSystemAdministrator && currentUser.IsContentAdministrator))
                    return true;
            }

            return false;
        }


    }
}