﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using System.Web;

namespace SpaceBuilder.Common.Controllers
{
    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, Inherited = true, AllowMultiple = true)]
    public class SPBHandleExceptionAttribute : FilterAttribute, IExceptionFilter
    {
        private const string _defaultView = "Pages/ShowExceptionMessage.aspx";

        public virtual void OnException(ExceptionContext filterContext)
        {
            //清除HttpCompress的设置
            //TODO:View中抛出异常，应该去除压缩
            //if (HttpRuntime.UsingIntegratedPipeline)
            //{
            //    HttpResponseBase response = filterContext.HttpContext.Response;
            //    response.Headers.Remove("Content-encoding");
            //    response.Filter = null;
            //}

            if (filterContext == null)
            {
                throw new ArgumentNullException("filterContext");
            }
            if (filterContext.IsChildAction)
            {
                return;
            }

            // If custom errors are disabled, we need to let the normal ASP.NET exception handler
            if (filterContext.ExceptionHandled || !filterContext.HttpContext.IsCustomErrorEnabled)
            {
                return;
            }

            Exception exception = filterContext.Exception;

            // If this is not an HTTP 500 (for example, if somebody throws an HTTP 404 from an action method),
            // ignore it.
            if (new HttpException(null, exception).GetHttpCode() != 500)
            {
                return;
            }

            SPBException spbException = exception as SPBException;


            if (spbException == null && exception.InnerException != null)
                spbException = exception.InnerException as SPBException;

            if (spbException == null && exception.InnerException.InnerException != null)
                spbException = exception.InnerException.InnerException as SPBException;

            if (spbException == null)
            {
                return;
            }
            else
            {
                spbException.Log();
            }

            //string controllerName = (string)filterContext.RouteData.Values["controller"];
            //string actionName = (string)filterContext.RouteData.Values["action"];

            filterContext.Result = new ViewResult
            {
                ViewName = _defaultView,
                ViewData = new ViewDataDictionary<SPBException>(spbException),
                TempData = filterContext.Controller.TempData
            };
            filterContext.ExceptionHandled = true;
            filterContext.HttpContext.Response.Clear();
            filterContext.HttpContext.Response.StatusCode = 500;

            // Certain versions of IIS will sometimes use their own error page when
            // they detect a server error. Setting this property indicates that we
            // want it to try to render ASP.NET MVC's error page instead.
            filterContext.HttpContext.Response.TrySkipIisCustomErrors = true;
        }

    }
}
