﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.Common.Controllers
{
    /// <summary>
    /// 引导安装应用
    /// </summary>
    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, Inherited = true, AllowMultiple = true)]
    public class UserDomainGuideInstallApplicationAttribute : FilterAttribute, IAuthorizationFilter
    {
        private int applicationID;
        /// <summary>
        /// 应用ID
        /// </summary>
        public int ApplicationID
        {
            get { return applicationID; }
            set { applicationID = value; }
        }

        #region IAuthorizationFilter 成员

        public void OnAuthorization(AuthorizationContext filterContext)
        {
            if (filterContext == null)
            {
                throw new ArgumentNullException("filterContext");
            }
            else
                GuideInstallApplication(filterContext);
        }

        #endregion

        private void GuideInstallApplication(AuthorizationContext filterContext)
        {
            if (filterContext.IsChildAction)
                return;

            string userDomainName = filterContext.GetParameterFromRouteDateOrQueryString("userDomainName");
            if (string.IsNullOrEmpty(userDomainName))
                return;

            User currentDomainUser = Users.GetUser(userDomainName, false);
            if (currentDomainUser == null)
                return;

            if (filterContext.HttpContext.Request.IsAuthenticated)
            {
                User currentUser = Globals.GetCurrentUser();
                if (currentUser == null)
                    return;

                if (!currentUser.IsContentAdministrator && !Applications.IsEnabled(ApplicationID))
                    filterContext.Result = new RedirectResult(SiteUrls.Instance().Error(ResourceManager.GetString("Title_ApplicationNotEnabled", Globals.GetCurrentUserLanguage())));


                if (currentDomainUser.UserType == UserTypes.PersonUser && Applications.IsInstalled(PresentAreaIDs.Instance().UserDomain(), currentDomainUser.UserID, applicationID))
                    return;
                if (currentDomainUser.UserType == UserTypes.CompanyUser && Applications.IsInstalled(PresentAreaIDs.Instance().CompanyUserDomain(), currentDomainUser.UserID, applicationID))
                    return;


                if (IsUserDomainOwner(userDomainName))
                    filterContext.Result = new RedirectResult(SPBUrlHelper.Action("ListApplications", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", userDomainName }, { "tipInstall", true } }));
                else
                    filterContext.Result = new RedirectResult(SiteUrls.Instance().Error(ResourceManager.GetString("Title_ApplicationNotInstalled", Globals.GetCurrentUserLanguage())));
            }
            else
            {
                if (!Applications.IsEnabled(ApplicationID))
                    filterContext.Result = new RedirectResult(SiteUrls.Instance().Error(ResourceManager.GetString("Title_ApplicationNotEnabled", Globals.GetCurrentUserLanguage())));
            }
        }

        /// <summary>
        /// 当前用户是否当前空间的所有者
        /// </summary>
        private bool IsUserDomainOwner(string userDomainName)
        {
            User user = Globals.GetCurrentUser();
            if (user == null)
                return false;

            return user.UserName.Equals(userDomainName, StringComparison.CurrentCultureIgnoreCase);
        }
    }
}
