﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.Common.Controllers
{
    /// <summary>
    /// 隐私验证过滤器
    /// </summary>
    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, Inherited = true, AllowMultiple = true)]
    public class UserDomainPrivacyAttribute : FilterAttribute, IAuthorizationFilter
    {

        private bool isAuthentication = true;
        /// <summary>
        /// 是否启用验证
        /// </summary>
        public bool IsAuthentication
        {
            get { return isAuthentication; }
            set { isAuthentication = value; }
        }
        /// <summary>
        /// 要验证项的隐私Key
        /// </summary>
        private string PrivacyItemKey = PrivacyItemKeys.Instance().UserDomainPrivacy();

        #region IAuthorizationFilter 成员

        void IAuthorizationFilter.OnAuthorization(AuthorizationContext filterContext)
        {
            if (filterContext == null)
            {
                throw new ArgumentException("AuthorizationContext为空");
            }
            string userDomainName = filterContext.GetParameterFromRouteDateOrQueryString("userDomainName");
            User DomainUser = Users.GetUser(userDomainName, false);
            if (DomainUser == null)
            {
                filterContext.Result = new RedirectResult(SiteUrls.Instance().Home());
                return;
            }
            if (IsAuthentication)
            {
                if (string.IsNullOrEmpty(PrivacyItemKey))
                {
                    throw new ArgumentException("ItemKey不能为空");
                }
                if (!AuthorizeCore(filterContext, DomainUser))
                {
                    filterContext.Result = new RedirectResult(SPBUrlHelper.Action("PrivacyHome", "UserDomain", new RouteValueDictionary { { "userDomainName", userDomainName } }));
                    return;
                }
            }
        }

        #endregion

        protected bool AuthorizeCore(AuthorizationContext filterContext, User DomainUser)
        {
            if (DomainUser.UserType == UserTypes.CompanyUser)
                return true;

            User currentUser = Globals.GetCurrentUser();

            if (currentUser != null && (currentUser.UserID == DomainUser.UserID || currentUser.IsAdministrator || currentUser.IsContentAdministrator))
                return true;
            return Privacys.Validate(DomainUser.UserID, currentUser, PrivacyItemKey);
        }
    }
}
