﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Controllers
{
    /// <summary>
    /// 隐私验证过滤器
    /// </summary>
    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, Inherited = true, AllowMultiple = true)]
    public class UserTypeAuthorizeAttribute : FilterAttribute, IAuthorizationFilter
    {
        /// <summary>
        /// 当前用户的用户类型
        /// </summary>
        public UserTypes UserType { get; set; }

        #region IAuthorizationFilter 成员

        public void OnAuthorization(AuthorizationContext filterContext)
        {
            if (filterContext == null)
            {
                throw new ArgumentNullException("filterContext");
            }
            User currentUser = Globals.GetCurrentUser();
            if (currentUser == null)
            {
                filterContext.Result = new RedirectResult(SiteUrls.Instance().Login(true));
                return;
            }
            //if (currentUser.UserType != UserType)
            //    throw (new SPBException(ExceptionTypes.Instance().AccessDenied(), "您没有此操作的权限"));
        }

        #endregion


    }
}
