﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Controllers
{
    /// <summary>
    /// 用户空间访客记录及点击计数
    /// </summary>
    public class UserVisitAndUserDomainHitTimeAttribute : ActionFilterAttribute
    {
        public override void OnResultExecuted(ResultExecutedContext filterContext)
        {
            string userDomainName = filterContext.GetParameterFromRouteDateOrQueryString("userDomainName");
            if (string.IsNullOrEmpty(userDomainName))
                return;

            User currentDomainUser = Users.GetUser(userDomainName, false);
            if (currentDomainUser == null )
                return;

            User currentUser = Globals.GetCurrentUser();
            if (currentUser == null)
                return;

            //用户访问自己空间时不进行访客记录及浏览计数
            if (!currentUser.UserName.Equals(userDomainName, StringComparison.InvariantCultureIgnoreCase))
            {
                //用户空间浏览计数                
              
                CounterFactory.IncreaseCount<UserCounter>(IncreasableCountTypes.WebView,currentDomainUser.UserID);

                //只有登录的个人用户才进行统计
                if (currentUser != null && currentUser.UserType == UserTypes.PersonUser)
                {
                    UserVisit visit = new UserVisit(currentUser.UserID, currentUser.DisplayName, currentUser.UserType, currentDomainUser.UserID, currentDomainUser.DisplayName, currentDomainUser.UserType);
                    UserVisits.AddVisit(visit);
                }
            }
        }

    }
}