﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Common;
using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Controllers
{
    /// <summary>
    /// 总站中所有Controller基类
    /// </summary>
    public abstract class ChannelControllerBase : SPBControllerBase
    {
        /// <summary>
        /// 设置页面的Title
        /// </summary>
        protected virtual void SetPageTitle(string pageName)
        {
            SetPageTitle(pageName, string.Empty);
        }

        /// <summary>
        /// 设置Html文件的title
        /// </summary>
        /// <param name="text">title名称</param>
        protected virtual void SetPageTitle(string pageName, string categoryName)
        {
            if (string.IsNullOrEmpty(categoryName))
                Header.AddTitle(string.Format("{1}{0}{2}", Globals.BrowserTitleSeparator, pageName, Globals.SiteName));
            else
                Header.AddTitle(string.Format("{1}{0}{2}{0}{3}", Globals.BrowserTitleSeparator, pageName, categoryName, Globals.SiteName));
        }

        public override PresentAreaThemeManager ThemeManager
        {
            get { return ChannelPresentAreaThemeManager.Instance(); }
        }
    }
}
