﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Club;
using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Controllers
{
    public class ClubDomainControllerBase : SPBControllerBase
    {
        public override PresentAreaThemeManager ThemeManager
        {
            get { return ClubPresentAreaThemeManager.Instance(); }
        }

        /// <summary>
        /// 设置浏览器标题
        /// </summary>
        /// <param name="text">显示标题内容</param>
        /// <param name="clubDomainName">群组DomainName</param>
        protected void SetPageTitle(string text, string clubDomainName)
        {
            Club.Club club = GetCurrentClub(clubDomainName);
            if (club == null)
                return;

            if (string.IsNullOrEmpty(text))
            {
                Header.AddTitle(string.Format("{0}{2}{1}", club.ClubName, Globals.SiteName, Globals.BrowserTitleSeparator));
            }
            else
            {
                Header.AddTitle(string.Format("{0}{3}{1}{3}{2}", text, club.ClubName, Globals.SiteName, Globals.BrowserTitleSeparator));
            }
        }

        /// <summary>
        /// 获取当前群组
        /// </summary>
        /// <param name="clubDomainName">群组的DomainName</param>
        /// <returns>当前群组</returns>
        protected Club.Club GetCurrentClub(string clubDomainName)
        {
            Club.Club club = Clubs.GetClub(clubDomainName, false);
            if (club == null)
            {
                Response.Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_ClubNotExist", ApplicationIDs.Instance().Club()), clubDomainName)));
            }
            return club;
        }

    }
}