﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Common;
using System.Web;

using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Controllers
{
    /// <summary>
    /// 管理中Controller的基类
    /// </summary>
    public abstract class ManageControllerBase : SPBControllerBase
    {
        public override PresentAreaThemeManager ThemeManager
        {
            get { return ManagePresentAreaThemeManager.Instance(); }
        }

        #region 共用方法

        ///// <summary>
        ///// 验证用户是否有后台操作的权限
        ///// </summary>
        //protected virtual bool Authorize()
        //{

        //    HttpCookie adminCookie = Request.Cookies["SpaceBuilderAdminCookie"];
        //    if (adminCookie != null)
        //    {
        //        bool isLogin = false;
        //        try
        //        {
        //            bool.TryParse(EncryptManager.DecryptTokenForVerifyCode(adminCookie.Value), out isLogin);
        //        }
        //        catch { }

        //        if (isLogin)
        //        {
        //            User currentUser = Globals.GetCurrentUser();
        //            if (currentUser != null && currentUser != null)
        //            {
        //                if (currentUser.IsContentAdministrator)
        //                    return true;
        //            }
        //        }
        //    }

        //    Response.Redirect(SiteUrls.Instance().ManageLogin());
        //    return false;
        //}


        /// <summary>
        /// 设置Html文件的title
        /// </summary>
        /// <param name="text">title名称</param>
        protected virtual void SetPageTitle(string text)
        {
            if (string.IsNullOrEmpty(text))
                Header.AddTitle(string.Format("{0}后台管理", Globals.SiteName));
            else
                Header.AddTitle(string.Format("{0}{1}{2}后台管理", text, Globals.BrowserTitleSeparator, Globals.SiteName));
        }

        #endregion
    }
}
