﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.Common.Controllers
{
    /// <summary>
    /// Controller基类
    /// </summary>
    [SPBHandleException]
    public abstract class SPBControllerBase : Controller
    {
        protected SPBControllerBase()
            : base()
        {
            this.ValidateRequest = false;
        }

        /// <summary>
        /// 皮肤类别
        /// </summary>
        public abstract PresentAreaThemeManager ThemeManager { get; }

        /// <summary>
        /// 设置Html文件的title
        /// </summary>
        /// <param name="nodeNames">节点数组</param>
        protected virtual void SetPageTitle(params string[] nodeNames)
        {
            SetPageTitle(false, nodeNames);
        }

        /// <summary>
        /// 设置Html文件的title
        /// </summary>
        /// <param name="isIncludeSiteName">是否在节点数组里面已经包含了站点的名称</param>
        /// <param name="nodeNames">节点数组</param>
        protected virtual void SetPageTitle(bool isIncludeSiteName, params string[] nodeNames)
        {
            string browserTitle = string.Empty;
            if (nodeNames != null)
            {
                for (int i = 0; i < nodeNames.Count(); i++)
                {
                    browserTitle += nodeNames.ElementAt(i) + Globals.BrowserTitleSeparator;
                }

                if (isIncludeSiteName)
                {
                    browserTitle += Globals.SiteName;
                }

                if (browserTitle.EndsWith(Globals.BrowserTitleSeparator))
                {
                    browserTitle = browserTitle.Substring(0, browserTitle.LastIndexOf(Globals.BrowserTitleSeparator));
                }
            }
            else
            {
                browserTitle = Globals.SiteName;
            }

            Header.AddTitle(browserTitle);
        }

        #region  属性

        private User currentUser = null;
        /// <summary>
        /// 当前用户
        /// </summary>
        protected User CurrentUser
        {
            get
            {
                if (currentUser == null)
                    currentUser = Globals.GetCurrentUser();

                return currentUser;
            }
        }
        private string currentUserLanguage = string.Empty;
        /// <summary>
        /// 当前用户的语言设置
        /// 如果是匿名用户，可能存放在Cookiee中
        /// </summary>
        protected string CurrentUserLanguage
        {
            get
            {
                if (string.IsNullOrEmpty(currentUserLanguage))
                    currentUserLanguage = Globals.GetCurrentUserLanguage();
                return currentUserLanguage;
            }
        }
        /// <summary>
        /// 获取资源项对应的名称
        /// </summary>
        /// <param name="resoursesKey">资源项Key</param>
        /// <returns>翻译后的名称</returns>
        public string GetResourceString(string resoursesKey)
        {
            return ResourceManager.GetString(resoursesKey, CurrentUserLanguage);
        }
        /// <summary>
        /// 获取资源项对应的名称
        /// </summary>
        /// <param name="resoursesKey">资源项Key</param>
        /// <param name="applicationID">应用ID</param>
        /// <returns>翻译后的名称</returns>
        public string GetResourceString(string resoursesKey, int applicationID)
        {
            return ResourceManager.GetString(resoursesKey, CurrentUserLanguage, applicationID);
        }

        /// <summary>
        /// 获取当前请求的路由数据和查询字符串数据的合集
        /// </summary>
        public RouteValueDictionary CurrentRouteValueDictionary
        {
            get
            {
                RouteValueDictionary dictionary = new RouteValueDictionary(RouteData.Values);

                foreach (string q in Request.QueryString.Keys)
                {
                    dictionary[q] = Request.QueryString[q];
                }
                return dictionary;
            }
        }

        #endregion

    }
}
