﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Common;
using System.Web.Routing;
using System.Web;
using SpaceBuilder.Web;

using SpaceBuilder.Caching;

namespace SpaceBuilder.Common.Controllers
{
    [HttpCompress()]
    public class ChannelConvertibleGiftController : ChannelControllerBase
    {
        #region 礼品兑换
        private static int userApplicationID = ApplicationIDs.Instance().User();
        /// <summary>
        /// 显示频道礼品首页
        /// </summary>
        /// <returns></returns>
        public ActionResult GiftHome()
        {
            Header.AddTitle(string.Format("{1}{0}{2}", Globals.BrowserTitleSeparator, GetResourceString("Label_GiftExchange", userApplicationID), Globals.SiteName));

            #region PageTitle & BreadCrumb
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Label_GiftExchange", userApplicationID), SPBUrlHelper.Action("GiftHome", "ChannelConvertibleGift"));
            #endregion

            ViewData["applicationID"] = ChannelSpecialAppIDs.Instance().Gift();
            return View("Pages/ConvertibleGifts/Home.aspx", "Masters/ConvertibleGift.master");
        }

        /// <summary>
        /// 显示兑换申请模式框
        /// </summary>
        /// <returns></returns>
        public ActionResult Control_NewGiftApply(int giftID)
        {
            if (CurrentUser == null)
            {
                return Redirect(SiteUrls.Instance().Login(true));
            }
            int myCreditPoints = (int)CurrentUser.TradePoints;

            //PagingDataSet<ConvertibleGiftExchangeApply> applys = ConvertibleGiftExchangeApplies.GetMyApplies(CurrentUser.UserID, 1);


            //foreach (ConvertibleGiftExchangeApply apply in applys.Records)
            //{
            //    if (apply.ApplyStatus == ConvertibleGiftExchangeApplyStatuses.Unsettled && apply.GiftID == giftID)
            //    {
            //        ViewData["StatusMessageContent"] = "您申请的该礼品正在审核中···";
            //        return PartialView("Controls/ConvertibleGifts/EditGiftApply.ascx");
            //    }
            //}



            ConvertibleGift gift = ConvertibleGifts.GetGift(giftID, false);
            if (gift == null)
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Message_NotExistGiftID", userApplicationID), giftID)));

            if (!gift.IsEnabled)
            {
                ViewData["StatusMessageContent"] = "该礼品已下架！";
            }

            if (myCreditPoints < gift.Price)
            {
                ViewData["StatusMessageContent"] = GetResourceString("Message_YourPointsDeficiency", userApplicationID);
            }
            ViewData["gift"] = gift;
            ConvertibleGiftExchangeApply giftApply = new ConvertibleGiftExchangeApply();
            giftApply = null;
            return PartialView("Controls/ConvertibleGifts/EditGiftApply.ascx", giftApply);
        }

        /// <summary>
        /// 执行添加申请操作
        /// </summary>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult CreateGiftApply(int giftID)
        {
            if (CurrentUser == null)
            {
                return Redirect(SiteUrls.Instance().Login(true));
            }
            int myCreditPoints = (int)CurrentUser.TradePoints;

            ConvertibleGift gift = ConvertibleGifts.GetGift(giftID, false);
            if (gift == null)
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Message_NotExistGiftID", userApplicationID), giftID)));

            ConvertibleGiftExchangeApply giftApply = new ConvertibleGiftExchangeApply();

            giftApply.GiftID = giftID;
            giftApply.TotalCount = Request.Form.GetInt("TotalCount", 0);
            giftApply.Price = gift.Price * giftApply.TotalCount;
            giftApply.ConsigneePhone = Request.Form.GetString("ConsigneePhone", string.Empty);
            giftApply.UserID = CurrentUser.UserID;
            giftApply.UserDisplayName = CurrentUser.DisplayName;
            giftApply.Consignee = Formatter.FormatSingleLinePlainTextForStorage(Request.Form.GetString("consignee", string.Empty));
            giftApply.ConsigneeAddress = Formatter.FormatSingleLinePlainTextForStorage(Request.Form.GetString("consigneeAddress", string.Empty));


            if (myCreditPoints < giftApply.Price)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_YourPointsDeficiency", userApplicationID);
            }
            else if (gift.TotalCount < giftApply.TotalCount)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_GiftShortage", userApplicationID);
            }
            else
            {
                ConvertibleGiftExchangeApplies.CreateApply(giftApply);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                TempData["StatusMessageContent"] = GetResourceString("Message_AddSuccess", userApplicationID);
            }

            return RedirectToAction("Control_NewGiftApply", "ChannelConvertibleGift", new RouteValueDictionary { { "giftID", giftID } });
        }

        /// <summary>
        /// 显示编辑礼品申请模式框
        /// </summary>
        /// <returns></returns>
        public ActionResult Control_EditGiftApply(int applyID)
        {
            ConvertibleGiftExchangeApply giftApply = ConvertibleGiftExchangeApplies.GetApply(applyID);

            if (giftApply == null)
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Message_NotExistApplyID", userApplicationID), applyID)));

            ConvertibleGift gift = ConvertibleGifts.GetGift(giftApply.GiftID, false);
            if (gift == null)
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Message_NotExistGiftID", userApplicationID), giftApply.GiftID)));


            ViewData["gift"] = gift;

            return PartialView("Controls/ConvertibleGifts/EditGiftApply.ascx", giftApply);
        }

        /// <summary>
        /// 执行修改礼品申请操作
        /// </summary>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult UpdateGiftApply(int applyID)
        {
            int myCreditPoints = (int)CurrentUser.TradePoints;

            ConvertibleGiftExchangeApply giftApply = ConvertibleGiftExchangeApplies.GetApply(applyID);

            if (giftApply == null)
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Message_NotExistApplyID", userApplicationID), applyID)));

            ConvertibleGift gift = ConvertibleGifts.GetGift(giftApply.GiftID, false);

            giftApply.TotalCount = Request.Form.GetInt("TotalCount", 0);
            giftApply.Price = gift.Price * giftApply.TotalCount;
            giftApply.ConsigneePhone = Request.Form.GetString("ConsigneePhone", string.Empty);
            giftApply.Consignee = Formatter.FormatSingleLinePlainTextForStorage(Request.Form.GetString("consignee", string.Empty));
            giftApply.ConsigneeAddress = Formatter.FormatSingleLinePlainTextForStorage(Request.Form.GetString("consigneeAddress", string.Empty));

            if (myCreditPoints < giftApply.Price)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_YourPointsDeficiency", userApplicationID);
                return RedirectToAction("Control_NewGiftApply", "ChannelConvertibleGift", new RouteValueDictionary { { "giftID", giftApply.GiftID } });
            }

            if (gift.TotalCount < giftApply.TotalCount)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = GetResourceString("Message_GiftShortage", userApplicationID);
                return RedirectToAction("Control_NewGiftApply", "ChannelConvertibleGift", new RouteValueDictionary { { "giftID", giftApply.GiftID } });
            }

            ConvertibleGiftExchangeApplies.UpdateApply(giftApply);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = GetResourceString("Message_UpdateSuccess", userApplicationID);

            return RedirectToAction("Control_NewGiftApply", "ChannelConvertibleGift", new RouteValueDictionary { { "giftID", giftApply.GiftID } });
        }

        /// <summary>
        /// 显示一定价格在一定区域的礼品
        /// </summary>
        /// <param name="minPrice"></param>
        /// <param name="maxPrice"></param>
        /// <param name="pageIndex"></param>
        /// <returns></returns>
        public ActionResult ListGifts(ConvertibleGiftSortBy? sortBy, int? minPrice, int? maxPrice, int? pageIndex)
        {
            sortBy = sortBy ?? ConvertibleGiftSortBy.DateCreated;
            switch (sortBy.Value)
            {
                case ConvertibleGiftSortBy.DateCreated:
                    SetPageTitle(GetResourceString("Label_TheLatestShelves", userApplicationID));
                    break;
                case ConvertibleGiftSortBy.ExchangedCount:
                    SetPageTitle(GetResourceString("Label_PurchaseAtMost", userApplicationID));
                    break;
                case ConvertibleGiftSortBy.Price:
                    SetPageTitle(GetResourceString("Label_TheLowestPrice", userApplicationID));
                    break;
                default:
                    break;
            }

            PagingDataSet<ConvertibleGift> pds = ConvertibleGifts.GetPagingGiftsSortBy(sortBy.Value, minPrice, maxPrice, 5, pageIndex ?? 1);

            #region PageTitle & BreadCrumb
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Label_GiftExchange", userApplicationID), SPBUrlHelper.Action("GiftHome", "ChannelConvertibleGift"));
            #endregion

            ViewData["applicationID"] = ChannelSpecialAppIDs.Instance().Gift();

            ViewData["minPrice"] = minPrice;
            ViewData["maxPrice"] = maxPrice;
            ViewData["sortBy"] = sortBy;
            return View("Pages/ConvertibleGifts/ListGifts.aspx", "Masters/ConvertibleGift.master", pds);
        }



        /// <summary>
        /// 显示礼品列表，用于频道首页
        /// </summary>
        /// <param name="sortBy"></param>
        /// <returns></returns>
        public ActionResult ListGiftsSortBy(ConvertibleGiftSortBy? sortBy)
        {
            IList<ConvertibleGift> gifts = ConvertibleGifts.GetTopGiftsSortBy(sortBy ?? ConvertibleGiftSortBy.DateCreated, 6);
            ViewData["gifts"] = gifts;
            ViewData["sortBy"] = (int)sortBy;
            return PartialView("Controls/ConvertibleGifts/ListGiftsSortBy.ascx");
        }

        /// <summary>
        /// 显示礼品
        /// </summary>
        /// <param name="giftID"></param>
        /// <param name="pageIndex"></param>
        /// <returns></returns>
        public ActionResult ShowGift(int giftID, int? pageIndex)
        {
            ConvertibleGift gift = ConvertibleGifts.GetGift(giftID, false);

            if (gift == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Message_NotExistGiftID", userApplicationID), giftID)));
            }
            SetPageTitle(string.Format(GetResourceString("Title_Gift", userApplicationID), gift.Subject));

            #region PageTitle & BreadCrumb
            BreadCrumb.AddBreadCrumbItem(GetResourceString("Label_GiftExchange", userApplicationID), SPBUrlHelper.Action("GiftHome", "ChannelConvertibleGift"));
            BreadCrumb.AddBreadCrumbItem(gift.Subject, SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift"));
            #endregion

            PagingDataSet<ConvertibleGiftExchangeRecord> pds = ConvertibleGiftExchangeRecords.GetRecords(giftID, null, pageIndex.HasValue ? pageIndex.Value : 1);

            ViewData["gift"] = gift;
            ViewData["applicationID"] = ChannelSpecialAppIDs.Instance().Gift();

            return View("Pages/ConvertibleGifts/ShowGift.aspx", "Masters/ConvertibleGift.master", pds);
        }

        /// <summary>
        /// 显示前N条最新交易记录
        /// </summary>
        /// <returns></returns>
        public ActionResult Control_ListTopExchangeRecords()
        {
            IList<ConvertibleGiftExchangeRecord> giftExchangeRocord = ConvertibleGiftExchangeRecords.GetLatestRecords(8);
            ViewData["giftExchangeRocord"] = giftExchangeRocord;
            return PartialView("Controls/ConvertibleGifts/ListTopExchangeRecords.ascx");
        }

        #region 推荐礼品
        [ActionOutputCache(ActionOutputCacheAttribute.CachingExpirationType.UsualObjectCollection)]
        public ActionResult Control_RecommendContibleGiftBlock(int? commendTypeID, int? displayCount)
        {
            IList<RecommendedItem> recommendItems = RecommendedItems.GetTopRecommendedItems(9999, commendTypeID, displayCount ?? 3);
            //IList<ConvertibleGift> recommendConvertibleGifts = new List<ConvertibleGift>();
            //foreach (RecommendedItem item in recommendItems)
            //{
            //    if (item != null)
            //    {
            //        ConvertibleGift gift = ConvertibleGifts.GetGift(item.ItemID, false);
            //        if (gift != null)
            //            recommendConvertibleGifts.Add(gift);
            //    }
            //}

            return PartialView("Controls/ConvertibleGifts/RecommendContibleGiftBlock.ascx", recommendItems);
        }

        #endregion


        #endregion

    }
}
