﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.LuceneSearch;
using System.IO;
using SpaceBuilder.Utils;
using SpaceBuilder.Club;
using SpaceBuilder.Web;
using TunyNet.License;
using System.ComponentModel;
using SpaceBuilder.Caching;
using System.Web;
using System.Web.Routing;
using System.Net.Mail;
using System.Xml.Linq;
using System.Xml;
using System.Net;

namespace SpaceBuilder.Common.Controllers
{
    /// <summary>
    /// 后台 设置
    /// </summary>
    [ManageAuthorize(RequireSystemAdministrator = true)]
    [HttpCompress]
    public class ManageSettingsController : ManageControllerBase
    {
        #region 动态设置
        /// <summary>
        /// 显示动态设置
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ActivitySettings()
        {
            SetPageTitle("动态设置");
            Dictionary<string, ActivityItemSettings> settings = Activities.GetGlobalActivityItemSettings(true);
            Dictionary<string, ActivityItem> dci = Activities.GetActivityItems();
            ViewData["ActivityItems"] = dci;
            return View("Pages/Settings/ActivitySettings.aspx", "Masters/Settings.master", settings);
        }
        /// <summary>
        /// 更新动态全局设置
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult UpdateActivitySettings()
        {
            Dictionary<string, ActivityItemSettings> activityItemSettingss = Activities.GetGlobalActivityItemSettings(false);
            Dictionary<string, ActivityItem> dci = Activities.GetActivityItems();

            string strName = string.Empty;
            string strName2 = string.Empty;
            foreach (KeyValuePair<string, ActivityItem> item in dci)
            {
                strName = "Send_" + item.Value.ItemKey;
                strName2 = "Rece_" + item.Value.ItemKey;
                activityItemSettingss[item.Value.ItemKey].IsAllowSending = Request.Form.GetBool(strName, false);
                activityItemSettingss[item.Value.ItemKey].IsAllowReceiving = Request.Form.GetBool(strName2, false);
            }

            Activities.UpdateGlobalActivityItemSettingss(activityItemSettingss);
            TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "更新成功");

            return RedirectToAction("ActivitySettings");
        }
        #endregion

        #region 隐私设置

        /// <summary>
        /// 显示隐私设置
        /// </summary>
        /// <returns></returns>
        public ActionResult PrivacySettings()
        {
            SetPageTitle("隐私设置");
            Dictionary<string, PrivacyItemSettings> settings = Privacys.GetGlobalPrivacySettingss(true);
            List<PrivacyItem> lpi = Privacys.GetPrivacyItems(true);
            ViewData["PrivacyItems"] = lpi;
            return View("Pages/Settings/PrivacySettings.aspx", "Masters/Settings.master", settings);
        }
        /// <summary>
        /// 更新隐私设置
        /// </summary>
        /// <returns></returns>
        public ActionResult UpdatePrivacySettings()
        {
            Dictionary<string, PrivacyItemSettings> dictionary = Privacys.GetGlobalPrivacySettingss(true);
            List<PrivacyItemSettings> list = new List<PrivacyItemSettings>();
            List<PrivacyItem> lpi = Privacys.GetPrivacyItems(true);
            foreach (var item in lpi)
            {
                if (item.ItemKey == PrivacyItemKeys.Instance().Action_ReceiveFriendInvitation())
                    dictionary[item.ItemKey].PrivacyDegree = Request.Form.GetBool("SPB_" + item.ItemKey, true) ? PrivacyDegree.Public : PrivacyDegree.Private;
                else
                    dictionary[item.ItemKey].PrivacyDegree = (PrivacyDegree)Request.Form.GetInt("SPB_" + item.ItemKey, 1);
                list.Add(dictionary[item.ItemKey]);
            }

            Privacys.UpdateGlobalPrivacySettingss(list);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "隐私设置已经成功更新";
            return RedirectToAction("PrivacySettings", "ManageSettings");
        }

        #endregion

        #region 通知设置

        /// <summary>
        /// 显示通知设置
        /// </summary>
        /// <returns></returns>
        public ActionResult NoticeSettings(UserTypes? userType)
        {
            SetPageTitle("通知设置");
            Dictionary<string, NoticeItem> dicNoticeItems = NoticeSettingsManager.GetNoticeItems(userType.HasValue ? userType.Value : UserTypes.PersonUser);
            Dictionary<string, Dictionary<int, NoticeItem>> dicCodeSettings = new Dictionary<string, Dictionary<int, NoticeItem>>();
            foreach (var itemKey in NoticeProcessorFactory.Instance().NoticeProcessorsNames.Keys)
            {
                Dictionary<int, NoticeItem> noticeItemSettings = NoticeSettingsManager.GetGlobalNoticeSettings(itemKey, userType.HasValue ? userType.Value : UserTypes.PersonUser, true);
                dicCodeSettings.Add(itemKey, noticeItemSettings);
            }
            ViewData["NoticeItem"] = dicNoticeItems;
            return View("Pages/Settings/NoticeSettings.aspx", "Masters/Settings.master", dicCodeSettings);
        }
        /// <summary>
        /// 更新通知设置
        /// </summary>
        /// <returns></returns>
        public ActionResult UpdateNoticeSettings(UserTypes userType)
        {
            Dictionary<string, NoticeItem> noticeItems = NoticeSettingsManager.GetNoticeItems(userType);
            Dictionary<int, NoticeItem> updateNoticeItems = new Dictionary<int, NoticeItem>();
            string strName = string.Empty;
            int itemID = -1;
            foreach (var itemCode in NoticeProcessorFactory.Instance().NoticeProcessorsNames.Keys)
            {
                foreach (KeyValuePair<string, NoticeItem> item in noticeItems)
                {
                    strName = itemCode + "_" + item.Value.ItemKey;
                    itemID = Request.Form.GetInt(strName, -1);
                    if (itemID > 0)
                        updateNoticeItems.Add(itemID, item.Value);
                }
                if (updateNoticeItems.Keys.Count > 0)
                {
                    NoticeSettingsManager.UpdateGlobalNoticeSettings(itemCode, userType, updateNoticeItems);
                }
                updateNoticeItems.Clear();
            }

            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "通知设置已经成功更新";
            return RedirectToAction("NoticeSettings", "ManageSettings", new RouteValueDictionary { { "userType", userType } });
        }

        #endregion

        #region 积分设置
        /// <summary>
        /// 显示积分设置
        /// </summary>
        /// <returns></returns>
        public ActionResult PointSettings(int? AppID)
        {
            SetPageTitle("积分管理");
            List<UserPointItem> ItemPoints = Points.GetUserPointItems(AppID ?? ApplicationIDs.Instance().User());
            Dictionary<string, UserPointItemRole> RolePoints = Points.GetUserPointItemRolesForAdmin();
            Dictionary<int, Application> dic = Applications.GetApplicationsForAdmin();
            Dictionary<int, Application> dic2 = new Dictionary<int, Application>(dic);
            foreach (var item in dic.Keys)
            {
                List<UserPointItem> l = Points.GetUserPointItems(item);
                if (l == null || l.Count <= 0)
                {
                    dic2.Remove(item);
                }
            }
            ViewData["DicApplication"] = dic2;
            ViewData["DPoints"] = RolePoints;
            ViewData["ItemPoints"] = ItemPoints;
            return View("Pages/Settings/ManagePointSettings.aspx", "Masters/Settings.master");
        }
        /// <summary>
        /// 编辑积分设置
        /// </summary>
        /// <param name="ItemKey"></param>
        /// <returns></returns>
        public ActionResult Control_EditPoints(string ItemKey)
        {
            UserPointItemRole ur = Points.GetUserPointItemRoleForAdmin(ItemKey);
            ViewData["PointRole"] = ur;
            return PartialView("Controls/Settings/EditPoint.ascx");
        }
        /// <summary>
        /// 更新积分设置
        /// </summary>
        /// <param name="ItemKey"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Control_UpdatePoints(string ItemKey)
        {
            UserPointItemRole ur = Points.GetUserPointItemRoleForAdmin(ItemKey);
            ur.BasicPoints = Request.Form.GetInt("BasicPoints", ur.BasicPoints);
            ur.CreditPoints = Request.Form.GetInt("CreditPoints", ur.CreditPoints);
            ur.ReportPoints = Request.Form.GetInt("ReportPoints", ur.ReportPoints);
            ur.TradePoints = Request.Form.GetInt("TradePoints", ur.TradePoints);

            ur.BasicPointQuota = Request.Form.GetInt("BasicPointQuota", ur.BasicPointQuota);
            ur.ReportPointQuota = Request.Form.GetInt("ReportPointQuota", ur.ReportPointQuota);
            ur.CreditPointQuota = Request.Form.GetInt("CreditPointQuota", ur.CreditPointQuota);
            ur.TradePointQuota = Request.Form.GetInt("TradePointQuota", ur.TradePointQuota);

            Points.UpdateUserPointItemRole(ur);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "积分设置已经成功更新";
            return RedirectToAction("Control_EditPoints", "ManageSettings", new RouteValueDictionary { { "ItemKey", ItemKey } });
        }

        /// <summary>
        /// 系统积分
        /// </summary>
        /// <returns></returns>
        public ActionResult SystemPointSettings(int? pageIndex)
        {

            SetPageTitle("积分管理");

            PagingDataSet<UserPointRecord> pds = Points.GetUserPointRecords((int)PointEspecialUserID.System, null, null, 50, pageIndex ?? 1);
            ViewData["SystemPoint"] = Points.GetSystemTradePoints();

            return View("Pages/Settings/ManageSystemPointSettings.aspx", "Masters/Settings.master", pds);
        }


        #endregion

        #region 审核设置

        /// <summary>
        /// 显示审核设置
        /// </summary>
        /// <param name="type">1时表示按级别显示，其余的为按角色显示</param>
        /// <returns></returns>
        public ActionResult AuditingSettings(int? type, int? appID)
        {
            SetPageTitle("审核管理");

            int applicationID = 0;
            if (appID.HasValue)
                applicationID = appID.Value;

            if (type.HasValue && type == 1)
            {
                List<AuditingItem> ListItem = Auditings.GetAuditingItemsCanAssociateWithUserRank(applicationID);
                ViewData["ListItem"] = ListItem;
                SortedList<int, UserRank> sortlistUserRank = UserRanks.GetAllUserRanks(true);
                ViewData["sortlistUserRank"] = sortlistUserRank;
                Dictionary<int, Dictionary<string, AuditingItemSettings>> DRank = new Dictionary<int, Dictionary<string, AuditingItemSettings>>();
                foreach (var item in sortlistUserRank.Values)
                {
                    DRank.Add(item.Rank, Auditings.GetAuditingItemSettingssInUserRankForAdmin(item.Rank));
                }
                ViewData["DRank"] = DRank;
            }
            else
            {
                List<AuditingItem> ListItem = Auditings.GetAuditingItemsCanAssociateWithUserRole(applicationID);
                ViewData["ListItem"] = ListItem;
                ICollection<Role> ListRoles = Roles.GetRolesByApplicationID(applicationID, true, true);
                ViewData["ListRoles"] = ListRoles;
                Dictionary<int, Dictionary<string, AuditingItemSettings>> DRole = new Dictionary<int, Dictionary<string, AuditingItemSettings>>();
                foreach (var item in ListRoles)
                {
                    DRole.Add(item.RoleID, Auditings.GetAuditingItemSettingssInUserRoleForAdmin(item.RoleID));
                }
                ViewData["DRole"] = DRole;
            }

            Dictionary<int, Application> dic = Applications.GetApplicationsForAdmin();
            Dictionary<int, Application> dic2 = new Dictionary<int, Application>(dic);
            foreach (var item in dic.Keys)
            {
                List<AuditingItem> l = Auditings.GetAuditingItemsCanAssociateWithUserRole(item);
                if (l == null || l.Count <= 0)
                {
                    dic2.Remove(item);
                }
            }
            ViewData["DicApplication"] = dic2;
            if (appID.HasValue && appID.Value > 0)
                ViewData["Application"] = Applications.GetApplicationForAdmin(appID.Value);
            return View("Pages/Settings/ManageAuditingSettings.aspx", "Masters/Settings.master");
        }
        /// <summary>
        /// 显示单个级别设置
        /// </summary>
        /// <param name="Rank"></param>
        /// <returns></returns>
        public ActionResult Control_SetRankAuditingSettings(int Rank, int appID)
        {
            Dictionary<string, AuditingItemSettings> DAudItem = Auditings.GetAuditingItemSettingssInUserRankForAdmin(Rank);
            ViewData["DAudItem"] = DAudItem;
            List<AuditingItem> ListItem = Auditings.GetAuditingItemsCanAssociateWithUserRank(appID);
            ViewData["ListItem"] = ListItem;
            return PartialView("Controls/Settings/SetRankAuditingSettings.ascx");
        }
        /// <summary>
        /// 更新单个级别设置
        /// </summary>
        /// <param name="Rank"></param>
        /// <returns></returns>
        public ActionResult Control_UpdateRankAuditingSettings(int Rank, int appID)
        {
            Dictionary<string, AuditingItemSettings> DAudItem = new Dictionary<string, AuditingItemSettings>();
            List<AuditingItem> ListItem = Auditings.GetAuditingItemsCanAssociateWithUserRank(appID);

            foreach (var item in ListItem)
            {
                AuditingItemSettings AudItemSeting = new AuditingItemSettings();
                AudItemSeting.ItemID = item.ItemID;
                AudItemSeting.StrictDegree = (AuditingStrictDegrees)Request.Form.GetInt("Setting_" + item.ItemKey, (int)AuditingStrictDegrees.NotSet);
                DAudItem.Add(item.ItemKey, AudItemSeting);
            }
            Auditings.UpdateAuditingItemSetingssInUserRank(Rank, DAudItem);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "审核设置已经成功更新";
            return RedirectToAction("Control_SetRankAuditingSettings", "ManageSettings", new RouteValueDictionary { { "Rank", Rank }, { "appID", appID } });
        }
        /// <summary>
        /// 显示单个角色设置
        /// </summary>
        /// <param name="Rank"></param>
        /// <returns></returns>
        public ActionResult Control_SetRoleAuditingSettings(int RoleID, int appID)
        {
            Dictionary<string, AuditingItemSettings> DAudItem = Auditings.GetAuditingItemSettingssInUserRoleForAdmin(RoleID);
            ViewData["DAudItem"] = DAudItem;
            List<AuditingItem> ListItem = Auditings.GetAuditingItemsCanAssociateWithUserRole(appID);
            ViewData["ListItem"] = ListItem;
            return PartialView("Controls/Settings/SetRoleAuditingSettings.ascx");
        }
        /// <summary>
        /// 更新单个角色设置
        /// </summary>
        public ActionResult Control_UpdateRoleAuditingSettings(int RoleID, int appID)
        {
            Dictionary<string, AuditingItemSettings> DAudItem = new Dictionary<string, AuditingItemSettings>();
            List<AuditingItem> ListItem = Auditings.GetAuditingItemsCanAssociateWithUserRole(appID);

            foreach (var item in ListItem)
            {
                int StrictDegree = Request.Form.GetInt("Setting_" + item.ItemKey, -1);
                if (StrictDegree < 0)
                    continue;
                AuditingItemSettings AudItemSeting = new AuditingItemSettings();
                AudItemSeting.ItemID = item.ItemID;
                AudItemSeting.StrictDegree = (AuditingStrictDegrees)StrictDegree;
                DAudItem.Add(item.ItemKey, AudItemSeting);
            }
            Auditings.UpdateAuditingItemSetingssInUserRole(RoleID, DAudItem);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "审核设置已经成功更新";
            return RedirectToAction("Control_SetRoleAuditingSettings", "ManageSettings", new RouteValueDictionary { { "RoleID", RoleID }, { "appID", appID } });
        }


        /// <summary>
        /// 显示多个级别设置
        /// </summary>
        public ActionResult Control_SetRanksAuditingSettings(int appID)
        {
            List<AuditingItem> ListItem = Auditings.GetAuditingItemsCanAssociateWithUserRank(appID);
            ViewData["ListItem"] = ListItem;
            string strRanks = Request.Form["CheckBoxGroup"];
            if (string.IsNullOrEmpty(strRanks))
            {
                ViewData["StatusMessageType"] = (int)StatusMessageType.Error;
                ViewData["StatusMessageContent"] = "请选择要操作的级别";
            }
            TempData["strRanks"] = strRanks;
            TempData["appID"] = appID;
            return PartialView("Controls/Settings/SetRanksAuditingSettings.ascx");
        }

        /// <summary>
        /// 更新多个级别设置
        /// </summary>
        public ActionResult UpdateRanksAuditingSettings(int StrictDegree)
        {
            string strRanks = Request.Form.GetString("strRanks", string.Empty);
            int appID = (int)TempData["appID"];
            int ItemID = Request.Form.GetInt("ItemID", -1);
            Dictionary<string, AuditingItemSettings> DAudItem = new Dictionary<string, AuditingItemSettings>();
            List<int> intRanks = ValueHelper.ParseInt(strRanks.Split(','));
            List<AuditingItem> ListItem = Auditings.GetAuditingItemsCanAssociateWithUserRank(appID);
            ListItem = (from k in ListItem where k.ItemID == ItemID select new AuditingItem { ItemKey = k.ItemKey }).ToList<AuditingItem>();
            foreach (var rk in intRanks)
            {
                DAudItem.Clear();
                AuditingItemSettings AudItemSeting = new AuditingItemSettings();
                AudItemSeting.ItemID = ItemID;
                AudItemSeting.StrictDegree = (AuditingStrictDegrees)StrictDegree;
                DAudItem.Add(ListItem[0].ItemKey, AudItemSeting);
                Auditings.UpdateAuditingItemSetingssInUserRank(rk, DAudItem);
            }
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            return RedirectToAction("Control_SetRanksAuditingSettings", new RouteValueDictionary { { "appID", appID } });
        }

        /// <summary>
        /// 更新应用的审核设置
        /// </summary>
        public ActionResult UpdateAuditingStatusForPublicDisplay(int applicationID)
        {
            Application application = Applications.GetApplicationForAdmin(applicationID);
            if (application == null)
                throw new ArgumentException(string.Format("找不到ApplicationID为{0}的应用", applicationID));
            application.AuditingStatusForPublicDisplay = (AuditingStatusesForDisplay)Request.Form.GetInt("AuditingStatusForPublicDisplay", (int)application.AuditingStatusForPublicDisplay);
            Applications.UpdateApplication(application);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;

            return RedirectToAction("AuditingSettings", new RouteValueDictionary { { "appID", applicationID } });
        }
        #endregion

        #region 权限设置
        /// <summary>
        /// 显示所有权限设置
        /// </summary>
        /// <param name="appID"></param>
        /// <returns></returns>
        public ActionResult PermissionSettings()
        {
            SetPageTitle("权限管理");
            return View("Pages/Settings/ManagePermissionSettings.aspx", "Masters/Settings.master");
        }

        /// <summary>
        /// 显示所有权限设置
        /// </summary>
        public ActionResult Control_PermissionSettings(int appID, int type)
        {
            int typeInt = type;
            int applicationID = appID;

            if (typeInt == 0)
            {
                List<PermissionItem> ListPItem = Permissions.GetPermissionItemsCanAssociateWithUserRole(applicationID);
                ViewData["ListPItem"] = ListPItem;
                ICollection<Role> ListRole = Roles.GetRolesByApplicationID(applicationID, true, true);
                Dictionary<int, PermissionCollection> DicPerCollection = new Dictionary<int, PermissionCollection>();
                foreach (var item in ListRole)
                {
                    PermissionCollection PerCollection = Permissions.GetPermissionItemRolesInUserRoleForAdmin(item.RoleID, applicationID);
                    DicPerCollection.Add(item.RoleID, PerCollection);
                }
                ViewData["ListRole"] = ListRole;
                ViewData["DicPerCollection"] = DicPerCollection;
            }
            else
            {
                List<PermissionItem> ListPItem = Permissions.GetPermissionItemsCanAssociateWithUserRank(applicationID);
                ViewData["ListPItem"] = ListPItem;
                List<UserRank> ListRank = UserRanks.GetAllUserRanks(true).Values.ToList();
                Dictionary<int, PermissionCollection> DicPerCollection = new Dictionary<int, PermissionCollection>();
                foreach (var item in ListRank)
                {
                    PermissionCollection PerCollection = Permissions.GetPermissionItemRolesInUserRank(item.Rank, applicationID);
                    DicPerCollection.Add(item.Rank, PerCollection);
                }
                ViewData["ListRank"] = ListRank;
                ViewData["DicPerCollection"] = DicPerCollection;
            }

            Dictionary<int, Application> dic = Applications.GetApplicationsForAdmin();
            Dictionary<int, Application> dic2 = new Dictionary<int, Application>(dic);
            foreach (var item in dic.Keys)
            {
                List<PermissionItem> l = Permissions.GetPermissionItemsCanAssociateWithUserRole(item);
                if (l == null || l.Count <= 0)
                {
                    dic2.Remove(item);
                }
            }
            ViewData["DicApplication"] = dic2;
            ViewData["appID"] = appID;
            ViewData["type"] = type;
            return PartialView("Controls/Settings/PermissionSettings.ascx");
        }

        /// <summary>
        /// 显示详细角色权限设置
        /// </summary>
        public ActionResult Control_SetRolePermissionSettings(int roleID, int appID)
        {
            PermissionCollection PerConllection = Permissions.GetPermissionItemRolesInUserRoleForAdmin(roleID, appID);
            ViewData["PerConllection"] = PerConllection;
            List<PermissionItem> ListPItem = Permissions.GetPermissionItemsCanAssociateWithUserRole(appID);
            ViewData["ListPItem"] = ListPItem;
            return PartialView("Controls/Settings/SetPermissionSettings.ascx");
        }

        /// <summary>
        /// 更新角色设置
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Control_UpdateRolePermissionSettings(int roleID, int appID)
        {
            PermissionCollection PerConllection = Permissions.GetPermissionItemRolesInUserRole(roleID, appID, true);
            List<PermissionItem> ListPItem = Permissions.GetPermissionItemsCanAssociateWithUserRole(appID);

            List<PermissionItemRole> ListPerRole = new List<PermissionItemRole>();
            foreach (var item in ListPItem)
            {
                try
                {
                    if (!PerConllection[item.ItemKey].IsLocked)
                    {
                        PerConllection[item.ItemKey].AllowType = (AllowTypes)Request.Form.GetInt("Role_" + item.ItemKey, (int)AllowTypes.NotSet);
                        ListPerRole.Add(PerConllection[item.ItemKey]);
                    }
                }
                catch { }
            }
            Permissions.UpdatePermissionItemRolesInRole(roleID, ListPerRole);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "权限设置已经成功更新";
            return RedirectToAction("Control_SetRolePermissionSettings", "ManageSettings", new RouteValueDictionary { { "roleID", roleID }, { "appID", appID } });
        }

        /// <summary>
        /// 显示详细等级权限设置
        /// </summary>
        /// <param name="roleID"></param>
        /// <param name="appID"></param>
        /// <returns></returns>
        public ActionResult Control_SetRankPermissionSettings(int Rank, int appID)
        {
            PermissionCollection PerConllection = Permissions.GetPermissionItemRolesInUserRank(Rank, appID);
            ViewData["PerConllection"] = PerConllection;
            List<PermissionItem> ListPItem = Permissions.GetPermissionItemsCanAssociateWithUserRank(appID);
            ViewData["ListPItem"] = ListPItem;
            return PartialView("Controls/Settings/SetRankPermissionSettings.ascx");
        }

        /// <summary>
        /// 更新等级设置
        /// </summary>
        /// <param name="roleID"></param>
        /// <param name="appID"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Control_UpdateRankPermissionSettings(int Rank, int appID)
        {
            PermissionCollection PerConllection = Permissions.GetPermissionItemRolesInUserRank(Rank, appID);
            List<PermissionItem> ListPItem = Permissions.GetPermissionItemsCanAssociateWithUserRank(appID);

            List<PermissionItemRole> ListPerRole = new List<PermissionItemRole>();
            foreach (var item in ListPItem)
            {
                try
                {
                    PerConllection[item.ItemKey].AllowType = (AllowTypes)Request.Form.GetInt("Rank_" + item.ItemKey, (int)AllowTypes.NotSet);
                    ListPerRole.Add(PerConllection[item.ItemKey]);
                }
                catch
                {
                    PermissionItemRole perRole = new PermissionItemRole();
                    perRole.AllowType = (AllowTypes)Request.Form.GetInt("Rank_" + item.ItemKey, (int)AllowTypes.NotSet);
                    perRole.ItemID = item.ItemID;
                    ListPerRole.Add(perRole);
                }
            }
            Permissions.UpdatePermissionItemRolesInUserRank(Rank, ListPerRole);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "权限设置已经成功更新";
            return RedirectToAction("Control_SetRankPermissionSettings", "ManageSettings", new RouteValueDictionary { { "Rank", Rank }, { "appID", appID } });
        }

        /// <summary>
        /// 显示多个级别设置
        /// </summary>
        public ActionResult Control_SetRanksPermissionSettings(int appID)
        {
            List<PermissionItem> ListItem = Permissions.GetPermissionItemsCanAssociateWithUserRank(appID);
            ViewData["ListItem"] = ListItem;
            string strRanks = Request.Form["CheckBoxGroup"];
            if (string.IsNullOrEmpty(strRanks))
            {
                ViewData["StatusMessageType"] = (int)StatusMessageType.Error;
                ViewData["StatusMessageContent"] = "请选择要操作的级别";
            }
            TempData["strRanks"] = strRanks;
            TempData["appID"] = appID;
            return PartialView("Controls/Settings/SetRanksPermissionSettings.ascx");
        }

        /// <summary>
        /// 更新多个级别设置
        /// </summary>
        public ActionResult UpdateRanksPermissionSettings(int allowType)
        {
            string strRanks = Request.Form.GetString("strRanks", string.Empty);
            int appID = (int)TempData["appID"];
            int ItemID = Request.Form.GetInt("ItemID", -1);
            List<int> intRanks = ValueHelper.ParseInt(strRanks.Split(','));

            //List<PermissionItem> ListItem = Permissions.GetPermissionItemsCanAssociateWithUserRank(appID);
            //ListItem = (from k in ListItem where k.ItemID == ItemID select new PermissionItem { ItemKey = k.ItemKey }).ToList<PermissionItem>();

            List<PermissionItemRole> ListPerRole = new List<PermissionItemRole>();
            foreach (var rk in intRanks)
            {
                ListPerRole.Clear();
                PermissionItemRole perItemSeting = new PermissionItemRole();
                perItemSeting.ItemID = ItemID;
                perItemSeting.AllowType = (AllowTypes)allowType;
                ListPerRole.Add(perItemSeting);
                Permissions.UpdatePermissionItemRolesInUserRank(rk, ListPerRole);
            }
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            return RedirectToAction("Control_SetRanksPermissionSettings", new RouteValueDictionary { { "appID", appID } });
        }


        #endregion

        #region 站点设置



        public ActionResult GlobalSetting()
        {
            SetPageTitle("站点设置");
            SiteSettings setting = SiteSettingsManager.GetSiteSettingsForAdmin();
            ViewData["SiteSetting"] = setting;
            Dictionary<string, Language> dictionary = Languages.GetEnabledLanguages();
            Dictionary<string, string> languages = dictionary.ToDictionary<KeyValuePair<string, Language>, string, string>(n => n.Key, n => n.Value.NativeName);
            ViewData["languages"] = languages;
            Dictionary<int, CodeItem> TimeZoneList = CodeItems.GetCodeItems(CodeSetCodes.Instance().TimeZone());
            ViewData["TimeZone"] = TimeZoneList;
            return View("Pages/Settings/GlobalSetting.aspx", "Masters/Settings.master");
        }

        public ActionResult UserHolderSetting()
        {
            SetPageTitle("站点设置");
            SiteSettings setting = SiteSettingsManager.GetSiteSettingsForAdmin();
            ViewData["SiteSetting"] = setting;

            return View("Pages/Settings/UserHolderSetting.aspx", "Masters/Settings.master");
        }
        public ActionResult PostHolderSetting()
        {
            SetPageTitle("站点设置");
            SiteSettings setting = SiteSettingsManager.GetSiteSettingsForAdmin();
            ViewData["SiteSetting"] = setting;
            return View("Pages/Settings/PostHolderSetting.aspx", "Masters/Settings.master");
        }


        public ActionResult WatermarkHolderSetting()
        {
            SetPageTitle("站点设置");
            SiteSettings setting = SiteSettingsManager.GetSiteSettingsForAdmin();
            ViewData["SiteSetting"] = setting;
            return View("Pages/Settings/WatermarkHolderSetting.aspx", "Masters/Settings.master");
        }
        public ActionResult EmailHolderSetting()
        {
            SetPageTitle("站点设置");
            SiteSettings setting = SiteSettingsManager.GetSiteSettingsForAdmin();
            ViewData["SiteSetting"] = setting;
            return View("Pages/Settings/EmailHolderSetting.aspx", "Masters/Settings.master");
        }
        public ActionResult AudingHolderSetting()
        {
            SetPageTitle("站点设置");
            SiteSettings setting = SiteSettingsManager.GetSiteSettingsForAdmin();
            ViewData["SiteSetting"] = setting;
            return View("Pages/Settings/AudingHolderSetting.aspx", "Masters/Settings.master");
        }
        public ActionResult SitePauseHolderSetting()
        {
            SetPageTitle("站点设置");
            SiteSettings setting = SiteSettingsManager.GetSiteSettingsForAdmin();
            ViewData["SiteSetting"] = setting;
            return View("Pages/Settings/SitePauseHolderSetting.aspx", "Masters/Settings.master");
        }




        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult UpdateSiteSetting()
        {
            SiteSettings setting = SiteSettingsManager.GetSiteSettingsForAdmin();

            setting.SiteName = Request.Form.GetString("SiteName", setting.SiteName);
            setting.SiteDescription = Request.Form.GetString("SiteDescription", setting.SiteDescription);
            setting.SearchMetaDescription = Request.Form.GetString("SearchMetaDescription", setting.SearchMetaDescription);
            setting.SearchMetaKeywords = Request.Form.GetString("SearchMetaKeywords", setting.SearchMetaKeywords);
            setting.VerifyCodeOption = (VerifyCodeOption)Request.Form.GetInt("VerifyCodeOption", (int)setting.VerifyCodeOption);
            setting.EnableUserIdentity = Request.Form.GetBool("EnableIdentity", true);
            setting.EnableAD = Request.Form.GetBool("EnableAD", setting.EnableAD);
            setting.EnableClubAD = Request.Form.GetBool("EnableClubAD", setting.EnableClubAD);
            setting.EnableUserAD = Request.Form.GetBool("EnableUserAD", setting.EnableUserAD);
            setting.EnablePoints = Request.Form.GetBool("EnablePoints", setting.EnablePoints);
            setting.SiteTimezone = Request.Form.GetInt("TimeZoneListDefault", setting.SiteTimezone);
            setting.ServerTimezone = Request.Form.GetInt("TimeZoneListServer", setting.ServerTimezone);
            //setting.OpenNewWindowInUserActivity = Request.Form.GetBool("OpenNewWindowInUserActivity", setting.OpenNewWindowInUserActivity);
            setting.EnableSelectAllUserInUserSelector = Request.Form.GetBool("EnableSelectAllUserInUserSelector", setting.EnableSelectAllUserInUserSelector);
            setting.EnableMultilingual = Request.Form.GetBool("EnableInternationalization", setting.EnableMultilingual);
            setting.DefaultLanguage = Request.Form.GetString("defaultLanguage", setting.DefaultLanguage);
            //setting.EnableCensorship = Request.Form.GetBool("EnableCensorship", setting.EnableCensorship);
            setting.EnableSimpleHomepageForAnonymous = Request.Form.GetBool("EnableSimpleHomepageForAnonymous", setting.EnableSimpleHomepageForAnonymous);
            setting.EnableAnonymousBrowse = Request.Form.GetBool("EnableAnonymousBrowse", setting.EnableAnonymousBrowse);
            setting.IsPause = Request.Form.GetBool("IsPause", setting.IsPause);
            setting.PuausePlacard = Request.Form.GetString("PuausePlacard", setting.PuausePlacard);
            setting.ChannelFooterNote = Request.Form.GetString("ChannelFooterNote", setting.ChannelFooterNote);
            setting.SiteRegisterInformation = Request.Form.GetString("SiteRegisterInformation", setting.SiteRegisterInformation);
            setting.SiteStatisticsScript = Request.Form.GetString("SiteStatisticsScript", setting.SiteStatisticsScript);
            setting.EnableFreeHome = Request.Form.GetBool("EnableFreeHome", setting.EnableFreeHome);
            setting.IsAuditCompanyUser = Request.Form.GetBool("IsAuditCompanyUser", setting.IsAuditCompanyUser);
            setting.EnterWizardModeValue = Request.Form.GetInt("EnterWizardModeValue", setting.EnterWizardModeValue);
            setting.IsCloseCompanyUser = Request.Form.GetBool("IsCloseCompanyUser", setting.IsCloseCompanyUser);
            setting.TransactionTax = Request.Form.GetInt("TransactionTax", setting.TransactionTax);
            setting.NoModeratedUserPoint = Request.Form.GetInt("NoModeratedUserPoint", setting.NoModeratedUserPoint);
            #region User Settings
            setting.AccountActivation = (AccountActivations)Request.Form.GetInt("AccountActivation", (int)setting.AccountActivation);
            setting.RegistrationMode = (RegistrationModes)Request.Form.GetInt("RegistrationMode", (int)setting.RegistrationMode);
            setting.EnablePendingUsersToLogin = Request.Form.GetBool("EnablePendingUsersToLogin", setting.EnablePendingUsersToLogin);
            setting.EnableNickName = Request.Form.GetBool("EnableNickName", setting.EnableNickName);

            setting.EnableModeratedUser = Request.Form.GetBool("EnableModeratedUser", setting.EnableModeratedUser);
            setting.DefaultModeratedStatus = Request.Form.GetBool("DefaultModeratedStatus", setting.DefaultModeratedStatus);

            setting.UserDatabaseQuota = Request.Form.GetInt("UserDatabaseQuota", setting.UserDatabaseQuota);
            setting.DatabaseQuotaIntervalValue = Request.Form.GetInt("DatabaseQuotaIntervalValue", setting.DatabaseQuotaIntervalValue);

            int UnameMax = Request.Form.GetInt("UserNameMaxLength", setting.UserNameMaxLength);
            if (UnameMax < 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "用户名最大长度必须为正整数";
                return RedirectToAction("EmailHolderSetting", "ManageSettings");
            }
            else
            {
                setting.UserNameMaxLength = UnameMax;
            }
            int UnameMin = Request.Form.GetInt("UserNameMinLength", setting.UserNameMinLength);
            if (UnameMin < 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "用户名最小长度必须为正整数";
                return RedirectToAction("EmailHolderSetting", "ManageSettings");
            }
            else
            {
                setting.UserNameMinLength = UnameMin;
            }
            if (UnameMax < UnameMin)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "用户名最小长度必须小于或等于用户名最大长度";
                return RedirectToAction("EmailHolderSetting", "ManageSettings");
            }
            setting.UserNameRegex = Request.Form.GetString("UserNameRegex", setting.UserNameRegex);
            setting.PasswordRegex = Request.Form.GetString("PasswordRegex", setting.PasswordRegex);
            int MinRequir = Request.Form.GetInt("MinRequiredNonAlphanumericCharacters", setting.MinRequiredNonAlphanumericCharacters);
            if (MinRequir < 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "密码中包含的最少特殊字符数必须为正整数";
                return RedirectToAction("EmailHolderSetting", "ManageSettings");
            }
            else
            {
                setting.MinRequiredNonAlphanumericCharacters = MinRequir;
            }
            int PwdMin = Request.Form.GetInt("PasswordMinLength", setting.PasswordMinLength);
            if (PwdMin < 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "密码最小长度必须为正整数";
                return RedirectToAction("EmailHolderSetting", "ManageSettings");
            }
            else
            {
                setting.PasswordMinLength = PwdMin;
            }

            int UserPasswordFormat = Request.Form.GetInt("UserPasswordFormat", (int)setting.UserPasswordFormat);
            setting.UserPasswordFormat = (UserPasswordFormats)UserPasswordFormat;
            int DisplayNameType = Request.Form.GetInt("DisplayNameType", (int)setting.DisplayNameType);
            setting.DisplayNameType = (DisplayNameTypes)DisplayNameType;
            setting.DisallowedUserNames = Request.Form.GetString("DisallowedUserNames", setting.DisallowedUserNames);
            // setting.StripDomainName = Request.Form.GetBool("StripDomainName", setting.StripDomainName);
            int avatarProportion = Request.Form.GetInt("AvatarProportion", setting.IntegrityProportions[(int)ProfileItems.Avatar]);
            int birthdayProportion = Request.Form.GetInt("BirthdayProportion", setting.IntegrityProportions[(int)ProfileItems.Birthday]);
            int homeAreaProportion = Request.Form.GetInt("HomeAreaProportion", setting.IntegrityProportions[(int)ProfileItems.HomeArea]);
            int imProportion = Request.Form.GetInt("IMProportion", setting.IntegrityProportions[(int)ProfileItems.IM]);
            int jobInformationProportion = Request.Form.GetInt("JobInformationProportion", setting.IntegrityProportions[(int)ProfileItems.JobInformation]);
            int nowAreaProportion = Request.Form.GetInt("NowAreaProportion", setting.IntegrityProportions[(int)ProfileItems.NowArea]);
            int publicEmailProportion = Request.Form.GetInt("PublicEmailProportion", setting.IntegrityProportions[(int)ProfileItems.PublicEmail]);
            int schoolProportion = Request.Form.GetInt("SchoolProportion", setting.IntegrityProportions[(int)ProfileItems.School]);
            int totalProportion = avatarProportion + birthdayProportion + homeAreaProportion + imProportion
                + jobInformationProportion + nowAreaProportion + publicEmailProportion + schoolProportion;
            if (totalProportion != 100)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "请确保各档案项所占比重总和为100";
                return RedirectToAction("EmailHolderSetting", "ManageSettings");
            }
            setting.IntegrityProportions[(int)ProfileItems.Avatar] = avatarProportion;
            setting.IntegrityProportions[(int)ProfileItems.Birthday] = birthdayProportion;
            setting.IntegrityProportions[(int)ProfileItems.HomeArea] = homeAreaProportion;
            setting.IntegrityProportions[(int)ProfileItems.IM] = imProportion;
            setting.IntegrityProportions[(int)ProfileItems.JobInformation] = jobInformationProportion;
            setting.IntegrityProportions[(int)ProfileItems.NowArea] = nowAreaProportion;
            setting.IntegrityProportions[(int)ProfileItems.PublicEmail] = publicEmailProportion;
            setting.IntegrityProportions[(int)ProfileItems.School] = schoolProportion;

            #endregion

            #region Post Settings
            //setting.EnableAnonymousUserPosting = Request.Form.GetBool("EnableAnonymousUserPosting", setting.EnableAnonymousUserPosting);
            setting.EnableTrackPostsByIP = Request.Form.GetBool("EnableTrackPostsByIP", setting.EnableTrackPostsByIP);
            setting.DisplayPostIP = Request.Form.GetBool("DisplayPostIP", setting.DisplayPostIP);
            setting.EnableAnonymousPosting = Request.Form.GetBool("enableAnonymousPosting", setting.EnableAnonymousPosting);
            setting.EnableCheckPostDate = Request.Form.GetBool("enableCheckPostDate", setting.EnableCheckPostDate);
            setting.UseUBBRenderInlinedImage = Request.Form.GetBool("enableCheckImageCode", setting.UseUBBRenderInlinedImage);
            setting.MinPostDateInterval = Request.Form.GetInt("minPostDateInterval", setting.MinPostDateInterval);
            setting.DisplayPostIPAdminsModeratorsOnly = Request.Form.GetBool("DisplayPostIPAdminsModeratorsOnly", setting.DisplayPostIPAdminsModeratorsOnly);
            int width = Request.Form.GetInt("InlinedImageWidth", setting.InlinedImageWidth);
            int heigh = Request.Form.GetInt("InlinedImageHeight", setting.InlinedImageHeight);
            //if (width < 0 || heigh < 0)
            //{
            //    TempData["StatusMessageType"] = (int)StatusMessageType.Error;
            //    TempData["StatusMessageContent"] = "图片的高度和宽度必须为正整数";
            //    return RedirectToAction("EmailHolderSetting", "ManageSettings");
            //}
            //else
            //{
            setting.InlinedImageWidth = width;
            setting.InlinedImageHeight = heigh;
            //}
            #endregion

            #region Watermark Setting

            setting.WatermarkType = (WatermarkTypes)Request.Form.GetInt("WatermarkType", (int)setting.WatermarkType);
            setting.WatermarkPosition = (WatermarkPosition)Enum.Parse(typeof(WatermarkPosition), Request.Form.GetString("WatermarkPosition", setting.WatermarkPosition.ToString()));
            setting.WatermarkText = Request.Form.GetString("WatermarkText", setting.WatermarkText);
            setting.WatermarkImageName = Request.Form.GetString("WatermarkImageName", setting.WatermarkImageName);
            int picWidth = Request.Form.GetInt("WatermarkMinWidth", setting.WatermarkMinWidth);
            int picHeigh = Request.Form.GetInt("WatermarkMinHeight", setting.WatermarkMinHeight);


            setting.WatermarkMinWidth = picWidth;
            setting.WatermarkMinHeight = picHeigh;

            float PicAlpha = Request.Form.GetFloat("WatermarkAlpha", 0.6f);
            if (PicAlpha >= 1.0)
                setting.WatermarkAlpha = 1.0f;
            else if (PicAlpha <= 0.1)
                setting.WatermarkAlpha = 0.1f;
            else
                setting.WatermarkAlpha = PicAlpha;

            #endregion

            #region Email Setting

            setting.EmailSendFromType = (EmailSendFromTypes)Request.Form.GetInt("EmailSendFromType", (int)setting.EmailSendFromType);
            setting.EnableEmail = Request.Form.GetBool("EnableEmail", setting.EnableEmail);
            setting.SmtpServerRequiredLogin = Request.Form.GetBool("SmtpServerRequiredLogin", setting.SmtpServerRequiredLogin);
            setting.SmtpServerEnableSsl = Request.Form.GetBool("SmtpServerEnableSsl", setting.SmtpServerEnableSsl);
            setting.EmailRegex = Request.Form.GetString("emailRegex", setting.EmailRegex);

            setting.SmtpServer = Request.Form.GetString("SmtpServer", setting.SmtpServer);
            setting.SmtpServerUserName = Request.Form.GetString("SmtpServerUserName", setting.SmtpServerUserName);
            setting.SmtpServerUserNamePostfix = Request.Form.GetString("SmtpServerUserNamePostfix", setting.SmtpServerUserNamePostfix);
            setting.SmtpServerPassword = Request.Form.GetString("SmtpServerPassword", setting.SmtpServerPassword);
            setting.AdminEmailAddress = Request.Form.GetString("AdminEmailAddress", setting.AdminEmailAddress);
            setting.NoReplyEmailAddress = Request.Form.GetString("NoReplyEmailAddress", setting.NoReplyEmailAddress);

            int EmailThrottle = Request.Form.GetInt("EmailThrottle", setting.EmailThrottle);
            int SmtpServerPort = Request.Form.GetInt("SmtpServerPort", setting.SmtpServerPort);
            if (EmailThrottle < 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "每批邮件发送限制量必须为正整数";
                return RedirectToAction("EmailHolderSetting", "ManageSettings");
            }
            //Gmail等邮箱要求邮件发件人和服务器登录Email地址一致
            if (setting.SmtpServer.Equals("smtp.gmail.com", StringComparison.InvariantCultureIgnoreCase))
            {
                if (setting.EmailSendFromType == EmailSendFromTypes.OriginalSendAddress)
                {
                    TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                    TempData["StatusMessageContent"] = "Gmail等邮箱要求邮件发件人和服务器登录Email地址一致，请将发件人设置为强制使用SMTP登录邮件地址";
                    return RedirectToAction("EmailHolderSetting", "ManageSettings");
                }
            }

            if (SmtpServerPort < 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "端口号必须为正整数";
                return RedirectToAction("EmailHolderSetting", "ManageSettings");
            }

            setting.EmailThrottle = EmailThrottle;
            setting.SmtpServerPort = SmtpServerPort;

            #endregion


            #region Auding Setting

            setting.EnableCensorship = Request.Form.GetBool("EnableCensorship", setting.EnableCensorship);
            setting.EnableAuditing = Request.Form.GetBool("EnableAuditing", setting.EnableAuditing);
            //setting.CensorWords = Request.Form.GetString("CensorWords", setting.CensorWords);
            setting.AuditingStatusesForPublicDisplay = (AuditingStatusesForDisplay)Request.Form.GetInt("AuditingStatusesForPublicDisplay", (int)setting.AuditingStatusesForPublicDisplay);

            #endregion

            SiteSettingsManager.Save(setting);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "站点设置保存成功";
            return Redirect(Request.UrlReferrer.AbsoluteUri);
        }
        /// <summary>
        /// 验证Email是否设置成功
        /// </summary>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult TestEmailSettingResult()
        {
            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettingsForAdmin();
            System.Net.Mail.MailMessage mailMessage = new System.Net.Mail.MailMessage();
            string sender = Request.Form.GetString("sender", string.Empty).Trim();
            if (siteSettings.EmailSendFromType == EmailSendFromTypes.SMTPLoginAddress)
                sender = Emails.GetSMTPLoginAddress();
            string receiver = Request.Form.GetString("receiver", string.Empty);
            mailMessage.To.Add(receiver);
            if (mailMessage.To.Count <= 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "测试Email接收人地址不能为空";
                return RedirectToAction("EmailHolderSetting", "ManageSettings");
            }
            try
            {
                mailMessage.From = new MailAddress(sender, Globals.SiteName);
            }
            catch (Exception e)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "邮件发送失败，" + e.Message;
                return RedirectToAction("EmailHolderSetting", "ManageSettings");
            }
            mailMessage.Subject = Request.Form.GetString("subject", string.Empty);
            mailMessage.Body = Request.Form.GetString("body", string.Empty);
            mailMessage.BodyEncoding = System.Text.Encoding.UTF8;
            mailMessage.SubjectEncoding = System.Text.Encoding.UTF8;
            mailMessage.Priority = MailPriority.High;
            mailMessage.IsBodyHtml = true;
            string errorMessage = string.Empty;
            if (Emails.SendEmailMessage(mailMessage, out errorMessage))
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                TempData["StatusMessageContent"] = "测试邮件已发送，Email设置正确";
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "邮件发送失败，" + errorMessage;
            }
            return RedirectToAction("EmailHolderSetting", "ManageSettings");
        }
        #endregion

        #region 导航管理

        #region Show

        /// <summary>
        /// 管理导航
        /// </summary>
        public ActionResult ManageNavigations(int? presentAreaID)
        {
            SetPageTitle("导航管理");
            if (!presentAreaID.HasValue || presentAreaID.Value <= 0)
                presentAreaID = PresentAreaIDs.Instance().Channel();

            IList<Navigation> list = Navigations.GetDefaultNavgitions(presentAreaID.Value, true);

            return View("Pages/Settings/ManageNavigations.aspx", "Masters/Settings.master", list);
        }

        /// <summary>
        /// 编辑导航
        /// </summary>
        public ActionResult Control_EditNavigation(int? navigationID, int ownerType)
        {
            Navigation navigation;
            if (navigationID.HasValue && navigationID.Value > 0)
            {
                navigation = Navigations.GetDefaultNavigation(navigationID.Value, true);
            }
            else
            {
                navigation = new Navigation();
                navigation.NavigationUrl = "http://";
            }
            return PartialView("Controls/Settings/EditNavigation.ascx", navigation);
        }

        #endregion

        #region Manage

        /// <summary>
        /// 更新导航
        /// </summary>
        public ActionResult UpdateNavigation(int? navigationID, int ownerType)
        {
            Navigation navigation;
            if (navigationID.HasValue && navigationID.Value > 0)
            {
                navigation = Navigations.GetDefaultNavigation(navigationID.Value, true);
                if (navigation == null)
                {
                    throw new SPBException(ExceptionTypes.Instance().AccessDenied());
                }
            }
            else
            {
                navigation = new Navigation();
                navigation.DisplayOrder = 100;
                navigation.NavigationType = NavigationTypes.HyperLink;
            }

            navigation.NavigationText = Request.Form.GetString("navigationText", string.Empty).Trim();
            navigation.IsEnabled = Request.Form.GetBool("isEnabled", false);

            if (navigation.DefaultNavigationID <= 0 || navigation.NavigationType == NavigationTypes.HyperLink)
            {
                navigation.NavigationUrl = Request.Form.GetString("navigationUrl", string.Empty).Trim();
                navigation.NavigationTarget = Request.Form.GetString("navigationTarget", string.Empty);
            }
            if (ownerType != PresentAreaIDs.Instance().Channel())
            {
                navigation.NavigationText = HtmlUtils.TrimHtml(navigation.NavigationText, 64);
            }

            if (navigationID.HasValue && navigationID.Value > 0)
            {
                Navigations.UpdateDefaultNavigation(navigation);
            }

            //添加导航名称语言包
            Dictionary<string, string> navigationNameRes = new Dictionary<string, string>();
            foreach (Language language in Languages.GetLanguages(true).Values)
            {
                string languageName = Request.Form.GetString("navigationName_" + language.LanguageCode, string.Empty);
                if (!string.IsNullOrEmpty(languageName))
                    navigationNameRes[language.LanguageCode] = languageName;
            }
            if (navigationNameRes.Count > 0)
                Navigations.UpdateDefaultNavigationNameRes(navigation.DefaultNavigationID, navigationNameRes);

            TempData["StatusMessageType"] = (int)StatusMessageType.Success;

            return RedirectToAction("Control_EditNavigation", new RouteValueDictionary { { "navigationID", navigationID }, { "ownerType", ownerType } });
        }

        /// <summary>
        /// 删除导航
        /// </summary>
        public ActionResult DeleteNavigation(int navigationID, int presentAreaID)
        {
            Navigation navigation = Navigations.GetDefaultNavigation(navigationID, true);
            if (navigation != null && (!navigation.IsLocked && !navigation.CanAssignOwner || navigation.NavigationType != NavigationTypes.Application))
            {
                Navigations.DeleteDefaultNavigation(navigationID);
            }
            return new EmptyResult();
        }

        public ActionResult UpdateNavigations(int presentAreaID)
        {
            int count = Request.Form.GetInt("totalOptionCount", 0);
            IList<Navigation> defaultNavigations = Navigations.GetDefaultNavgitions(presentAreaID, true);
            IList<Navigation> navigations = new List<Navigation>();
            IList<int> needCreatedNavIDs = new List<int>();
            for (int i = 0; i < count; i++)
            {
                Navigation navigation = null;

                int defaultNavID = Request.Form.GetInt(string.Format("DefaultNavID_{0}", i), 0);
                if (defaultNavigations.Any(n => n.DefaultNavigationID == defaultNavID))
                {
                    navigation = Navigations.GetDefaultNavigation(defaultNavID, true);
                    if (navigation != null)
                    {
                        navigation.NavigationText = Request.Form.GetString(string.Format("navigationText_{0}", i), navigation.NavigationText);
                        navigation.NavigationTarget = Request.Form.GetBool(string.Format("navigationTarget_{0}", i), false) ? "_blank" : "_self";
                        navigation.NavigationUrl = Request.Form.GetString(string.Format("navigationLink_{0}", i), navigation.NavigationUrl);
                        navigation.SecondaryID = Request.Form.GetInt(string.Format("secondaryID_{0}", i), 0);
                        navigation.DisplayOrder = Request.Form.GetInt(string.Format("displayOrder_{0}", i), navigation.DisplayOrder);
                        if (!navigation.IsLocked)
                            navigation.IsEnabled = Request.Form.GetBool(string.Format("isEnabled_{0}", i), false);
                        navigation.NavigationText = Formatter.FormatSingleLinePlainTextForStorage(navigation.NavigationText);

                        navigations.Add(navigation);
                    }
                }
                else
                {
                    //防止新添加的导航ID有重复的
                    if (defaultNavID <= 0 || needCreatedNavIDs.Contains(defaultNavID))
                        continue;
                    needCreatedNavIDs.Add(defaultNavID);
                    navigation = new Navigation();
                    navigation.DefaultNavigationID = defaultNavID;
                    navigation.PresentAreaID = presentAreaID;
                    navigation.NavigationType = (NavigationTypes)Request.Form.GetInt(string.Format("navigationTypes_{0}", i), (int)NavigationTypes.HyperLink);
                    if (navigation.NavigationType == NavigationTypes.Application)
                        navigation.ApplicationID = Request.Form.GetInt(string.Format("applications_{0}", i), 0);
                    navigation.SecondaryID = Request.Form.GetInt(string.Format("secondaryID_{0}", i), 0);
                    navigation.NavigationText = Request.Form.GetString(string.Format("navigationText_{0}", i), navigation.NavigationText);
                    navigation.NavigationTarget = Request.Form.GetBool(string.Format("navigationTarget_{0}", i), false) ? "_blank" : "_self";
                    navigation.NavigationUrl = Request.Form.GetString(string.Format("navigationLink_{0}", i), navigation.NavigationUrl);
                    navigation.IsEnabled = Request.Form.GetBool(string.Format("isEnabled_{0}", i), false);
                    navigation.NavigationText = Formatter.FormatSingleLinePlainTextForStorage(navigation.NavigationText);
                    navigation.DisplayOrder = Request.Form.GetInt(string.Format("displayOrder_{0}", i), navigation.DisplayOrder);
                    Navigations.CreateDefaultNavigation(navigation);
                }
            }

            Navigations.UpdateDefaultNavigations(navigations);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;

            return RedirectToAction("ManageNavigations", new RouteValueDictionary { { "presentAreaID", presentAreaID } });
        }

        /// <summary>
        /// 更新导航菜单排序
        /// </summary>
        public JsonResult UpdateDisplayOrder(int ownType)
        {
            string option = Request.QueryString.GetString("option", string.Empty);
            IList<Navigation> navigations = new List<Navigation>();
            string[] itemStrings = option.Split(',');
            foreach (string itemstr in itemStrings)
            {
                string[] itempiar = itemstr.Split(':');
                if (itempiar.Length == 2)
                {
                    int key;
                    int value;
                    int.TryParse(itempiar[0], out key);
                    int.TryParse(itempiar[1], out value);
                    if (key * value > 0)
                    {
                        Navigation navigation = Navigations.GetDefaultNavigation(key, true);
                        if (navigation != null)
                        {
                            navigation.DisplayOrder = value;
                            navigations.Add(navigation);
                        }
                    }
                }
            }

            Navigations.UpdateDefaultNavigations(navigations);
            return Json(new { isSuccess = true }, JsonRequestBehavior.AllowGet);
        }

        #endregion

        #endregion

        #region 应用管理

        /// <summary>
        /// 显示应用管理
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ManageApplications()
        {
            SetPageTitle("应用管理");
            Dictionary<int, Application> applications = Applications.GetApplicationsForAdmin();
            return View("Pages/Settings/ManageApplications.aspx", "Masters/Settings.master", applications);
        }

        /// <summary>
        /// 设置某个应用的启用状态
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult UpdateEnabledStatus(int applicationID, bool isEnabled)
        {
            Applications.UpdateEnabledStatus(applicationID, isEnabled);
            if (Applications.IsEnabled(applicationID))
            {
                if (isEnabled)
                    TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "启用操作已成功");
                else
                    TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Error, "禁用操作失败，请与管理员联系");
            }
            else
            {
                if (isEnabled)
                    TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Error, "启用操作失败，请与管理员联系");
                else
                    TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "禁用操作已成功");
            }
            return RedirectToAction("ManageApplications");
        }
        /// <summary>
        /// 计算应用的统计信息
        /// </summary>
        /// <param name="aplicationID">应用ID,若参数小于零,则计算所有应用的统计信息</param>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult CalculateStatistics(int? applicationID)
        {
            Applications.CalculateStatistics(applicationID.HasValue ? applicationID.Value : -1);
            if (applicationID.HasValue && applicationID.Value > 0)
            {
                Application application = Applications.GetApplicationsForAdmin()[applicationID.Value];
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, string.Format("更新{0}的统计信息操作已成功", application.ApplicationName));
            }
            else
            {
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "更新所有应用的统计信息操作已成功");
            }
            return RedirectToAction("ManageApplications");
        }

        /// <summary>
        /// 重启WebApplication
        /// </summary>
        //[AcceptVerbs(HttpVerbs.Get)]
        //public ActionResult ManageUnloadAppDoman()
        //{
        //    return View("Pages/Settings/ManageUnloadAppDoman.aspx", "Masters/Settings.master");
        //}

        /// <summary>
        /// 重启站点
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult UnloadAppDomain()
        {
            HttpRuntime.UnloadAppDomain();
            //TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "站点重新启动成功");
            return Redirect(Request.UrlReferrer.ToString());
        }

        #endregion

        #region 清除过期数据
        /// <summary>
        /// 显示清除过期数据模式框
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult Control_DeleteSiteExpiredData()
        {
            return PartialView("Controls/Settings/DeleteSiteExpiredData.ascx");
        }
        /// <summary>
        /// 执行清除过期数据操作
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult ExecDeleteSiteExpiredData()
        {
            int beforeDays = Request.Form.GetInt("beforeDays", -1);
            int typeValue = Request.Form.GetInt("siteExpiredDataType", -1);
            if (beforeDays <= 0)
            {
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Error, "请选择日期");
                return RedirectToAction("Control_DeleteSiteExpiredData");
            }
            if (typeValue < 0)
            {
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Error, "请选择数据类型");
                return RedirectToAction("Control_DeleteSiteExpiredData");
            }
            TempData["beforeDays"] = beforeDays;
            TempData["siteExpiredDataType"] = typeValue;

            SiteExpiredDataType siteExpiredDataType = (SiteExpiredDataType)typeValue;
            int numberOfDelete = 0;
            switch (siteExpiredDataType)
            {
                case SiteExpiredDataType.UserVisit:
                    numberOfDelete = UserVisits.BatchDeleteVisits(beforeDays);
                    if (numberOfDelete > 0)
                        TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, string.Format("清除访客记录过期数据操作成功,共清除{0}条访客记录", numberOfDelete));
                    else
                        TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Hint, string.Format("哦噢,{0}天以前的访客记录为空，请重新选择一个较短的时间", beforeDays));

                    break;
                case SiteExpiredDataType.UserActivity:
                    numberOfDelete = Activities.BatchDeleteUserActivities(beforeDays);
                    if (numberOfDelete > 0)
                        TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, string.Format("清除个人动态过期数据操作成功,共清除{0}条个人动态", numberOfDelete));
                    else
                        TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Hint, string.Format("哦噢,{0}天以前的个人动态为空，请重新选择一个较短的时间", beforeDays));

                    break;
                case SiteExpiredDataType.FriendActivity:
                    numberOfDelete = Activities.BatchDeleteFriendActivities(beforeDays);
                    if (numberOfDelete > 0)
                        TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, string.Format("清除朋友动态过期数据操作成功,共清除{0}条朋友动态", numberOfDelete));
                    else
                        TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Hint, string.Format("哦噢,{0}天以前的朋友动态为空，请重新选择一个较短的时间", beforeDays));

                    break;
                case SiteExpiredDataType.PrivateMessage:
                    numberOfDelete = PrivateMessages.BatchDeletePrivateMessages(beforeDays);
                    if (numberOfDelete > 0)
                        TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, string.Format("清除私信过期数据操作成功,共清除{0}条私信", numberOfDelete));
                    else
                        TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Hint, string.Format("哦噢,{0}天以前的私信为空，请重新选择一个较短的时间", beforeDays));

                    break;
                case SiteExpiredDataType.UserPointRecord:
                    numberOfDelete = Points.BatchDeleteUserPointRecords(beforeDays);
                    if (numberOfDelete > 0)
                        TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, string.Format("清除用户积分记录过期数据操作成功,共清除{0}条用户积分记录", numberOfDelete));
                    else
                        TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Hint, string.Format("哦噢,{0}天以前的用户积分记录为空，请重新选择一个较短的时间", beforeDays));

                    break;
                case SiteExpiredDataType.UserGuestbookPost:
                    numberOfDelete = UserGuestbookManager.Instance().BatchDeleteGuestbookPosts(beforeDays);
                    if (numberOfDelete > 0)
                        TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, string.Format("清除用户留言过期数据操作成功,共清除{0}条用户留言", numberOfDelete));
                    else
                        TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Hint, string.Format("哦噢,{0}天以前的用户留言为空，请重新选择一个较短的时间", beforeDays));

                    break;
                default:
                    break;
            }
            return RedirectToAction("Control_DeleteSiteExpiredData");
        }

        #endregion

        #region 数据备份
        /// <summary>
        /// 数据备份
        /// </summary>
        public ActionResult DataBackup()
        {
            SetPageTitle("数据备份");
            return View("Pages/Settings/DataBackup.aspx", "Masters/Settings.master");
        }

        /// <summary>
        /// 清除过期数据
        /// </summary>
        //[HttpCompress()]
        //public ActionResult DeleteSiteExpiredData()
        //{
        //    SetPageTitle("清除过期数据");
        //    return View("Pages/Settings/DeleteSiteExpiredData.aspx", "Masters/Settings.master");
        //}

        /// <summary>
        /// 执行附件备份
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult AttachmentBackup()
        {
            string backupDirectoryName = "Backup";

            DateTime startDatetime = Request.Form.Get<DateTime>("startDatetime");

            //应该包含endDatetime当天的数据，因此需要加1天
            DateTime endDatetime = Request.Form.Get<DateTime>("endDatetime").AddDays(1);

            string uploadsPhysicalFilePath = WebUtils.GetPhysicalFilePath("~/Uploads/", false);
            string backupPhysicalFilePath = WebUtils.GetPhysicalFilePath("~/Uploads/Backup/" + startDatetime.ToString("yyyyMMdd") + "-" + endDatetime.ToString("yyyyMMdd") + "/", false);

            DirectoryInfo uploadsDirectory = new DirectoryInfo(uploadsPhysicalFilePath);
            DirectoryInfo[] subDirectories = uploadsDirectory.GetDirectories();
            foreach (DirectoryInfo subDirectory in subDirectories)
            {
                if (!subDirectory.Name.EndsWith(backupDirectoryName, StringComparison.InvariantCultureIgnoreCase))
                {
                    FileInfo[] fileInfos = subDirectory.GetFiles("*.*", SearchOption.AllDirectories);

                    foreach (FileInfo fileInfo in fileInfos)
                    {
                        if (fileInfo.CreationTime >= startDatetime && fileInfo.CreationTime < endDatetime)
                        {
                            string destDirectoryName = fileInfo.DirectoryName.Replace(uploadsPhysicalFilePath, backupPhysicalFilePath);
                            if (!Directory.Exists(destDirectoryName))
                                Directory.CreateDirectory(destDirectoryName);

                            fileInfo.CopyTo(Path.Combine(destDirectoryName, fileInfo.Name), true);
                        }
                    }
                }
            }

            StatusMessageData statusMessageData = new StatusMessageData(StatusMessageType.Success, "附件增量备份创建成功，放置在：" + backupPhysicalFilePath);
            TempData["StatusMessageData"] = statusMessageData;
            return RedirectToAction("DataBackup");
        }

        #endregion

        #region 地区设置
        /// <summary>
        /// 显示地区列表
        /// </summary>
        /// <returns></returns>
        public ActionResult ManageAreas()
        {
            SetPageTitle("地区管理");
            List<Area> listArea = Areas.GetRootAreas(true);
            return View("Pages/Settings/ManageAreas.aspx", "Masters/Settings.master", listArea);
        }

        /// <summary>
        /// 获取所有的子级地区
        /// </summary>
        public ActionResult Control_ListChildAreas()
        {
            string parentCode = Request.QueryString.GetString("parentCode", string.Empty);
            Area parentArea = Areas.GetArea(parentCode, true);
            if (parentArea == null)
                return RedirectToAction(SiteUrls.Instance().Error404(string.Format("找不到areaCode为{0}的地区", parentCode)));
            return PartialView("Controls/Settings/ListChildAreas.ascx", parentArea.Childs);
        }

        /// <summary>
        /// 编辑地区
        /// </summary>
        public ActionResult Control_EditArea(string areaCode)
        {
            Area area = null;
            if (!string.IsNullOrEmpty(areaCode))
            {
                area = Areas.GetArea(areaCode, true);
            }
            if (area == null)
            {
                if (TempData["area"] != null)
                {
                    area = (Area)TempData["area"];
                }
                else
                {
                    area = new Area();
                    area.ParentCode = Request.QueryString.GetString("parentCode", string.Empty);
                }
            }
            return PartialView("Controls/Settings/EditArea.ascx", area);
        }
        /// <summary>
        /// 创建地区
        /// </summary>
        public ActionResult CreateArea()
        {
            Area area = new Area();
            area.AreaCode = Request.Form.GetString("areaCode", string.Empty);
            area.ParentCode = Request.Form.GetString("parentCode", string.Empty);
            area.DisplayOrder = Request.Form.GetInt("displayOrder", -1);
            area.Name = Request.Form.GetString("areaName", string.Empty);
            if (string.IsNullOrEmpty(area.AreaCode))
            {
                TempData["area"] = area;
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "行政区号不能为空";
                return RedirectToAction("Control_EditArea");
            }
            if (string.IsNullOrEmpty(area.Name))
            {
                TempData["area"] = area;
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "地区名称不能为空";
                return RedirectToAction("Control_EditArea");
            }
            if (Areas.GetArea(area.AreaCode, true) != null)
            {
                TempData["area"] = area;
                TempData["isWritten"] = true;
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "AreaCode已被占用，请更换后再试";
                return RedirectToAction("Control_EditArea");
            }
            if (area.DisplayOrder < 0)
            {
                TempData["area"] = area;
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "排序序号必须为非负数";
                return RedirectToAction("Control_EditArea");
            }
            Areas.CreateArea(area);
            //添加地区名称语言包
            Dictionary<string, string> areaNameRes = new Dictionary<string, string>();
            foreach (Language language in Languages.GetLanguages(true).Values)
            {
                string areaName = Request.Form.GetString("areaName_" + language.LanguageCode, string.Empty);
                if (!string.IsNullOrEmpty(areaName))
                    areaNameRes[language.LanguageCode] = areaName;
            }
            if (areaNameRes.Count > 0)
                Areas.UpdateAreaNameRes(area.AreaCode, areaNameRes);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "添加地区成功";
            return RedirectToAction("Control_EditArea");
        }
        /// <summary>
        /// 更新地区
        /// </summary>
        public ActionResult UpdateArea(string areaCode)
        {
            Area area = Areas.GetArea(areaCode, true);
            if (area == null)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = string.Format("找不到areaCode为{0}的地区", areaCode);
                return RedirectToAction("Control_EditArea", new RouteValueDictionary { { "areaCode", areaCode } });
            }

            area.DisplayOrder = Request.Form.GetInt("displayOrder", -1);
            area.Name = Request.Form.GetString("areaName", string.Empty);
            string oldParentCode = area.ParentCode;
            area.ParentCode = Request.Form.GetString("parentCode", string.Empty);

            if (string.IsNullOrEmpty(area.Name))
            {
                TempData["area"] = area;
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "地区名称不能为空";
                return RedirectToAction("Control_EditArea", new RouteValueDictionary { { "areaCode", areaCode } });
            }
            if (area.DisplayOrder < 0)
            {
                TempData["area"] = area;
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "排序序号必须为非负数";
                return RedirectToAction("Control_EditArea", new RouteValueDictionary { { "areaCode", areaCode } });
            }
            Areas.UpdateArea(area, oldParentCode);
            //更新地区名称语言包
            Dictionary<string, string> areaNameRes = new Dictionary<string, string>();
            foreach (Language language in Languages.GetLanguages(true).Values)
            {
                string areaName = Request.Form.GetString("areaName_" + language.LanguageCode, string.Empty);
                if (!string.IsNullOrEmpty(areaName))
                    areaNameRes[language.LanguageCode] = areaName;
            }
            if (areaNameRes.Count > 0)
                Areas.UpdateAreaNameRes(area.AreaCode, areaNameRes);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "更新地区成功";
            return RedirectToAction("Control_EditArea", new RouteValueDictionary { { "areaCode", area.AreaCode } });
        }
        /// <summary>
        /// 删除地区
        /// </summary>
        public ActionResult DeleteArea()
        {
            string areaCode = Request.QueryString.GetString("areaCode", string.Empty);
            if (string.IsNullOrEmpty(areaCode))
                throw new ArgumentException("AreaCode错误");

            Area DelArea = Areas.GetArea(areaCode, true);
            if (DelArea.ChildCount > 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "本地区有下级地区不允许删除！请先删掉所有下级地区。";
            }
            else
            {
                Areas.DeleteArea(areaCode);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                TempData["StatusMessageContent"] = "删除成功";
            }
            return RedirectToAction("ManageAreas");
        }

        #endregion

        #region 语言管理

        /// <summary>
        /// 管理语言
        /// </summary>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ManageLanguages()
        {
            SetPageTitle("语言管理");
            Dictionary<string, Language> dictionary = Languages.GetLanguages(true);
            return View("Pages/Settings/ManageLanguages.aspx", "Masters/Settings.master", dictionary);
        }
        /// <summary>
        /// 添加新语言
        /// </summary>
        /// <returns></returns>
        public ActionResult Control_NewLanguage()
        {
            Language language = null;
            if (TempData["language"] != null)
                language = TempData.Get<Language>("language");
            else
            {
                language = new Language();
                language.LanguageCode = Request.QueryString.GetString("languageCode", string.Empty);
                language.NativeName = Request.QueryString.GetString("nativeName", string.Empty);
                language.IsEnabled = Request.QueryString.GetBool("isEnabled", true);
            }
            return PartialView("Controls/Settings/EditLanguage.ascx", language);
        }

        /// <summary>
        /// 添加新语言
        /// </summary>
        /// <returns></returns>
        public ActionResult CreateLanguage()
        {
            Language language = new Language();

            language.LanguageCode = Request.Form.GetString("languageCode", string.Empty);
            language.NativeName = Request.Form.GetString("nativeName", string.Empty);
            language.IsEnabled = Request.Form.GetBool("isEnabled", true);

            if (string.IsNullOrEmpty(language.LanguageCode))
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "区域/语言编码不能为空";
                TempData["language"] = language;
                return RedirectToAction("Control_NewLanguage", "ManageSettings");
            }
            if (string.IsNullOrEmpty(language.NativeName))
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "本地化名称不能为空";
                TempData["language"] = language;
                return RedirectToAction("Control_NewLanguage", "ManageSettings");
            }
            if (Languages.IsExist(language.LanguageCode))
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "该语言已经被创建";
                TempData["language"] = language;
                return RedirectToAction("Control_NewLanguage", "ManageSettings");
            }
            Languages.CreateLanguage(language);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "语言添加成功";
            return RedirectToAction("Control_NewLanguage", "ManageSettings");
        }

        /// <summary>
        ///  编辑语言
        /// </summary>
        /// <param name="languageCode">区域/语言编码</param>
        /// <returns></returns>
        public ActionResult Control_EditLanguage(string languageCode)
        {
            Language language = Languages.GetLanguage(languageCode, true);
            if (language == null)
                return Redirect(SiteUrls.Instance().Error404("该语言不存在"));

            return PartialView("Controls/Settings/EditLanguage.ascx", language);
        }

        public ActionResult UpdateLanguage(string languageCode)
        {
            Language language = Languages.GetLanguage(languageCode, true);
            if (language == null)
                return Redirect(SiteUrls.Instance().Error404("该语言不存在"));

            language.LanguageCode = Request.Form.GetString("languageCode", string.Empty);
            language.NativeName = Request.Form.GetString("nativeName", string.Empty);
            language.IsEnabled = Request.Form.GetBool("isEnabled", true);

            if (string.IsNullOrEmpty(language.LanguageCode))
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "区域/语言编码不能为空";
                TempData["language"] = language;
                return RedirectToAction("Control_AddLanguage", "ManageSettings");
            }
            if (string.IsNullOrEmpty(language.NativeName))
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "本地化名称不能为空";
                TempData["language"] = language;
                return RedirectToAction("Control_NewSchool", "ManageSettings");
            }

            Languages.UpdateLanguage(language);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "语言更新成功";
            return PartialView("Controls/Settings/EditLanguage.ascx", language);
        }

        /// <summary>
        /// 删除语言
        /// </summary>
        /// <param name="languageCode">区域/语言编码</param>
        /// <returns></returns>
        public ActionResult DeleteLanguage(string languageCode)
        {
            Language language = Languages.GetLanguage(languageCode, true);
            if (language == null)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "删除语言失败，该语言不存在";
            }
            else
            {
                Languages.DeleteLanguage(languageCode);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                TempData["StatusMessageContent"] = "删除语言成功";
            }
            return RedirectToAction("ManageLanguages", "ManageSettings");
        }

        #endregion

        #region 管理数据字典
        /// <summary>
        /// 管理数据字典
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ManageDataDictionary(string codeSetCode)
        {
            SetPageTitle("管理数据字典");
            Dictionary<string, CodeSet> codeSets = CodeSets.GetCodeSets();
            if (codeSets == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format("获取Dictionary<string, CodeSet>出错")));
            }
            if (string.IsNullOrEmpty(codeSetCode))
            {
                codeSetCode = codeSets.ElementAt(0).Key;
            }

            ViewData["codeSetCode"] = codeSetCode;
            return View("Pages/Settings/ManageDataDictionary.aspx", "Masters/Settings.master");
        }
        /// <summary>
        /// 显示数据项列表
        /// </summary>
        /// <returns></returns>
        public ActionResult Control_ManageDataDictionary(string codeSetCode)
        {
            Dictionary<int, CodeItem> codeSets = CodeItems.GetCodeItems(codeSetCode);
            ViewData["codeSetCode"] = codeSetCode;
            return View("Controls/Settings/ManageCodeItemsList.ascx", codeSets);
        }


        /// <summary>
        /// 显示添加数据字典
        /// </summary>
        /// <param name="codeSetCode"></param>
        /// <returns></returns>
        public ActionResult Control_AddCodeItem(string codeSetCode)
        {

            if (string.IsNullOrEmpty(codeSetCode))
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format("获取CodeSetCode：“{0}”出错", codeSetCode)));
            }


            ViewData["codeSetCode"] = codeSetCode;
            return PartialView("Controls/Settings/EditCodeItem.ascx");

        }

        /// <summary>
        /// 执行添加CodeItem操作
        /// </summary>
        /// <param name="codeSetCode"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult CreateCodeItem(string codeSetCode)
        {
            if (string.IsNullOrEmpty(codeSetCode))
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format("获取CodeSetCode：“{0}”出错", codeSetCode)));
            }
            CodeItem item = new CodeItem();

            int itemID = Request.Form.GetInt("ItemID", -1);
            if (CodeItems.IsExist(codeSetCode, itemID))
            {
                ViewData["codeSetCode"] = codeSetCode;
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = string.Format("已经存在ItemID为{0}，CodeSetCode为{1}的代码项，请选择代码项列表中尚未使用的ItemID", itemID, codeSetCode);
                return PartialView("Controls/Settings/EditCodeItem.ascx");
            }


            item.CodeSetCode = codeSetCode;
            item.ItemID = Request.Form.GetInt("ItemID", 0);
            item.Name = Request.Form.GetString("ItemName", string.Empty);
            item.DisplayOrder = Request.Form.GetInt("ItemDisplayOrder", 0);
            item.Depth = 0;
            item.ParentItemID = 0;


            CodeItems.CreateCodeItem(item);
            ViewData["codeSetCode"] = codeSetCode;
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "添加成功";
            return PartialView("Controls/Settings/EditCodeItem.ascx");
        }

        /// <summary>
        /// 显示编辑页
        /// </summary>
        /// <param name="codeSetCode"></param>
        /// <param name="itemID"></param>
        /// <returns></returns>
        public ActionResult Control_EditCodeItem(string codeSetCode, int itemID)
        {
            CodeItem item = CodeItems.GetCodeItem(codeSetCode, itemID);
            if (item == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format("获取CodeSetCode：“{0}”出错", codeSetCode)));
            }
            ViewData["item"] = item;

            return PartialView("Controls/Settings/EditCodeItem.ascx");

        }

        /// <summary>
        /// 执行编辑操作
        /// </summary>
        /// <param name="codeSetCode"></param>
        /// <param name="itemID"></param>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult UpdateCodeItem(string codeSetCode, int itemID)
        {
            CodeItem item = CodeItems.GetCodeItem(codeSetCode, itemID);
            if (item == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format("获取CodeSetCode：“{0}”出错", codeSetCode)));
            }
            item.CodeSetCode = codeSetCode;
            item.ItemID = Request.Form.GetInt("ItemID", 0);
            item.Name = Request.Form.GetString("ItemName", string.Empty);
            item.DisplayOrder = Request.Form.GetInt("ItemDisplayOrder", 0);
            item.Depth = 0;
            item.ParentItemID = 0;
            CodeItems.UpdateCodeItem(item);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "修改代码项成功";
            ViewData["item"] = item;
            return PartialView("Controls/Settings/EditCodeItem.ascx");

        }

        /// <summary>
        /// 删除一个代码项
        /// </summary>
        public ActionResult DeleteCodeItem(string codeSetCode, int itemID)
        {
            CodeItem item = CodeItems.GetCodeItem(codeSetCode, itemID);
            if (item != null)
            {
                CodeItems.DeleteCodeItem(codeSetCode, itemID);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                TempData["StatusMessageContent"] = "删除代码项操作成功";
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "删除代码项操作失败，原因是找不到该代码项";
            }
            return RedirectToAction("Control_ManageDataDictionary", new RouteValueDictionary { { "codeSetCode", codeSetCode } });
        }

        /// <summary>
        /// 批量删除主题帖
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult DeleteCodeItems(string codeSetCode)
        {
            try
            {
                string[] deleteCodeItems = null;
                if (!string.IsNullOrEmpty(Request.Form.GetString("codeItemsBoxGroup", string.Empty)))
                {
                    deleteCodeItems = Request.Form.GetString("codeItemsBoxGroup", string.Empty).Split(',');
                    if (deleteCodeItems != null && deleteCodeItems.Length > 0)
                    {
                        foreach (string ItemID in deleteCodeItems)
                        {
                            int id = 0;
                            int.TryParse(ItemID, out id);
                            CodeItem codeItem = CodeItems.GetCodeItem(codeSetCode, id);

                            if (codeItem != null)
                            {
                                CodeItems.DeleteCodeItem(codeSetCode, codeItem.ItemID);
                            }
                        }
                        TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                        TempData["StatusMessageContent"] = "批量删除代码项操作已成功";
                    }
                }
            }
            catch (Exception)
            {
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Error, "批量删除主题帖操作失败！");
            }
            return Redirect(Request.UrlReferrer.AbsoluteUri);
        }

        #endregion

        #region 学校管理
        /// <summary>
        /// 管理学校
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ManageSchools(int? pageIndex)
        {
            SetPageTitle("学校管理");
            string areaCode = Request.QueryString.GetString("areaCode", "11000000");
            SchoolTypes schoolType = (SchoolTypes)Request.QueryString.GetInt("schoolType", (int)SchoolTypes.University);
            PagingDataSet<School> schools = Schools.GetSchools(17, pageIndex ?? 1, areaCode, schoolType, true);
            return View("Pages/Settings/ManageSchools.aspx", "Masters/Settings.master", schools);
        }

        public ActionResult DeleteSchool(string returnURL)
        {
            School sh = Schools.GetSchool(Request.QueryString.GetInt("schoolID", -1), true);
            if (sh == null)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "学校删除失败，该学校不存在";
            }
            else
            {
                Schools.DeleteSchool(sh);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                TempData["StatusMessageContent"] = "学校删除成功";
            }
            return Redirect(returnURL);
        }

        /// <summary>
        /// 显示编辑学校
        /// </summary>
        public ActionResult Control_EditSchool(int schoolID)
        {
            School sh = Schools.GetSchool(schoolID, true);
            if (sh == null)
                return Redirect(SiteUrls.Instance().Error404("该学校不存在"));

            return PartialView("Controls/Settings/EditSchool.ascx", sh);
        }

        public ActionResult UpdateSchool(int schoolID)
        {
            School sh = Schools.GetSchool(schoolID, true);
            if (sh == null)
                throw new ArgumentException("该学校不存在");
            sh.DisplayOrder = Request.Form.GetInt("DisplayOrder", -1);
            sh.SchoolType = (SchoolTypes)Request.Form.GetInt("manageSchoolType", (int)SchoolTypes.University);
            if (sh.DisplayOrder < 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "排序序号必须为非负整数";
                return RedirectToAction("Control_EditSchool", "ManageSettings", new RouteValueDictionary { { "schoolID", schoolID } });
            }
            if ((int)sh.SchoolType < 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "学校类型不能为空";
                return RedirectToAction("Control_EditSchool", "ManageSettings", new RouteValueDictionary { { "schoolID", schoolID } });
            }
            string areaCode = Request.Form.GetString("schoolAreaCode", sh.AreaCode);
            sh.AreaCode = areaCode;
            Area area = Areas.GetArea(areaCode, false);
            if (area != null)
                sh.AreaName = area.Name;

            sh.SchoolName = Request.Form.GetString("SchoolName", string.Empty);
            if (string.IsNullOrEmpty(sh.SchoolName))
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "学校名称不能为空";
                return RedirectToAction("Control_EditSchool", "ManageSettings", new RouteValueDictionary { { "schoolID", schoolID } });
            }
            Schools.UpdateSchool(sh);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "学校更新成功";
            return RedirectToAction("Control_EditSchool", "ManageSettings", new RouteValueDictionary { { "schoolID", schoolID } });
        }

        /// <summary>
        /// 显示添加学校
        /// </summary>
        public ActionResult Control_NewSchool()
        {
            School school = null;
            if (TempData["school"] != null)
                school = TempData.Get<School>("school");
            else
            {
                school = new School();
                school.AreaCode = Request.QueryString.GetString("areaCode", string.Empty);
                school.SchoolType = (SchoolTypes)Request.QueryString.GetInt("schoolType", (int)SchoolTypes.University);
                school.DisplayOrder = (int)(school.SchoolType);
            }
            return PartialView("Controls/Settings/EditSchool.ascx", school);
        }

        public ActionResult CreateSchool()
        {
            School school = new School();
            school.DisplayOrder = Request.Form.GetInt("DisplayOrder", -1);
            school.SchoolType = (SchoolTypes)Request.Form.GetInt("manageSchoolType", (int)SchoolTypes.University);
            string AreaCode = Request.Form.GetString("schoolAreaCode", string.Empty);
            school.AreaCode = AreaCode;
            school.AreaName = Areas.GetArea(AreaCode, true).Name;

            school.SchoolName = Request.Form.GetString("SchoolName", string.Empty).Trim();
            if (school.DisplayOrder < 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "排序序号必须为非负整数";
                TempData["school"] = school;
                return RedirectToAction("Control_NewSchool", "ManageSettings");
            }
            if (string.IsNullOrEmpty(school.AreaCode))
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "学校地区不能为空";
                TempData["school"] = school;
                return RedirectToAction("Control_NewSchool", "ManageSettings");
            }
            if ((int)school.SchoolType < 0)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "学校类型不能为空";
                TempData["school"] = school;
                return RedirectToAction("Control_NewSchool", "ManageSettings");
            }
            if (string.IsNullOrEmpty(school.SchoolName))
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "学校名称不能为空";
                TempData["school"] = school;
                return RedirectToAction("Control_NewSchool", "ManageSettings");
            }
            Schools.CreateSchool(school);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "学校添加成功";
            return RedirectToAction("Control_NewSchool", "ManageSettings");
        }

        #endregion

        #region Widget管理
        /// <summary>
        ///  Widget管理
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ManageWidgets(int? presentAreaID)
        {
            IList<Widget> list = Widgets.GetInitialWidgets(presentAreaID ?? PresentAreaIDs.Instance().Channel(), true);
            Dictionary<string, Widget> widgetsDictionary = GetWidgetsDictionaryFromConfig(presentAreaID);
            ViewData["widgetsDictionary"] = widgetsDictionary;
            ViewData["presentAreaID"] = presentAreaID;
            return View("Pages/Settings/ManageWidgets.aspx", "Masters/Settings.master", list);
        }

        /// <summary>
        /// 将Widget加入到数据库
        /// </summary>
        public ActionResult CreateWidget(int presentAreaID, string widgetID)
        {
            if (Widgets.GetWidget(widgetID, true) != null)
            {
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Error, "数据库已存在该Widget");
            }
            else
            {
                Widget widget = GetWidgetFromConfig(presentAreaID, widgetID);
                Widgets.CreateWidget(widget);
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "将Widget加入到数据库操作已成功");
            }
            return RedirectToAction("ManageWidgets", new RouteValueDictionary { { "presentAreaID", presentAreaID } });
        }
        /// <summary>
        /// 批量将Widget加入到数据库
        /// </summary>
        public ActionResult CreateWidgets(int presentAreaID)
        {
            Dictionary<string, Widget> widgets = GetWidgetsDictionaryFromConfig(presentAreaID);
            foreach (var pair in widgets)
            {
                if (Widgets.GetWidget(pair.Key, true) == null)
                    Widgets.CreateWidget(pair.Value);
            }
            TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "批量将Widget更新到数据库操作已成功");
            return RedirectToAction("ManageWidgets", new RouteValueDictionary { { "presentAreaID", presentAreaID } });
        }
        /// <summary>
        /// 将Widget更新到数据库
        /// </summary>
        public ActionResult UpdateWidget(int presentAreaID, string widgetID)
        {
            if (Widgets.GetWidget(widgetID, true) == null)
            {
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Error, "数据库不存在该Widget");
            }
            else
            {
                Widget widget = GetWidgetFromConfig(presentAreaID, widgetID);
                Widgets.UpdateWidget(widget);
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "将Widget更新到数据库操作已成功");
            }
            return RedirectToAction("ManageWidgets", new RouteValueDictionary { { "presentAreaID", presentAreaID } });
        }
        /// <summary>
        /// 批量将Widget更新到数据库
        /// </summary>
        public ActionResult UpdateWidgets(int presentAreaID)
        {
            Dictionary<string, Widget> widgets = GetWidgetsDictionaryFromConfig(presentAreaID);
            foreach (var pair in widgets)
            {
                if (Widgets.GetWidget(pair.Key, true) != null)
                    Widgets.UpdateWidget(pair.Value);
            }
            TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "批量将Widget更新到数据库操作已成功");
            return RedirectToAction("ManageWidgets", new RouteValueDictionary { { "presentAreaID", presentAreaID } });
        }


        /// <summary>
        /// 将Widget从数据库中删除
        /// </summary>
        public ActionResult DeleteWidget(int presentAreaID, string widgetID)
        {
            Widgets.DeleteWidget(widgetID);
            TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "将Widget从数据库中删除操作已成功");
            return RedirectToAction("ManageWidgets", new RouteValueDictionary { { "presentAreaID", presentAreaID } });
        }


        /// <summary>
        /// 获取配置文件中的Widgets集合
        /// </summary>
        private Dictionary<string, Widget> GetWidgetsDictionaryFromConfig(int? presentAreaID)
        {
            Dictionary<string, Widget> dictionary = new Dictionary<string, Widget>();
            DirectoryInfo dirAllWidgets = new DirectoryInfo(GetWidgetDirectoryPath(presentAreaID));
            Widget widget = null;
            foreach (FileInfo widgetFile in dirAllWidgets.GetFiles("*.xml", SearchOption.TopDirectoryOnly))
            {
                XElement moudleElement = XElement.Load(widgetFile.FullName);
                if (moudleElement != null)
                {
                    widget = new Widget(moudleElement);
                    dictionary[widget.WidgetID.ToLower()] = widget;
                }
            }
            return dictionary;
        }
        /// <summary>
        /// 根据WidgetID获取配置文件中的Widget
        /// </summary>
        private Widget GetWidgetFromConfig(int? presentAreaID, string widgetID)
        {
            Widget widget = null;
            string dPath = GetWidgetDirectoryPath(presentAreaID);
            DirectoryInfo dirAllWidgets = new DirectoryInfo(dPath);
            foreach (FileInfo widgetFile in dirAllWidgets.GetFiles())
            {
                XElement moudleElement = XElement.Load(widgetFile.FullName);
                if (moudleElement != null)
                {
                    XElement modulePrefs = moudleElement.Descendants("modulePrefs").First();
                    if (modulePrefs != null && modulePrefs.Attribute("id") != null && modulePrefs.Attribute("id").Value == widgetID)
                    {
                        widget = new Widget(moudleElement);
                        return widget;
                    }
                }
            }
            throw new Exception(string.Format("{0}路径下不存在widgetID为{1}的Widget", dPath, widgetID));
        }

        private string GetWidgetDirectoryPath(int? presentAreaID)
        {
            PresentArea presentArea = PresentAreas.GetPresentArea(presentAreaID ?? PresentAreaIDs.Instance().Channel(), true);
            string dPath = WebUtils.GetPhysicalFilePath(presentArea.WidgetLocation, true);
            if (!Directory.Exists(dPath))
                throw new Exception(string.Format("文件路径{0}不存在", dPath));
            return dPath;
        }

        #endregion

        #region 皮肤管理

        /// <summary>
        /// 设置皮肤
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ManageThemes(int? presentAreaID)
        {
            IList<Theme> list = Themes.GetThemes(presentAreaID ?? PresentAreaIDs.Instance().Channel(), false, true);
            Dictionary<string, Theme> themesDictionary = new Dictionary<string, Theme>();
            Dictionary<string, Dictionary<string, ThemeAppearance>> themeAppearancesDictionary = new Dictionary<string, Dictionary<string, ThemeAppearance>>();
            DirectoryInfo dirAllThemes = new DirectoryInfo(GetThemeDirectoryPath(presentAreaID ?? PresentAreaIDs.Instance().Channel()));
            Theme theme = null;
            foreach (DirectoryInfo themeDirectory in dirAllThemes.GetDirectories())
            {
                XElement moudleElement = XElement.Load(Path.Combine(themeDirectory.FullName, "Theme.config"));
                if (moudleElement != null)
                {
                    theme = new Theme(presentAreaID ?? PresentAreaIDs.Instance().Channel(), themeDirectory.Name, moudleElement);
                    themesDictionary[theme.DirectoryName.ToLower()] = theme;
                    XElement appearancesElement = moudleElement.Element("appearances");

                    Dictionary<string, ThemeAppearance> themeAppearances = new Dictionary<string, ThemeAppearance>();
                    IEnumerable<XElement> appearanceElements = appearancesElement.Elements("appearance");
                    foreach (XElement appearanceElement in appearanceElements)
                    {
                        ThemeAppearance themeAppearance = new ThemeAppearance(presentAreaID ?? PresentAreaIDs.Instance().Channel(), theme.DirectoryName, appearanceElement);
                        themeAppearances[themeAppearance.DirectoryName.ToLower()] = themeAppearance;
                    }
                    themeAppearancesDictionary[theme.DirectoryName.ToLower()] = themeAppearances;
                }
            }
            presentAreaID = presentAreaID ?? PresentAreaIDs.Instance().Channel();
            PresentArea presentArea = PresentAreas.GetPresentArea(presentAreaID.Value, true);
            if (presentArea == null)
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_PresentAreaNotFound"), presentAreaID)));

            ViewData["themesDictionary"] = themesDictionary;
            ViewData["themeAppearancesDictionary"] = themeAppearancesDictionary;
            ViewData["presentAreaID"] = presentAreaID;
            ViewData["defaultTheme"] = presentArea.DefaultTheme;
            ViewData["defaultThemeAppearence"] = presentArea.DefaultAppearance;
            return View("Pages/Settings/ManageThemes.aspx", "Masters/Settings.master", list);
        }

        private string GetThemeDirectoryPath(int presentAreaID)
        {
            PresentArea presentArea = PresentAreas.GetPresentArea(presentAreaID, true);
            string dPath = WebUtils.GetPhysicalFilePath(presentArea.ThemeLocation, true);
            if (!Directory.Exists(dPath))
                throw new Exception(string.Format("文件路径{0}不存在", dPath));
            return dPath;
        }
        /// <summary>
        /// 将主题导入数据库
        /// </summary>
        public ActionResult ImportTheme(int presentAreaID, string theme)
        {
            string path = Path.Combine(GetThemeDirectoryPath(presentAreaID), theme);
            path = Path.Combine(path, "Theme.config");
            XElement themeConfig = XElement.Load(path);
            Themes.ImportTheme(presentAreaID, theme, themeConfig);
            TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "将主题导入数据库操作已成功");
            return RedirectToAction("ManageThemes", new RouteValueDictionary { { "presentAreaID", presentAreaID } });
        }
        /// <summary>
        /// 将外观导入数据库
        /// </summary>
        public ActionResult ImportThemeAppearance(int presentAreaID, string theme, string appearanceDirectoryName)
        {
            string path = Path.Combine(GetThemeDirectoryPath(presentAreaID), theme);
            path = Path.Combine(path, "Theme.config");
            XElement themeConfig = XElement.Load(path);
            Themes.ImportThemeAppearance(presentAreaID, theme, appearanceDirectoryName, themeConfig);
            TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "将外观导入数据库操作已成功");
            return RedirectToAction("ManageThemes", new RouteValueDictionary { { "presentAreaID", presentAreaID } });
        }
        /// <summary>
        /// 启用/禁用 Theme
        /// </summary>
        public ActionResult SetThemeEnabled(int? presentAreaID, string theme, bool isEnabled)
        {
            Themes.SetThemeEnabled(presentAreaID ?? PresentAreaIDs.Instance().Channel(), theme, isEnabled);
            TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "更改主题启用状态操作已成功");
            return RedirectToAction("ManageThemes", new RouteValueDictionary { { "presentAreaID", presentAreaID } });
        }
        /// <summary>
        /// 启用/禁用 ThemeAppearance
        /// </summary>
        public ActionResult SetThemeAppearanceEnabled(int? presentAreaID, string theme, string appearanceDirectoryName, bool isEnabled)
        {
            Themes.SetThemeAppearanceEnabled(presentAreaID ?? PresentAreaIDs.Instance().Channel(), theme, appearanceDirectoryName, isEnabled);
            TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "更改外观启用状态操作已成功");
            return RedirectToAction("ManageThemes", new RouteValueDictionary { { "presentAreaID", presentAreaID } });
        }

        /// <summary>
        /// 删除主题
        /// </summary>
        public ActionResult DeleteTheme(int? presentAreaID, string theme)
        {
            Themes.DeleteTheme(presentAreaID ?? PresentAreaIDs.Instance().Channel(), theme);
            TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "删除主题操作已成功");
            return RedirectToAction("ManageThemes", new RouteValueDictionary { { "presentAreaID", presentAreaID } });
        }

        /// <summary>
        /// 删除外观
        /// </summary>
        public ActionResult DeleteThemeAppearance(int? presentAreaID, string theme, string appearanceDirectoryName)
        {
            Themes.DeleteThemeAppearance(presentAreaID ?? PresentAreaIDs.Instance().Channel(), theme, appearanceDirectoryName);
            TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, "删除主题操作已成功");
            return RedirectToAction("ManageThemes", new RouteValueDictionary { { "presentAreaID", presentAreaID } });
        }

        #endregion

        #region 任务执行报告

        /// <summary>
        /// 任务执行报告
        /// </summary>
        public ActionResult TasksReport()
        {
            SetPageTitle("任务执行报告");
            return View("Pages/Settings/TasksReport.aspx", "Masters/Settings.master", SpaceBuilder.Tasks.TaskControllerFactory.Instance.GetTaskController().GetAllTasks());
        }
        #endregion

        #region 手动执行任务

        /// <summary>
        /// 手动执行任务
        /// </summary>
        public ActionResult ExecuteReport(string taskName)
        {
            SetPageTitle("任务执行报告");
            SpaceBuilder.Tasks.ITaskController taskController = SpaceBuilder.Tasks.TaskControllerFactory.Instance.GetTaskController();
            SpaceBuilder.Tasks.TaskDetail task = taskController.GetTask(taskName);
            if (task != null)
            {
                taskController.ExecuteTask(taskName);
                StatusMessageData statusMessageData = new StatusMessageData(StatusMessageType.Success, taskName + " 任务执行成功");
                TempData["StatusMessageData"] = statusMessageData;
            }
            else
            {
                StatusMessageData statusMessageData = new StatusMessageData(StatusMessageType.Error, taskName + " 任务执行失败");
                TempData["StatusMessageData"] = statusMessageData;
            }
            return RedirectToAction("TasksReport");
        }

        #endregion

        #region 版本及授权信息
        /// <summary>
        /// 版本及授权信息
        /// </summary>
        /// <returns></returns>
        public ActionResult VersionReport()
        {
            SetPageTitle("版本及授权信息");
            return View("Pages/Settings/VersionReport.aspx", "Masters/Settings.master", TunyNetLicenseManager.Instance().LicenseCollection);
        }
        #endregion

        #region 重建索引
        /// <summary>
        /// 重建索引
        /// </summary>
        public ActionResult IndexsReport()
        {
            SetPageTitle("重建索引");

            List<IndexFileReport> indexFileReports = new List<IndexFileReport>();

            Dictionary<string, List<SearchTypeSettingsBase>> indexFileNameDictionary = SearchConfiguration.Instance().SearchTypeSettingss.IndexDictionary;
            foreach (string indexFileName in indexFileNameDictionary.Keys)
            {
                indexFileReports.Add(new IndexFileReport(indexFileName));
            }

            return View("Pages/Settings/IndexsReport.aspx", "Masters/Settings.master", indexFileReports);
        }

        /// <summary>
        /// 重建索引
        /// </summary>
        public ActionResult RebuildIndex(string indexFileDirectory)
        {
            string indexPath = Path.Combine(SearchConfiguration.Instance().GlobalIndexDirectory, indexFileDirectory);




            StatusMessageData statusMessageData = new StatusMessageData(StatusMessageType.Success, indexFileDirectory + " 索引重建成功");
            try
            {
                string indexTempPath = Path.Combine(indexPath, "temp");
                if (System.IO.Directory.Exists(indexTempPath))
                    System.IO.Directory.Delete(indexTempPath, true);

                List<SearchTypeSettingsBase> searchTypeSettingss = SearchConfiguration.Instance().SearchTypeSettingss.IndexDictionary[indexFileDirectory];
                foreach (SearchTypeSettingsBase searchTypeSettings in searchTypeSettingss)
                {
                    searchTypeSettings.InitializeIndex(indexTempPath);
                }

                string[] oldIndexFiles = System.IO.Directory.GetFiles(indexPath, "*.*");
                foreach (var oldIndexFile in oldIndexFiles)
                {
                    System.IO.File.Delete(oldIndexFile);
                }

                string[] newIndexFiles = System.IO.Directory.GetFiles(indexTempPath, "*.*");
                foreach (var newIndexFile in newIndexFiles)
                {
                    FileInfo newFile = new FileInfo(newIndexFile);

                    System.IO.File.Copy(newIndexFile, Path.Combine(indexPath, newFile.Name));
                }

                System.IO.Directory.Delete(indexTempPath, true);


                //List<SearchTypeSettingsBase> searchTypeSettingss = SearchConfiguration.Instance().SearchTypeSettingss.IndexDictionary[indexFileDirectory];
                //foreach (SearchTypeSettingsBase searchTypeSettings in searchTypeSettingss)
                //{
                //    searchTypeSettings.InitializeIndex(indexPath);
                //}
            }
            catch (Exception ex)
            {
                statusMessageData = new StatusMessageData(StatusMessageType.Error, indexFileDirectory + " 索引重建失败：" + ex.Message);
            }
            TempData["StatusMessageData"] = statusMessageData;
            return RedirectToAction("IndexsReport");
        }
        #endregion

        #region 清理缓存
        /// <summary>
        /// 清空相应缓存
        /// </summary>
        /// <param name="CacheManagerName"></param>
        /// <returns></returns>
        public ActionResult RemoveCache()
        {
            CacheRepository.Clear();

            return Redirect(Request.UrlReferrer.ToString());
        }
        #endregion

        #region 表现区域
        /// <summary>
        /// 表现区域管理
        /// </summary>        
        public ActionResult ManagePresentAreas()
        {
            SetPageTitle("表现区域管理");
            IList<PresentArea> presentAreaslist = PresentAreas.GetPresentAreasForAdmin();
            return View("Pages/Settings/ManagePresentAreas.aspx", "Masters/Settings.master", presentAreaslist);
        }

        public ActionResult Control_EditPresentArea(int presentAreaID)
        {
            PresentArea presentArea = PresentAreas.GetPresentArea(presentAreaID, true);
            IList<Theme> themes = Themes.GetThemes(presentAreaID, true, true);
            ViewData["themes"] = themes;
            IList<ThemeAppearance> appearances = Themes.GetThemeAppearancesOfTheme(presentAreaID, presentArea.DefaultTheme, true);
            ViewData["appearances"] = appearances;
            return PartialView("Controls/Settings/EditPresentArea.ascx", presentArea);
        }
        public ActionResult UpdatePresentArea(int presentAreaID)
        {
            PresentArea presentArea = PresentAreas.GetPresentArea(presentAreaID, true);
            presentArea.PresentAreaID = presentAreaID;
            presentArea.Name = Request.Form.GetString("Name", presentArea.Name);
            presentArea.Description = Request.Form.GetString("Description", presentArea.Description);
            presentArea.EnableThemes = Request.Form.GetBool("enableThemes", presentArea.EnableThemes);
            presentArea.DefaultTheme = Request.Form.GetString("theme", presentArea.DefaultTheme);
            presentArea.DefaultAppearance = Request.Form.GetString("appearance", presentArea.DefaultAppearance);
            presentArea.ThemeLocation = Request.Form.GetString("ThemeLocation", presentArea.ThemeLocation);
            presentArea.WidgetLocation = Request.Form.GetString("WidgetLocation", presentArea.WidgetLocation);
            PresentAreas.UpdatePresentArea(presentArea);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "更新表现区域成功";
            return RedirectToAction("Control_EditPresentArea", new RouteValueDictionary { { "presentAreaID", presentAreaID } });
        }

        /// <summary>
        /// 获取某表现区域某皮肤下的所有的外观
        /// </summary>
        public JsonResult GetThemeAppearances(int presentAreaID, string themeName)
        {
            IList<ThemeAppearance> appearances = Themes.GetThemeAppearancesOfTheme(presentAreaID, themeName, true);
            return Json(appearances.Select(n => new { name = n.Title, value = n.DirectoryName }), JsonRequestBehavior.AllowGet);

        }

        #endregion
    }

    public enum SystemSettingsSubMenu
    {
        /// <summary>
        /// 数据备份
        /// </summary>
        DataBackup = 1,
        /// <summary>
        /// 重建索引
        /// </summary>
        RebuildIndex = 2,
        /// <summary>
        /// 重启站点
        /// </summary>
        ResertStie = 3,
        /// <summary>
        /// 清理缓存
        /// </summary>
        CacheManager = 4,
        /// <summary>
        /// 任务执行报告
        /// </summary>
        TasksReport = 5,
        /// <summary>
        /// 清理过期数据
        /// </summary>
        SiteExpiredDataType = 6,
        /// <summary>
        /// 隐私设置
        /// </summary>
        PrivacySettings = 7,
        /// <summary>
        /// 通知设置
        /// </summary>
        NoticeSettings = 8,
        /// <summary>
        /// 动态设置
        /// </summary>
        ActivitySettings = 9,
        /// <summary>
        /// 积分设置
        /// </summary>
        PointSettings = 10,
        /// <summary>
        /// 权限设置
        /// </summary>
        PermissionSettings = 11,
        /// <summary>
        /// 审核设置
        /// </summary>
        AuditingSettings = 12,
        /// <summary>
        /// 站点信息
        /// </summary>
        SiteInfo = 13,
        /// <summary>
        /// 用户相关
        /// </summary>
        UserHolder = 14,
        /// <summary>
        /// 帖子相关
        /// </summary>
        PostHolder = 15,
        /// <summary>
        /// 水印设置
        /// </summary>
        WatermarkSetting = 16,
        /// <summary>
        /// 邮件设置
        /// </summary>
        EmailSetting = 17,

        /// <summary>
        /// 导航管理
        /// </summary>
        ManageNavigations = 18,
        /// <summary>
        /// 应用管理
        /// </summary>
        ManageApplications = 19,
        /// <summary>
        /// 皮肤管理
        /// </summary>
        ManageThemes = 20,

        /// <summary>
        /// Widget管理
        /// </summary>
        ManageWidgets = 21,

        /// <summary>
        /// 地区管理
        /// </summary>
        ManageAreas = 22,

        /// <summary>
        /// 学校管理
        /// </summary>
        ManageSchools = 23,
        /// <summary>
        /// 语言管理
        /// </summary>
        ManageLanguage = 24,

        /// <summary>
        /// 数据字典管理
        /// </summary>
        ManageDataDictionary = 25,
        /// <summary>
        /// 广告管理
        /// </summary>
        ManageAdvertisings = 26,
        /// <summary>
        /// 友情链接管理
        /// </summary>
        ManageSiteLinks = 27,
        /// <summary>
        /// OpenSocial管理
        /// </summary>
        ManageOpenSocial = 28,
        /// <summary>
        /// 积分兑换管理
        /// </summary>
        ManagerConvertibleGift = 29,
        /// <summary>
        /// 表现区域设置
        /// </summary>
        ManagePresentAreas = 30,
        /// <summary>
        /// License授权信息
        /// </summary>
        LicenseInformation = 31,

        /// <summary>
        /// 暂停设置
        /// </summary>
        SitePauseSetting = 32,

        /// <summary>
        /// 系统积分
        /// </summary>
        SystemPoint = 33,
        /// <summary>
        /// 审核设置
        /// </summary>
        AuditingSettings1 = 34,

    }

    public enum SystemSettingMenu
    {
        /// <summary>
        /// 管理工具
        /// </summary>
        ManageTool = 1,
        /// <summary>
        /// 管理规则
        /// </summary>
        ManageRule = 2,
        /// <summary>
        /// 站点设置
        /// </summary>
        SiteSetting = 3,
        /// <summary>
        /// 界面相关
        /// </summary>
        AboutInterFace = 4,
        /// <summary>
        /// 基础服务
        /// </summary>
        BaseServers = 5



    }

    /// <summary>
    /// 站点过期数据类型
    /// </summary>
    public enum SiteExpiredDataType
    {
        /// <summary>
        /// 访客记录
        /// </summary>
        UserVisit = 1,
        /// <summary>
        /// 个人动态
        /// </summary>
        UserActivity = 2,
        /// <summary>
        /// 朋友动态
        /// </summary>
        FriendActivity = 3,
        /// <summary>
        /// 私信
        /// </summary>
        PrivateMessage = 4,
        /// <summary>
        /// 用户积分记录
        /// </summary>
        UserPointRecord = 5,
        /// <summary>
        /// 用户留言
        /// </summary>
        UserGuestbookPost = 6
    }
}
