﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using System.Collections;
using System.IO;
using System.Xml;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using SpaceBuilder.Club;
using SpaceBuilder.Web;
using System.Web.Routing;
using SpaceBuilder.LuceneSearch;
using System.Web.UI;

namespace SpaceBuilder.Common.Controllers
{
    /// <summary>
    /// 空间中公用控件和方法
    /// </summary>
    [HttpCompress]
    public partial class UserDomainController : UserDomainControllerBase
    {

        private int applicationID = ApplicationIDs.Instance().User();

        /// <summary>
        /// 空间主页
        /// </summary>
        [UserVisitAndUserDomainHitTime]
        [UserDomainPrivacy(IsAuthentication = true)]
        public ActionResult Home(string userDomainName)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);

            SiteSettings setting = SiteSettingsManager.GetSiteSettingsForAdmin();

            #region 设置Title
            SetPageTitle(userDomainName, string.Empty);
            #endregion
            if (IsUserDomainOwner(userDomainName) && currentDomainUser.UserType == UserTypes.PersonUser)
            {
                PersonUser pu = currentDomainUser as PersonUser;

                if (pu != null && GetIsEnterWizardForever(currentDomainUser.UserID) && pu.ProfileIntegrity < SiteSettingsManager.GetSiteSettings().EnterWizardModeValue && GetIsEnterWizardToday(currentDomainUser.UserID))
                    return Redirect(SiteUrls.Instance().EnterWizardMode(userDomainName));
                ViewData["isShow"] = true;
                return View("Pages/MyHome.aspx");
            }
            return View("Pages/Home.aspx");
        }

        /// <summary>
        /// 获取用户设置的以后是否还需要进入向导模式
        /// </summary>
        private bool GetIsEnterWizardForever(int userID)
        {
            string cookieName = "IsEnterWizardForeverCookie_" + userID + SiteSettingsManager.GetSiteSettings().EnterWizardModeValue;
            string IsEnterWizardForeverValue = string.Empty;
            if (Request.Cookies[cookieName] != null)
                IsEnterWizardForeverValue = HttpContext.Request.Cookies[cookieName].Value;
            if (string.IsNullOrEmpty(IsEnterWizardForeverValue))
                return true;
            return Convert.ToBoolean(IsEnterWizardForeverValue);
        }

        /// <summary>
        /// 获取今天是否还需要进入向导模式
        /// </summary>
        private bool GetIsEnterWizardToday(int userID)
        {
            string cookieName = "IsEnterWizardTodayCookie_" + userID;
            string IsEnterWizardTodayValue = string.Empty;
            if (Request.Cookies[cookieName] != null)
                IsEnterWizardTodayValue = Request.Cookies[cookieName].Value;
            if (string.IsNullOrEmpty(IsEnterWizardTodayValue))
                return true;
            return Convert.ToBoolean(IsEnterWizardTodayValue);
        }

        /// <summary>
        /// 个人用户看自己空间主页时，使用的地址
        /// </summary>
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult Master(string userDomainName)
        {
            #region 设置Title
            SetPageTitle(userDomainName, string.Empty);
            #endregion

            ViewData["isShow"] = true;
            return View("Pages/Home.aspx");
        }



        #region PersonUser

        #region  页面

        /// <summary>
        /// 提示隐私信息页
        /// </summary>
        [UserVisitAndUserDomainHitTime]
        public ActionResult PrivacyHome(string userDomainName)
        {
            #region 设置Title
            SetPageTitle(userDomainName);
            #endregion

            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            if (CurrentUser != null && (HasManagePermission(userDomainName)
            || currentDomainUser.UserType == UserTypes.CompanyUser
            || Privacys.Validate(currentDomainUser.UserID, CurrentUser, PrivacyItemKeys.Instance().UserDomainPrivacy())))
                return RedirectToAction("Home", new RouteValueDictionary { { "userDomainName", userDomainName } });

            return View("Pages/PrivacyHome.aspx");
        }


        #endregion

        #region 控件
        /// <summary>
        /// 显示用户头像以及相关信息
        /// </summary>
        /// <param name="userDomainName">用户名</param>
        public ActionResult Control_PersonAction(string userDomainName)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            ViewData["currentUser"] = CurrentUser;
            if (CurrentUser != null && Privacys.IsStopedUser(CurrentUser.UserID, currentDomainUser.UserID, false))
                ViewData["isStopedUser"] = true;
            return PartialView("Controls/PersonUsers/PersonAction.ascx", currentDomainUser);
        }

        /// <summary>
        /// 显示用户相关统计信息
        /// </summary>
        /// <param name="userDomainName">用户名</param>
        public ActionResult Control_PersonStaticsBlock(string userDomainName)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);

            IntegratedPointRule basicPointRule = Points.GetIntegratedPointRule(IntegratedPointItemIDs.Instance().User_BasicPoint());
            IntegratedPointRule reportPointRule = Points.GetIntegratedPointRule(IntegratedPointItemIDs.Instance().User_ReportPoint());
            ViewData["TotalPoints"] = currentDomainUser.BasicPoints * basicPointRule.ScoringRate + currentDomainUser.ReportPoints * reportPointRule.ScoringRate;

            IList<Application> installedApplications = Applications.GetInstalledApplicationsOfOwner(PresentAreaIDs.Instance().UserDomain(), currentDomainUser.UserID);
            Dictionary<int, Application> applications = Applications.GetApplications();
            ViewData["InstalledApplications"] = installedApplications;
            ViewData["applications"] = applications;
            return PartialView("Controls/PersonUsers/PersonStatisticsBlock.ascx", currentDomainUser);
        }

        /// <summary>
        /// 个人资料
        /// </summary>
        /// <param name="userDomainName">用户名</param>
        [AcceptVerbs(HttpVerbs.Get)]
        [UserDomainPrivacy(IsAuthentication = true)]
        public ActionResult ShowProfile(string userDomainName)
        {
            PersonUser userToEdit = GetCurrentDomainUser(userDomainName) as PersonUser;

            ViewData["currentUser"] = CurrentUser;
            ViewData["EnableNickName"] = SiteSettingsManager.GetSiteSettings().EnableNickName;
            if (CurrentUser != null && (IsUserDomainOwner(userDomainName) || CurrentUser.IsContentAdministrator))
                ViewData["isOwnerOrAdministrator"] = true;
            ViewData["EnableNickName"] = SiteSettingsManager.GetSiteSettings().EnableNickName;
            return View("Pages/Profile.aspx", userToEdit);
        }

        /// <summary>
        ///空间友情链接 
        /// </summary>
        /// <param name="userDomainName">用户名</param>
        /// <returns></returns>
        public ActionResult Control_ShowLinks(string userDomainName)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);

            UserLinkManager userLinkManage = UserLinkManager.Instance();
            List<Link> links = userLinkManage.GetLinks(currentDomainUser.UserID, null, null, HasManagePermission(currentDomainUser));

            List<LinkCategory> linkCategories = userLinkManage.GetLinkCategoriesByOwnerID(currentDomainUser.UserID, HasManagePermission(currentDomainUser));

            ViewData["LinkCategories"] = linkCategories;
            return PartialView("Controls/UserDomainLinks.ascx", links);
        }

        /// <summary>
        ///空间网址 
        /// </summary>
        /// <param name="userDomainName">用户名</param>
        public ActionResult Control_UserFriendlyUrl(string userDomainName)
        {
            return PartialView("Controls/PersonUsers/UserFriendlyUrl.ascx");
        }

        /// <summary>
        ///个人简介 
        /// </summary>
        /// <param name="userDomainName">用户名</param>
        public ActionResult Control_SelfAppraisal(string userDomainName)
        {
            return PartialView("/Controls/PersonUsers/SelfAppraisal.ascx");
        }

        #endregion

        #endregion

        #region CompanyUser
        /// <summary>
        /// 公司介绍
        /// </summary>
        [UserVisitAndUserDomainHitTime]
        public ActionResult AboutCompany(string userDomainName)
        {
            SetPageTitle(userDomainName, GetResourceString("Title_CompanyIntroduction", applicationID));
            CompanyUser companyUser = GetCurrentDomainUser(userDomainName) as CompanyUser;
            return View("Pages/AboutCompany.aspx", companyUser);
        }

        public ActionResult ShowCompanyContactProFile(string userDomainName)
        {
            CompanyUser companyUser = GetCurrentDomainUser(userDomainName) as CompanyUser;
            return PartialView("Controls/ShowContactProfile.ascx", companyUser);
        }


        #endregion

        #region service

        /// <summary>
        /// 更新用户空间标题及描述
        /// </summary>
        /// <remarks>供jquery.jeditable使用</remarks>
        /// <param name="userDomainName">空间主人用户名</param>
        public ActionResult Service_UpdateUserDomainTitleAndDescription(string userDomainName, bool isUpdateTitle)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            string resultString = string.Empty;
            if (CurrentUser != null && (currentDomainUser != null && (CurrentUser.UserID == currentDomainUser.UserID || CurrentUser.IsContentAdministrator)))
            {
                if (isUpdateTitle)
                {
                    currentDomainUser.UserDomainTitle = Request.Form.GetString("userDomainTitle", currentDomainUser.UserDomainTitle);
                    currentDomainUser.UserDomainTitle = StringUtils.Trim(currentDomainUser.UserDomainTitle, 20);
                    if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                        currentDomainUser.UserDomainTitle = Censors.CensorPost(currentDomainUser.UserDomainTitle);

                    currentDomainUser.UserDomainTitle = WebUtils.HtmlEncode(currentDomainUser.UserDomainTitle);

                    resultString = currentDomainUser.UserDomainTitle;
                }

                Users.UpdateUser(currentDomainUser);
            }

            //返回最新更新的UserDomainTitle
            ContentResult result = new ContentResult();
            result.Content = resultString;
            return result;
        }

        #endregion

        #region 阻止用户
        /// <summary>
        /// 新加一个阻止用户
        /// </summary>
        public ActionResult CreateStopedUser(int userID, int toUserID)
        {
            bool isSuccess = false;
            User toUser = Users.GetUser(toUserID, false);
            User user = Users.GetUser(userID, false);
            if (user != null && toUser != null)
            {
                StopedUser stopedUser = new StopedUser();
                stopedUser.UserID = userID;
                stopedUser.ToUserID = toUserID;
                stopedUser.ToUserDisplayName = toUser.DisplayName;
                Privacys.CreateStopedUser(stopedUser);
                isSuccess = true;
            }
            return Json(isSuccess, JsonRequestBehavior.AllowGet);
        }
        /// <summary>
        /// 删除一个阻止用户
        /// </summary>
        public JsonResult DeleteStopedUser(int userID, int toUserID)
        {
            bool isSuccess = false;
            if (userID > 0 && toUserID > 0)
            {
                Privacys.DeleteStopedUser(userID, toUserID);
                if (!Privacys.IsStopedUser(userID, toUserID, true))
                    isSuccess = true;
            }
            return Json(isSuccess, JsonRequestBehavior.AllowGet);
        }
        #endregion

        #region 用户标签

        #region Show

        /// <summary>
        /// 管理用户标签
        /// </summary>
        /// <param name="userDomainName">空间用户名</param>
        /// <param name="userTagItemKey">使用用户标签服务的对象唯一标识</param>
        /// <param name="TagNameUrlPattern">列表中标签名的链接格式</param>
        [AcceptVerbs(HttpVerbs.Get)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        [OutputCache(Location = OutputCacheLocation.None)]
        public ActionResult Control_ManageUserTags(string userDomainName, string userTagItemKey, string tagNameUrlPattern)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            ICollection<UserTag> userTags = UserTagManager.Instance(userTagItemKey).GetUserTags(currentDomainUser.UserID, true);
            ViewData["userTagItemKey"] = userTagItemKey;
            ViewData["tagNameUrlPattern"] = tagNameUrlPattern;
            return PartialView("Controls/Common/UserTag/ManageUserTags.ascx", userTags);
        }

        /// <summary>
        /// 显示新建或编辑用户标签模式框
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult Control_EditUserTag(string userDomainName, string userTagItemKey)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);

            ViewData["userTagItemKey"] = userTagItemKey;
            return PartialView("Controls/Common/UserTag/EditUserTag.ascx");
        }

        #endregion

        #region Manage

        /// <summary>
        /// 更新标签
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult CreateUserTag(string userDomainName, string userTagItemKey)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);

            UserTag userTag = null;

            string[] formattedTagNames = Request.Form["tagName"].Split(UserTagManager.SplitCharacters, StringSplitOptions.RemoveEmptyEntries);
            string errorTagNames = string.Empty;
            if (formattedTagNames != null && formattedTagNames.Length > 0)
            {
                foreach (string formattedTagName in formattedTagNames)
                {
                    if (!string.IsNullOrEmpty(formattedTagName))
                    {
                        userTag = new UserTag();
                        userTag.UserID = currentDomainUser.UserID;
                        userTag.TagName = HtmlUtils.TrimHtml(formattedTagName, 8).Trim();
                        userTag.TagName = Formatter.CleanTagName(userTag.TagName);
                        userTag.TagName = Formatter.FormatSingleLinePlainTextForStorage(userTag.TagName);

                        UserTagManager.Instance(userTagItemKey).CreateUserTag(userTag);
                        TempData["statusMessageData"] = new StatusMessageData(StatusMessageType.Success, GetResourceString("Message_CreateTagSucceed", applicationID));
                    }
                    else
                        errorTagNames += formattedTagName + ",";
                }
            }
            if (!string.IsNullOrEmpty(errorTagNames))
                TempData["statusMessageData"] = new StatusMessageData(StatusMessageType.Error, string.Format("标签{0}创建失败！", errorTagNames));
            TempData["errorTagNames"] = errorTagNames;
            return RedirectToAction("Control_EditUserTag", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userTagItemKey", userTagItemKey } });
        }

        /// <summary>
        /// 删除标签用户
        /// </summary>
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult DeleteUserTag(string userDomainName, string userTagItemKey, string tagName)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            UserTag userTag = UserTagManager.Instance(userTagItemKey).GetUserTag(tagName, currentDomainUser.UserID, true);
            if (userTag == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_UserTagNotExist", applicationID), tagName)));
            }
            ValidateItemOwner(userTag.UserID);

            UserTagManager.Instance(userTagItemKey).DeleteUserTag(tagName, currentDomainUser.UserID);
            return RedirectToAction("Control_ManageUserTags", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userTagItemKey", userTagItemKey } });
        }

        #endregion

        #endregion

        #region 用户分类
        /// <summary>
        /// 管理分类控件
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        [OutputCache(Location = OutputCacheLocation.None)]
        public ActionResult Control_ManageUserCategories(string userDomainName, string userCategoryItemKey, string categoryNameUrlPattern)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            List<UserCategory> userCategoryList = UserCategoryManager.Instance(userCategoryItemKey).GetUserCategories(currentDomainUser.UserID, true);
            ViewData["userCategoryItemKey"] = userCategoryItemKey;
            ViewData["categoryNameUrlPattern"] = categoryNameUrlPattern;
            return PartialView("Controls/Common/UserCategory/ManageUserCategories.ascx", userCategoryList);
        }

        /// <summary>
        /// 显示编辑用户分类模式框
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult Control_EditUserCategory(string userDomainName, string userCategoryItemKey, int? categoryID)
        {
            UserCategory UserCategory = new UserCategory();
            if (categoryID.HasValue && categoryID.Value > 0)
            {
                UserCategory = UserCategoryManager.Instance(userCategoryItemKey).GetUserCategory(categoryID.Value, true);
                ValidateItemOwner(UserCategory.UserID);
                TempData["selectedCategoryID"] = categoryID.Value;
            }
            ViewData["userCategoryItemKey"] = userCategoryItemKey;
            ViewData["categoryID"] = categoryID;
            return PartialView("Controls/Common/UserCategory/EditUserCatgory.ascx", UserCategory);
        }

        /// <summary>
        /// 创建更新用户分类
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult CreateUpdateUserCategory(string userDomainName, string userCategoryItemKey, int? categoryID)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);

            UserCategory userCategory = new UserCategory();
            if (categoryID != null && (int)categoryID > 0)
            {
                userCategory = UserCategoryManager.Instance(userCategoryItemKey).GetUserCategory(categoryID.Value, true);
            }
            else
            {
                userCategory.UserID = currentDomainUser.UserID;
            }
            userCategory.CategoryName = Request.Form.GetString("categoryName", string.Empty).Trim();
            userCategory.CategoryName = HtmlUtils.TrimHtml(userCategory.CategoryName, 20);
            userCategory.CategoryName = Formatter.FormatSingleLinePlainTextForStorage(userCategory.CategoryName);
            if (string.IsNullOrEmpty(userCategory.CategoryName))
            {
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Error, GetResourceString("Message_UserCategoryNameRequired", applicationID));
            }
            else
            {
                userCategory.Description = Request.Form.GetString("description", string.Empty);
                userCategory.Description = HtmlUtils.TrimHtml(userCategory.Description, 100);
                userCategory.Description = Formatter.FormatMultiLinePlainTextForStorage(userCategory.Description, true);
                userCategory.DisplayOrder = Request.Form.GetInt("displayOrder", 0);

                if (categoryID.HasValue && (int)categoryID > 0)
                {
                    ValidateItemOwner(userCategory.UserID);
                    UserCategoryManager.Instance(userCategoryItemKey).UpdateUserCategory(userCategory);
                    TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, GetResourceString("Message_UpdateUserCategorySucceed", applicationID));
                }
                else
                {
                    UserCategoryManager.Instance(userCategoryItemKey).CreateUserCategory(userCategory);
                    TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, GetResourceString("Message_CreateUserCategorySucceed", applicationID));
                }
            }
            return RedirectToAction("Control_EditUserCategory", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userCategoryItemKey", userCategoryItemKey }, { "categoryID", userCategory.CategoryID } });
        }

        /// <summary>
        /// 删除用户分类
        /// </summary>
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult DeleteUserCategory(string userDomainName, string userCategoryItemKey, int categoryID)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            UserCategory UserCategory = UserCategoryManager.Instance(userCategoryItemKey).GetUserCategory(categoryID, true);
            if (UserCategory == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_UserCategoryNotExist", applicationID), categoryID)));
            }
            ValidateItemOwner(UserCategory.UserID);
            UserCategoryManager.Instance(userCategoryItemKey).DeleteUserCategory(categoryID, currentDomainUser.UserID);
            TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, GetResourceString("Message_DeleteUserCategorySucceed", applicationID));
            return RedirectToAction("Control_ManageUserCategories", new RouteValueDictionary { { "userDomainName", userDomainName }, { "userCategoryItemKey", userCategoryItemKey } });
        }

        #endregion

        #region 用户分组
        /// <summary>
        /// 管理分组控件
        /// </summary>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Get)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        [OutputCache(Location = OutputCacheLocation.None)]
        public ActionResult Control_ManageGroups(string userDomainName, string multiUserCategoryItemKey)
        {
            User domainUser = GetCurrentDomainUser(userDomainName);
            List<UserCategory> list = MultiUserCategoryManager.Instance(multiUserCategoryItemKey).GetUserCategories(domainUser.UserID, true);
            ViewData["multiUserCategoryItemKey"] = multiUserCategoryItemKey;
            return PartialView("Controls/Common/MultiUserCategory/ManageGroups.ascx", list);
        }

        /// <summary>
        /// 编辑分组
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult Control_EditGroup(string userDomainName, string multiUserCategoryItemKey, int? categoryID)
        {
            UserCategory userCategory = new UserCategory();
            if (categoryID.HasValue && categoryID.Value > 0)
            {
                userCategory = MultiUserCategoryManager.Instance(multiUserCategoryItemKey).GetUserCategory(categoryID.Value, true);
                ValidateItemOwner(userCategory.UserID);
            }
            ViewData["multiUserCategoryItemKey"] = multiUserCategoryItemKey;
            return PartialView("Controls/Common/MultiUserCategory/EditGroup.ascx", userCategory);
        }

        /// <summary>
        /// 删除分组
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult DeleteGroup(string userDomainName, string multiUserCategoryItemKey, int categoryID)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            UserCategory userCategory = MultiUserCategoryManager.Instance(multiUserCategoryItemKey).GetUserCategory(categoryID, true);
            if (userCategory != null)
            {
                ValidateItemOwner(userCategory.UserID);
                MultiUserCategoryManager.Instance(multiUserCategoryItemKey).DeleteUserCategory(categoryID, CurrentUser.UserID);
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, GetResourceString("Message_DeleteUserCategorySucceedForFriend", applicationID));
            }
            //TODO;这里不应该用Friend Job下也会用到这个控件

            return Redirect(Request.UrlReferrer.AbsoluteUri);

            //if (multiUserCategoryItemKey == "FavoriteResume,311")
            //    return RedirectToAction("ManageFavoriteResumeUserCategories", "UserDomainJob", new RouteValueDictionary { { "userDomainName", userDomainName } });
            //else
            //    return RedirectToAction("ManageGroups", "Friend", new RouteValueDictionary { { "userDomainName", userDomainName } });
        }

        /// <summary>
        /// 创建更新分组
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        [UserDomainAuthorize(RequireOwnerOrAdministrator = true)]
        public ActionResult CreateUpdateGroup(string userDomainName, string multiUserCategoryItemKey, int? categoryID)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            UserCategory userCategory = null;
            if (categoryID.HasValue && (int)categoryID > 0)
            {
                userCategory = MultiUserCategoryManager.Instance(multiUserCategoryItemKey).GetUserCategory(categoryID.Value, true);
                ValidateItemOwner(userCategory.UserID);
            }
            else
            {
                userCategory = new UserCategory();
                userCategory.UserID = currentDomainUser.UserID;
            }
            userCategory.CategoryName = Request.Form.GetString("groupName", string.Empty).Trim();
            userCategory.Description = Request.Form.GetString("groupDescription", string.Empty).Trim();
            userCategory.CategoryName = Formatter.FormatSingleLinePlainTextForStorage(userCategory.CategoryName);
            userCategory.Description = Formatter.FormatMultiLinePlainTextForStorage(userCategory.Description, true);
            userCategory.DisplayOrder = Request.Form.GetInt("groupOrder", 0);

            if (categoryID.HasValue && categoryID.Value > 0)
            {
                MultiUserCategoryManager.Instance(multiUserCategoryItemKey).UpdateUserCategory(userCategory);
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, GetResourceString("Message_UpdateUserCategorySucceedForFriend", applicationID));
            }
            else
            {
                MultiUserCategoryManager.Instance(multiUserCategoryItemKey).CreateUserCategory(userCategory);
                TempData["StatusMessageData"] = new StatusMessageData(StatusMessageType.Success, GetResourceString("Message_CreateUserCategorySucceedForFriend", applicationID));
            }
            return RedirectToAction("Control_EditGroup", new RouteValueDictionary { { "userDomainName", userDomainName }, { "multiUserCategoryItemKey", multiUserCategoryItemKey }, { "categoryID", userCategory.CategoryID } });
        }



        #endregion


    }
}
