﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common.Mail;
using SpaceBuilder.Utils;

namespace SpaceBuilder.Common
{
    /// <summary>
    /// Email通知业务逻辑类
    /// </summary>
    public class EmailNoticeProcessor : INoticeProcessor
    {
        #region INoticeProcessor 成员

        public void ProcessNotice(NoticeRecord record)
        {
            User toUser = Users.GetUser(record.UserID, false);
            if (toUser == null )
                return;
            if (!toUser.IsEmailVerified)
                return;
            if (IsAllowedUseEmailNotice(record.UserID, record.NoticeItemID))
            {
                EmailTemplate emailTemplate = EmailTemplates.GetNoticeEmailTemplate(record.NoticeItemKey, toUser);
                if (emailTemplate == null)
                    return;

                emailTemplate.AddTo(toUser.PrivateEmail);

                List<EmailTextToken> tokens = GetEmailTextTokens(record);
                tokens.Add(new EmailTextToken("NotifySettingUrl", WebUtils.FullPath(SiteUrls.Instance().UserNoticeSettings(toUser.UserName))));
                emailTemplate.ProcessTokens(tokens);
                Emails.EnqueuEmail(EmailTemplates.ConvertEmailTemplateToMailMessage(emailTemplate));
            }
        }

        #endregion

        #region Help Methods

        /// <summary>
        /// 是否允许使用Email发送通知
        /// </summary>
        /// <param name="itemID">itemID</param>        
        public bool IsAllowedUseEmailNotice(int userID, int itemID)
        {
            Dictionary<int, NoticeItem> noticeItems = NoticeSettingsManager.GetUserNoticeSettings(NoticeWayCodes.Instance().Email(), userID, false);
            return noticeItems.ContainsKey(itemID);
        }

        private static List<EmailTextToken> GetEmailTextTokens(NoticeRecord record)
        {
            List<EmailTextToken> tokens = new List<EmailTextToken>();
            tokens.AddRange(EmailHelper.GetCommonFields());
            tokens.Add(new EmailTextToken("Receiver", record.Receiver));
            tokens.Add(new EmailTextToken("RelativeItemName", record.RelativeItemName));
            tokens.Add(new EmailTextToken("RelativeItemUrl", WebUtils.FullPath(record.RelativeItemUrl)));
            tokens.Add(new EmailTextToken("LeadingActor", record.LeadingActor));
            tokens.Add(new EmailTextToken("LeadingActorUrl", WebUtils.FullPath(record.LeadingActorUrl)));
            tokens.Add(new EmailTextToken("DateCreated", DateTime.Now.ToString("f")));
            tokens.Add(new EmailTextToken("Body", WebUtils.FormatCompleteUrl(record.Body)));
            tokens.Add(new EmailTextToken("ProcessUrl", WebUtils.FullPath(record.ProcessUrl)));
            return tokens;
        }

        #endregion


    }
}
