//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections;
using System.Text.RegularExpressions;


using System.Text;
using System.Globalization;

using System.Collections.Generic;
using SpaceBuilder.Utils;

using System.Collections.Specialized;

namespace SpaceBuilder.Common
{
    /// <summary>
    /// ʽ
    /// </summary>
    public static class Formatter
    {


        #region Url

        /// <summary>
        /// ȷurlhttp
        /// </summary>
        public static string EnsureHttpForUrl(string url)
        {
            if (url.ToLower().StartsWith("http"))
                return url;
            else
                return "http://" + url;
        }

        /// <summary>
        /// ַеĳתURL
        /// </summary>
        /// <remarks>
        /// ܶWYSWIGY HtmlEditorԶָվurlתɲurl
        /// 磺http://www.spacebuilder.cn/default.aspx ת /default.aspx
        /// Ҫڱ浽ǰת
        /// </remarks>
        public static string ConvertLocalUrls(string body, string host)
        {
            if (!host.EndsWith("/"))
                host += "/";

            body = Regex.Replace(body, "href=\"/", "href=\"" + host, RegexOptions.IgnoreCase);
            body = Regex.Replace(body, "src=\"/", "src=\"" + host, RegexOptions.IgnoreCase);
            return body;
        }

        #endregion


        #region Transforms

        /// <summary>
        /// 洢дıʱʽ
        /// </summary>
        /// <remarks>
        /// 1HtmlEncode
        /// 2Censor
        /// </remarks>
        /// <param name="subject"></param>
        /// <returns></returns>
        public static string FormatSingleLinePlainTextForStorage(string plainText)
        {
            if (string.IsNullOrEmpty(plainText))
                return plainText;
            string newPlainText = plainText.Replace("&quot;", "\"");
            newPlainText = WebUtils.HtmlEncode(newPlainText);
            newPlainText = Censors.CensorPost(newPlainText);
            return newPlainText;
        }

        /// <summary>
        /// ༭дıʱʽ
        /// </summary>
        /// <remarks>
        /// 1HtmlDecode
        /// </remarks>
        /// <param name="subject"></param>
        /// <returns></returns>
        public static string FormatSingleLinePlainTextForEdit(string plainText)
        {
            if (string.IsNullOrEmpty(plainText))
                return plainText;
            string newPlainText = WebUtils.HtmlDecode(plainText);
            newPlainText = newPlainText.Replace("\"", "&quot;");
            return newPlainText;
        }

        /// <summary>
        /// дıתΪHTMLʾ 
        /// </summary>
        /// <remarks>
        /// һڴ洢ݿ֮ǰת
        /// </remarks>
        /// <param name="plainText">ҪתĴı</param>
        /// <param name="keepWhiteSpace">Ƿո</param>
        public static string FormatMultiLinePlainTextForStorage(string plainText, bool keepWhiteSpace)
        {
            return FormatMultiLinePlainTextForStorage(plainText, keepWhiteSpace, true);
        }
        /// <summary>
        /// дıתΪHTMLʾ 
        /// </summary>
        /// <remarks>
        /// һڴ洢ݿ֮ǰת
        /// </remarks>
        /// <param name="plainText">ҪתĴı</param>
        /// <param name="keepWhiteSpace">Ƿո</param>
        /// <param name="censorPost">Ƿд</param>
        public static string FormatMultiLinePlainTextForStorage(string plainText, bool keepWhiteSpace, bool censorPost)
        {
            if (string.IsNullOrEmpty(plainText))
                return plainText;

            plainText = WebUtils.HtmlEncode(plainText);

            if (keepWhiteSpace)
            {
                plainText = plainText.Replace(" ", "&nbsp;");
                plainText = plainText.Replace("\t", "&nbsp;&nbsp;");
            }
            plainText = plainText.Replace("\r\n", WebUtils.HtmlNewLine);
            plainText = plainText.Replace("\n", WebUtils.HtmlNewLine);

            if (censorPost && SiteSettingsManager.GetSiteSettings().EnableCensorship)
            {
                //˵д
                plainText = Censors.CensorPost(plainText);
            }

            #region ֹSQL עʽ
            plainText = plainText.Replace("'", "&acute;");
            plainText = plainText.Replace("--", "&ndash;&ndash;");
            #endregion

            return plainText;
        }

        /// <summary>
        /// дıתΪTextAreaʾ 
        /// </summary>
        /// <remarks>
        /// һڽб༭ǰת
        /// </remarks>
        /// <param name="plainText">ҪתĴı</param>
        /// <param name="keepWhiteSpace">Ƿո</param>
        public static string FormatMultiLinePlainTextForEdit(string plainText, bool keepWhiteSpace)
        {
            if (string.IsNullOrEmpty(plainText))
                return plainText;

            string result = plainText;
            result = result.Replace(WebUtils.HtmlNewLine, "\n");
            //result = result.Replace("<br/>", "\n");
            if (keepWhiteSpace)
                result = result.Replace("&nbsp;", " ");

            result = WebUtils.HtmlDecode(result);

            #region ֹSQL עʽ
            result = result.Replace("&acute;", "'");
            result = result.Replace("&ndash;&ndash;", "--");
            #endregion

            return result;
        }

        /// <summary>
        /// ʽı
        /// </summary>
        /// <remarks>
        /// ²
        /// 1дʹ
        /// 2nofollow
        /// 3мոĸʽ
        /// </remarks>
        /// <param name="text">ʽ</param>
        /// <param name="enableNoFollow">Should we include the nofollow rel.</param>
        /// <param name="enableConversionToParagraphs">Should newlines be converted to P tags.</param>
        public static string FormatPlainTextComment(string text)
        {
            return FormatPlainTextComment(text, true, true);
        }

        /// <summary>
        /// ʽ
        /// </summary>
        /// <param name="text">ʽ</param>
        /// <param name="enableNoFollow">Should we include the nofollow rel.</param>
        /// <param name="enableConversionToParagraphs">Should newlines be converted to P tags.</param>
        private static string FormatPlainTextComment(string text, bool enableNoFollow, bool enableConversionToParagraphs)
        {
            if (string.IsNullOrEmpty(text))
                return text;

            text = WebUtils.HtmlEncode(text);

            if (enableNoFollow)
            {
                //Find any links
                StringCollection uniqueMatches = new StringCollection();

                string pattern = @"(http|ftp|https):\/\/[\w]+(.[\w]+)([\w\-\.,@?^=%&amp;:/~\+#]*[\w\-\@?^=%&amp;/~\+#])";
                MatchCollection matches = Regex.Matches(text, pattern, RegexOptions.IgnoreCase | RegexOptions.Compiled);

                foreach (Match m in matches)
                {
                    if (!uniqueMatches.Contains(m.ToString()))
                    {
                        text = text.Replace(m.ToString(), "<a rel=\"nofollow\" target=\"_new\" href=\"" + m + "\">" + m.ToString().Trim() + "</a>");
                        uniqueMatches.Add(m.ToString());
                    }
                }
            }

            // Replace Line breaks with <br> and every other concurrent space with &nbsp; (to allow line breaking)
            if (enableConversionToParagraphs)
                text = ConvertPlainTextToParagraph(text);// text.Replace("\n", "<br />");

            text = text.Replace("  ", " &nbsp;");

            if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
            {
                //˵д
                text = Censors.CensorPost(text);
            }

            return text;
        }


        /// <summary>
        /// Ѵָʽhtml
        /// </summary>
        /// <remarks>
        /// ʹıHtmlбеĸʽ
        /// </remarks>
        private static string ConvertPlainTextToParagraph(string text)
        {
            if (string.IsNullOrEmpty(text))
                return text;

            //text = text.Replace("<p>", string.Empty);
            //text = text.Replace("</p>", "\n");

            text = text.Replace("\r\n", "\n").Replace("\r", "\n");

            string[] lines = text.Split('\n');

            StringBuilder paragraphs = new StringBuilder();

            foreach (string line in lines)
            {
                if (line != null && line.Trim().Length > 0)
                    paragraphs.AppendFormat("{0}<br />\n", line);
            }
            return paragraphs.ToString().Remove(paragraphs.ToString().LastIndexOf("<br />"));
        }

        #endregion



        #region Format Date

        ///<overloads>ʽ</overloads>
        /// <summary>
        /// ʽ
        /// </summary>
        /// <remarks>ʾʱ</remarks>
        /// <param name="date">DateTime</param>
        /// <returns>ʽַ</returns>
        public static string FormatDate(DateTime date)
        {
            return FormatDate(date, false);
        }

        /// <summary>
        /// ʽ
        /// </summary>
        /// <param name="date">DateTime</param>
        /// <param name="showTime">Ƿʾʱ</param>
        /// <returns>ʽַ</returns>
        public static string FormatDate(DateTime date, bool showTime)
        {
            if (date == DateTime.MinValue)
                return ResourceManager.GetString("Common_NumberWhenZero", Globals.GetCurrentUserLanguage());
            User currentUser = Globals.GetCurrentUser();
            date = GetUserDate(date, currentUser);
            string dateFormat = ResourceManager.GetString("Common_DefaultDateFormat", Globals.GetCurrentUserLanguage());
            if (string.IsNullOrEmpty(dateFormat))
                dateFormat = SiteSettingsManager.GetSiteSettings().DateFormat;

            if (showTime)
                return date.ToString(dateFormat + " " + ResourceManager.GetString("Common_DefaultTimeFormat", Globals.GetCurrentUserLanguage()));
            else
                return date.ToString(dateFormat);
        }

        public static string FormatFriendlyDate(DateTime date)
        {
            return FormatFriendlyDate(date, true);
        }

        /// <summary>
        /// תûʱʱ
        /// </summary>
        /// <param name="date">תʱ</param>
        private static DateTime GetUserDate(DateTime date, User user)
        {
            if (user == null)
                return date.AddHours(SiteSettingsManager.GetSiteSettings().SiteTimezone - SiteSettingsManager.GetSiteSettings().ServerTimezone);

            return date.AddHours(user.Timezone - SiteSettingsManager.GetSiteSettings().ServerTimezone);
        }

        /// <summary>
        /// ڸʽѺõʾʽ(磺,,2Сʱǰ)
        /// </summary>
        /// <param name="date">DateTime</param>
        /// <returns>ʽַ</returns>
        public static string FormatFriendlyDate(DateTime date, bool isShowTime)
        {
            if (date == DateTime.MinValue)
                return ResourceManager.GetString("Common_NumberWhenZero", Globals.GetCurrentUserLanguage());

            string returnItem;
            string dateFormat;
            DateTime userLocalTime;
            User currentUser = Globals.GetCurrentUser();


            date = GetUserDate(date, currentUser);
            userLocalTime = GetUserDate(DateTime.Now, currentUser);
            string timeFormat = ResourceManager.GetString("Common_DefaultTimeFormat", Globals.GetCurrentUserLanguage());
            if (currentUser != null && currentUser.UserID > 0)
            {
                dateFormat = currentUser.DateFormat;
            }
            else
            {
                dateFormat = SiteSettingsManager.GetSiteSettings().DateFormat;
            }

            // little error checking
            //
            if (date < DateTime.Now.AddYears(-20))
                return ResourceManager.GetString("Common_NumberWhenZero", Globals.GetCurrentUserLanguage());

            // make Today and Yesterday bold for now...
            //
            if ((date.DayOfYear == userLocalTime.DayOfYear) && (date.Year == userLocalTime.Year))
            {
                returnItem = ResourceManager.GetString("Common_TodayAt", Globals.GetCurrentUserLanguage());
                returnItem += ((DateTime)date).ToString(timeFormat);
            }
            else if ((date.DayOfYear == (userLocalTime.DayOfYear - 1)) && (date.Year == userLocalTime.Year))
            {
                returnItem = ResourceManager.GetString("Common_YesterdayAt", Globals.GetCurrentUserLanguage());
                returnItem += ((DateTime)date).ToString(timeFormat);
            }
            else
            {
                returnItem = date.ToString(dateFormat);
                if (isShowTime)
                    returnItem += (", " + ((DateTime)date).ToString(timeFormat));
            }
            return returnItem;
        }

        /// <summary>
        /// ʱתΪڵʱ
        /// </summary>
        public static string FormatDateToIntervalTime(DateTime date)
        {
            if (date == DateTime.MinValue)
                return ResourceManager.GetString("Common_NumberWhenZero", Globals.GetCurrentUserLanguage());

            string returnItem;
            string dateFormat;
            DateTime userLocalTime;
            User currentUser = Globals.GetCurrentUser();

            date = GetUserDate(date, currentUser);
            userLocalTime = GetUserDate(DateTime.Now, currentUser);

            if (currentUser != null && currentUser.UserID > 0)
            {
                dateFormat = currentUser.DateFormat;
            }
            else
            {
                dateFormat = SiteSettingsManager.GetSiteSettings().DateFormat;
            }

            // little error checking
            //
            if (date < DateTime.Now.AddYears(-20))
                return ResourceManager.GetString("Common_NumberWhenZero", Globals.GetCurrentUserLanguage());

            TimeSpan nowDate = new TimeSpan(userLocalTime.Ticks);
            TimeSpan comDate = new TimeSpan(date.Ticks);
            TimeSpan intervalTime = nowDate.Subtract(comDate).Duration();

            if (intervalTime.Days < 356)
            {
                if (intervalTime.Days < 30)
                {
                    if (intervalTime.Days < 7)
                    {
                        if (intervalTime.Days < 1)
                        {
                            if (intervalTime.Hours < 1)
                            {
                                if (intervalTime.Minutes < 1)
                                {
                                    if (intervalTime.Seconds < 1)
                                        returnItem = ResourceManager.GetString("Common_Now", Globals.GetCurrentUserLanguage());
                                    else
                                        returnItem = string.Format(ResourceManager.GetString("Common_Pattern_SecondsAgo", Globals.GetCurrentUserLanguage()), intervalTime.Seconds);
                                }
                                else
                                    returnItem = string.Format(ResourceManager.GetString("Common_Pattern_MinutelAgo", Globals.GetCurrentUserLanguage()), intervalTime.Minutes);
                            }
                            else
                                returnItem = string.Format(ResourceManager.GetString("Common_Pattern_HoursAgo", Globals.GetCurrentUserLanguage()), intervalTime.Hours);
                        }
                        else if (intervalTime.Days == 1)
                            returnItem = ResourceManager.GetString("Common_YesterdayAt", Globals.GetCurrentUserLanguage());
                        else if (intervalTime.Days == 2)
                            returnItem = ResourceManager.GetString("Common_BeforeYesterday", Globals.GetCurrentUserLanguage());
                        else
                            returnItem = string.Format(ResourceManager.GetString("Common_Pattern_DayAgo", Globals.GetCurrentUserLanguage()), intervalTime.Days);
                    }
                    else
                        returnItem = string.Format(ResourceManager.GetString("Common_Pattern_WeeksAgo", Globals.GetCurrentUserLanguage()), Convert.ToInt32((intervalTime.Days) / 7));
                }
                else
                    returnItem = string.Format(ResourceManager.GetString("Common_Pattern_MonthsAgo", Globals.GetCurrentUserLanguage()), Convert.ToInt32((intervalTime.Days) / 30));
            }
            else
                returnItem = string.Format(ResourceManager.GetString("Common_Pattern_YearAgo", Globals.GetCurrentUserLanguage()), userLocalTime.Year - date.Year);

            return returnItem;
        }

        #endregion


        #region Format number

        ///<overloads>ʽ</overloads>
        /// <summary>
        /// ʽ
        /// </summary>
        /// <param name="number">ʽ</param>
        /// <returns>ָʽַ</returns>
        public static string FormatNumber(int number)
        {
            return FormatNumber(number, ResourceManager.GetString("Common_NumberFormat", Globals.GetCurrentUserLanguage()), ResourceManager.GetString("Common_NumberWhenZero", Globals.GetCurrentUserLanguage()));
        }

        /// <summary>
        /// ʽ
        /// </summary>
        /// <param name="number">ʽ</param>
        /// <param name="whenZero">0ʱصַ</param>
        /// <returns>ָʽַ</returns>
        public static string FormatNumber(int number, string whenZero)
        {
            return FormatNumber(number, ResourceManager.GetString("Common_NumberFormat", Globals.GetCurrentUserLanguage()), whenZero);
        }

        /// <summary>
        /// ʽ
        /// </summary>
        /// <param name="number">ʽ</param>
        /// <param name="format">ָʽʽ</param>
        /// <param name="whenZero">0ʱصַ</param>
        /// <returns>ָʽַ</returns>
        public static string FormatNumber(int number, string format, string whenZero)
        {
            if (number == 0)
                return whenZero;
            else
                return number.ToString(format);
        }
        #endregion


        #region Format File Size

        /// <summary>
        /// ѺõļСϢ
        /// </summary>
        /// <param name="fileSize">ļֽ</param>
        public static string FormatFriendlyFileSize(double fileSize)
        {
            if (fileSize > 0)
            {
                if (fileSize > 1024 * 1024)
                    return string.Format("{0:F2}M", (fileSize / (1024 * 1024F)));
                else
                    return string.Format("{0:F2}K", (fileSize / 1024F));
            }
            else
                return string.Empty;
        }

        #endregion


        #region Format User ban reason

        /// <summary>
        /// ʽûԭ
        /// </summary>
        /// <param name="banReason"></param>
        public static string FormatBanReason(UserBanReasons banReason)
        {
            return ResourceManager.GetString("Utility_UserBanReason_" + banReason.ToString());
        }

        #endregion


        #region Format Area

        /// <summary>
        /// ʽ
        /// </summary>
        /// <remarks>Depth()0ʼ</remarks>
        /// <param name="areaCode">areaCode</param>
        /// <param name="minDepth">ʾĵС</param>
        /// <param name="maxDepth">ʾʾ</param>
        public static string FormatArea(string areaCode, int minDepth, int maxDepth)
        {
            if (string.IsNullOrEmpty(areaCode))
                return string.Empty;

            string strArea = string.Empty;

            Area area = Areas.GetArea(areaCode, false);
            if (area != null)
            {
                if ((string.IsNullOrEmpty(area.ParentCode)) || (maxDepth < 0))
                    strArea = area.GetMultilingualAreaName(Globals.GetCurrentUserLanguage());
                else
                {
                    Stack<string> areaNames = new Stack<string>();

                    if (area.Depth >= minDepth && area.Depth <= maxDepth)
                        areaNames.Push(area.GetMultilingualAreaName(Globals.GetCurrentUserLanguage()));

                    Area parentArea = Areas.GetArea(area.ParentCode, false);
                    while (parentArea != null)
                    {
                        if (parentArea.Depth >= minDepth && parentArea.Depth <= maxDepth)
                            areaNames.Push(parentArea.GetMultilingualAreaName(Globals.GetCurrentUserLanguage()));

                        parentArea = Areas.GetArea(parentArea.ParentCode, false);
                    }

                    while (areaNames.Count > 0)
                    {
                        if (areaNames.Count == 1)
                            strArea += areaNames.Pop();
                        else
                            strArea += areaNames.Pop() + ",";
                    }
                }
            }

            return strArea;
        }


        /// <summary>
        /// ʽ
        /// </summary>
        /// <param name="areaCode">areaCode</param>
        ///<param name="showAll">Ƿʾи</param>
        public static string FormatArea(string areaCode, bool showAll)
        {
            if (string.IsNullOrEmpty(areaCode))
                return string.Empty;

            string strArea = string.Empty;

            Area area = Areas.GetArea(areaCode, false);
            if (area != null)
            {
                if ((string.IsNullOrEmpty(area.ParentCode)) || (!showAll))
                    strArea = area.GetMultilingualAreaName(Globals.GetCurrentUserLanguage());
                else
                {
                    string rootAreaCode = UserDomainConfiguration.Instance().RootAreaCode;
                    Stack<string> areaNames = new Stack<string>();

                    areaNames.Push(area.GetMultilingualAreaName(Globals.GetCurrentUserLanguage()));

                    Area parentArea = Areas.GetArea(area.ParentCode, false);
                    while (parentArea != null && parentArea.AreaCode != rootAreaCode)
                    {
                        areaNames.Push(parentArea.GetMultilingualAreaName(Globals.GetCurrentUserLanguage()));
                        parentArea = Areas.GetArea(parentArea.ParentCode, false);
                    }

                    while (areaNames.Count > 0)
                    {
                        if (areaNames.Count == 1)
                            strArea += areaNames.Pop();
                        else
                            strArea += areaNames.Pop() + ",";
                    }
                }
            }

            return strArea;
        }

        #endregion


        #region Tag

        /// <summary>
        /// ǩеķǷִ
        /// </summary>
        public static string CleanTagName(string appKey)
        {
            //Remark:20090808_zhengw ɾUrlпɱַ'#','&','=','/','%','?','+', '$',
            string[] parts = appKey.Split('!', '.', '@', '^', '*', '(', ')', '[', ']', '{', '}', '<', '>', ',', '\\', '\'', '~', '`', '|');
            appKey = string.Join("", parts);
            return appKey;
        }

        #endregion


        //==================´뵱ǰδʹ=================================

        #region IrcCommand

        ///// <summary>
        ///// 
        ///// </summary>
        ///// <param name="postText"></param>
        ///// <param name="postFrom"></param>
        ///// <returns></returns>
        //public static string FormatIrcCommands(string postText, string postFrom)
        //{
        //    return FormatIrcCommands(postText, postFrom, "");
        //}

        ///// <summary>
        ///// 
        ///// </summary>
        ///// <param name="postText"></param>
        ///// <param name="postFrom"></param>
        ///// <param name="postTo"></param>
        ///// <returns></returns>
        //public static string FormatIrcCommands(string postText, string postFrom, string postTo)
        //{
        //    // /me slaps Terry with a big-mouth trout.
        //    //
        //    postText = Regex.Replace(postText, @"(>/me\b|\n>/me)(.*?|\n)(<|\n|<\n)", "><span class=\"txtIrcMe\">&nbsp;*&nbsp;" + postFrom + "$2</span><", RegexOptions.IgnoreCase | RegexOptions.Compiled);
        //    postText = Regex.Replace(postText, @"(\n/me\b)(.*?|\n)(\n)", "<span class=\"txtIrcMe\">&nbsp;*&nbsp;" + postFrom + "$2</span>", RegexOptions.IgnoreCase | RegexOptions.Compiled);

        //    return postText;
        //}

        #endregion


        #region UserRank

        //public static string FormatUserRank(Int32 postCount, bool showAsPicture)
        //{
        //    ArrayList ranks = Ranks.GetRanks();
        //    return FormatUserRank(postCount, showAsPicture, ranks);
        //}

        //public static string FormatUserRank(Int32 postCount, bool showAsPicture, ArrayList ranks)
        //{
        //    string imageFolderPath = "/App_Themes/Default/Images/RankIcons/";
        //    string rankName = "";
        //    string rankUrlPicture = "";
        //    string imgHtmlTag = "<img src=\"{0}\" border=\"0\" alt=\"{1}\">";

        //    if (ranks == null)
        //        return ResourceManager.GetString("Utility_UserRank_NotAvailable");

        //    foreach (Rank rank in ranks)
        //    {
        //        if (postCount >= rank.PostingCountMinimum &&
        //            postCount <= rank.PostingCountMaximum)
        //        {

        //            rankName = rank.RankName.Trim();
        //            rankUrlPicture = rank.RankIconUrl.Trim();
        //            break;
        //        }
        //    }

        //    // Exit if there is an empty rank name
        //    //
        //    if (rankName.Length == 0)
        //    {
        //        return ResourceManager.GetString("Utility_UserRank_NotAvailable");
        //    }

        //    // Do we need to display a pictured rank?
        //    //
        //    if (showAsPicture && rankUrlPicture.Length > 0)
        //    {
        //        string pictureUrl = imageFolderPath + rankUrlPicture;

        //        // TODO: Check for picture availability ?!
        //        //

        //        return string.Format(imgHtmlTag, pictureUrl, rankName);
        //    }

        //    return rankName;
        //}

        #endregion

        #region User
        /// <summary>
        /// ȡûĶʾ
        /// <remarks >userΪnullû</remarks>
        /// </summary>
        public static string UserDisplayName(User user)
        {
            if (user != null)
                return user.DisplayName;
            return ResourceManager.GetString("Common_AnonymousDisplayName", Globals.GetCurrentUserLanguage());
        }
        #endregion


    }

}
