//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections;
using System.Collections.Specialized;
using System.Configuration;
using System.Web;
using System.Globalization;
using System.Text.RegularExpressions;
using System.IO;
using SpaceBuilder.Utils;
using System.Collections.Generic;

namespace SpaceBuilder.Common
{
    /// <summary>
    /// ʹõһЩ
    /// </summary>
    public class Globals
    {

        #region URL

        /// <summary>
        /// ȡվurl
        /// </summary>
        /// <remarks>֧~/</remarks>
        /// <param name="url"></param>
        /// <returns></returns>
        public static string GetFullUrlInMainSite(string url)
        {
            //SPBConfig.Instance().MainSiteRootUrl,ԶΪգֻܱһַ磺www.abc.com,abc.com,ֻܱһһʣcookie֤
            string mainSiteRootUrl = SPBConfig.Instance().MainSiteRootUrl;
            if (string.IsNullOrEmpty(mainSiteRootUrl))
                return WebUtils.FullPath(WebUtils.ResolveUrl(url));
            else
                return mainSiteRootUrl + WebUtils.ResolveUrl(url);
        }

        /// <summary>
        /// ȡԴվ(css/js/image)url
        /// </summary>
        /// <remarks>֧~/</remarks>
        /// <param name="url"></param>
        /// <returns></returns>
        public static string GetFullUrlInResourceSite(string url)
        {
            string resourceSiteRootUrl = SPBConfig.Instance().ResourceSiteRootUrl;
            if (string.IsNullOrEmpty(resourceSiteRootUrl) || url.ToLower().StartsWith("http"))
                return WebUtils.FullPath(WebUtils.ResolveUrl(url));
            else
                return resourceSiteRootUrl + WebUtils.ResolveUrl(url);
        }

        /// <summary>
        /// ȡļվurl
        /// </summary>
        /// <remarks>֧~/</remarks>
        /// <param name="url"></param>
        /// <returns></returns>
        public static string GetFullUrlInFileHandlerSite(string fileStorageProviderName, string url)
        {
            FileStorageProvider storageProvider = FileStorageProvider.Instance(fileStorageProviderName);
            if (storageProvider != null && !string.IsNullOrEmpty(storageProvider.FileHandlerRootUrl))
                return storageProvider.FileHandlerRootUrl + WebUtils.ResolveUrl(url);

            return WebUtils.FullPath(WebUtils.ResolveUrl(url));
        }



        #endregion


        #region û֤

        ///// <summary>
        ///// ֤ǷApplicationKey
        ///// </summary>
        ///// <param name="appKey">ַ֤</param>
        ///// <param name="formattedKey">ʽַ</param>
        ///// <returns>Ƿ֤ͨ</returns>
        //public static bool ValidateApplicationKey(string appKey, out string formattedKey)
        //{
        //    //formattedKey = appKey.Trim().Replace(" ", "_").ToLower();
        //    formattedKey = appKey.Trim().Replace(" ", "_");

        //    //Should we remove these items? Or just encode them. We can change this logic 
        //    string[] parts = formattedKey.Split('!','.', '@', '#', '$', '%', '^', '&', '*', '(', ')', '[', ']', '{', '}', '<', '>', ',', '?', '\\', '/', '\'', '+', '=', '~', '`', '|');
        //    formattedKey = string.Join("", parts);
        //    formattedKey = WebUtils.UrlEncode(formattedKey);

        //    return formattedKey == appKey;
        //}

        /// <summary>
        /// ֤û
        /// </summary>
        /// <param name="userName">֤û</param>
        /// <param name="errorMessage">Ϣ</param>
        /// <returns>Ƿ֤ͨ</returns>
        public static bool ValidateUserName(string userName, out string errorMessage)
        {
            if (string.IsNullOrEmpty(userName))
            {
                errorMessage = ResourceManager.GetString("Validate_UserNameRequired", Globals.GetCurrentUserLanguage(), ApplicationIDs.Instance().User());
                return false;
            }

            SiteSettings settings = SiteSettingsManager.GetSiteSettings();
            if (userName.Length < settings.UserNameMinLength)
            {
                errorMessage = string.Format(ResourceManager.GetString("Validate_Pattern_UserNameMinLengthViolated", Globals.GetCurrentUserLanguage()), settings.UserNameMinLength);
                return false;
            }
            if (userName.Length > settings.UserNameMaxLength)
            {
                errorMessage = string.Format(ResourceManager.GetString("Validate_Pattern_UserNameMaxLengthViolated", Globals.GetCurrentUserLanguage()), settings.UserNameMaxLength);
                return false;
            }
            Regex regex = new Regex(settings.UserNameRegex);
            if (!regex.IsMatch(userName))
            {
                errorMessage = ResourceManager.GetString("Validate_UserNameRegexViolated", Globals.GetCurrentUserLanguage());
                return false;
            }

            if (GetCurrentUser() != null && !GetCurrentUser().IsAdministrator)
            {
                //֤UserNameǷ񱻽ֹʹ
                if (Users.UserNameIsDisallowed(userName) == true)
                {
                    errorMessage = ResourceManager.GetString("Validate_UserNameIsDisallowedViolated");
                    return false;
                }
            }
            //֤UserNameǷѾ
            User user = Users.GetUser(userName, true);
            if (user != null)
            {
                errorMessage = ResourceManager.GetString("Validate_UserNameIsExistingViolated");
                return false;
            }
            errorMessage = string.Empty;
            return true;
        }

        /// <summary>
        /// ֤
        /// </summary>
        /// <param name="email">֤</param>
        /// <param name="errorMessage">Ϣ</param>
        /// <returns>Ƿ֤ͨ</returns>
        public static bool ValidateEmail(string email, out string errorMessage)
        {
            if (string.IsNullOrEmpty(email))
            {
                errorMessage = ResourceManager.GetString("Validate_PrivateEmailRequired", Globals.GetCurrentUserLanguage(), ApplicationIDs.Instance().User());
                return false;
            }

            SiteSettings settings = SiteSettingsManager.GetSiteSettings();

            Regex regex = new Regex(settings.EmailRegex, RegexOptions.ECMAScript);
            if (!regex.IsMatch(email))
            {//"ʽȷ";
                errorMessage = ResourceManager.GetString("Validate_PrivateEmailStyle", Globals.GetCurrentUserLanguage(), ApplicationIDs.Instance().User());
                return false;
            }

            if (string.IsNullOrEmpty(email))
            {
                errorMessage = ResourceManager.GetString("Validate_PrivateEmailRequired", Globals.GetCurrentUserLanguage(), ApplicationIDs.Instance().User());
                return false;
            }
            User user = Users.FindUserByEmail(email);

            if (GetCurrentUser() != null && !GetCurrentUser().IsAdministrator && user != null)
            {
                //֤emailǷ񱻽ֹʹ
                if (Users.UserNameIsDisallowed(user.UserName) == true)
                {
                    errorMessage = ResourceManager.GetString("Validate_UserNameIsDisallowedViolated");
                    return false;
                }
            }
            //֤emailǷѾ
            if (user != null)
            {
                errorMessage = string.Format(ResourceManager.GetString("Message_Pattern_RegisterFailedForDuplicateEmailAddress", Globals.GetCurrentUserLanguage(), ApplicationIDs.Instance().User()), SiteUrls.Instance().ForgotPassword());
                return false;
            }
            errorMessage = string.Empty;
            return true;
        }

        /// <summary>
        /// ûǷʺվ
        /// </summary>
        /// <param name="newPassword">Password to be verified.</param>
        /// <param name="errorMessage">Error message to return.</param>
        /// <returns>True if compliant, otherwise False.</returns>
        public static bool ValidatePassword(string newPassword, out string errorMessage)
        {

            SiteSettings settings = SiteSettingsManager.GetSiteSettings();
            int minRequiredPasswordLength = settings.PasswordMinLength;
            int minRequiredNonAlphanumericCharacters = settings.MinRequiredNonAlphanumericCharacters;

            errorMessage = "";

            if (string.IsNullOrEmpty(newPassword))
            {
                errorMessage = ResourceManager.GetString("Validate_RequiredPasswordViolated", Globals.GetCurrentUserLanguage());
                return false;
            }

            if (newPassword.Length < minRequiredPasswordLength)
            {
                errorMessage = string.Format(ResourceManager.GetString("Validate_Pattern_MinRequiredPasswordLengthViolated", Globals.GetCurrentUserLanguage()), minRequiredPasswordLength);
                return false;
            }

            int nonAlphaNumChars = 0;
            for (int i = 0; i < newPassword.Length; i++)
            {
                if (!char.IsLetterOrDigit(newPassword, i))
                    nonAlphaNumChars++;
            }
            if (nonAlphaNumChars < minRequiredNonAlphanumericCharacters)
            {
                errorMessage = string.Format(ResourceManager.GetString("Validate_Pattern_MinRequiredNonAlphanumericCharactersViolated", Globals.GetCurrentUserLanguage()), minRequiredNonAlphanumericCharacters);
                return false;
            }

            Regex regex = new Regex(settings.PasswordRegex);
            if (!regex.IsMatch(newPassword))
            {
                errorMessage = ResourceManager.GetString("Validate_PasswordRegexViolated");
                return false;
            }
            return true;
        }

        #endregion

        /// <summary>
        /// cookieлȡɵ֤
        /// </summary>
        public static string GetVerifyCodeFromCookie(HttpContextBase context)
        {
            string cookieName = SiteSettingsManager.GetSiteSettings().VerifyCodeCookieName;
            HttpCookie coookie = context.Request.Cookies[cookieName];
            HttpCookie coookieLevel = context.Request.Cookies[cookieName + "_CurrentLevel"];

            string verifyCode = null;

            if (coookie != null)
            {
                if (!string.IsNullOrEmpty(coookie.Value))
                {
                    try
                    {
                        //verifyCode = EncryptManager.DecryptTokenForVerifyCode(coookie.Value);

                        //ֱʹcookieʧЧ
                        //if (context.Response.Cookies[cookieName] != null)
                        //    context.Response.Cookies[cookieName].Expires = DateTime.Now.AddDays(-1d);
                        //else
                        //{
                        //    HttpCookie coookieForResponse = new HttpCookie(cookieName);
                        //    coookieForResponse.Expires = DateTime.Now.AddDays(-1d);

                        //    context.Response.Cookies.Add(coookieForResponse);
                        //}

                        //verifyCode = VerificationCodeManager.GetCachedTextAndForceExpire(context, coookie.Value.Substring(0, coookie.Value.IndexOf(":")));
                        verifyCode = VerificationCodeManager.GetCachedTextAndForceExpire(context, coookie.Value + (coookieLevel == null ? "" : ":" + coookieLevel.Value));

                    }
                    catch { }
                }
            }

            //cookieδȡ֤ʱṩһ
            if (verifyCode == null)
                verifyCode = DateTime.UtcNow.Ticks.ToString();

            return verifyCode;

        }

        /// <summary>
        /// ȡǰû(ûδ¼򷵻û)
        /// </summary>
        public static User GetCurrentUser()
        {
            HttpContext httpContext = HttpContext.Current;
            if (httpContext == null)
                return null;

            if (httpContext.User.Identity.IsAuthenticated)
            {
                User user = Users.GetUser(httpContext.User.Identity.Name, false, true);

                //ܴվ֤Ʊ
                if (user == null)
                {
                    System.Web.Security.FormsAuthentication.SignOut();
                    user = null;
                }
                return user;
            }
            else
            {
                return null;
            }
        }
        /// <summary>
        /// ȡǰû
        /// ûcookieȡ
        /// </summary>
        public static string GetCurrentUserLanguage()
        {
            User currentUser = GetCurrentUser();
            if (currentUser == null)
            {
                HttpContext httpContext = HttpContext.Current;
                if (httpContext != null)
                {
                    UserCookie userCookie = new UserCookie(currentUser, httpContext);
                    if (!string.IsNullOrEmpty(userCookie.GetLanguageCode()))
                        return userCookie.GetLanguageCode();
                }
                return SiteSettingsManager.GetSiteSettings().DefaultLanguage;
            }
            return currentUser.Language;
        }

        /// <summary>
        /// 鷢ʱ
        /// </summary>
        public static void CheckPostDate()
        {
            User currentUser = GetCurrentUser();
            if (currentUser == null)
                return;
            SiteSettings settings = SiteSettingsManager.GetSiteSettings();
            if (settings.EnableCheckPostDate)
            {
                TimeSpan interval = DateTime.Now.Subtract(currentUser.LastPostedTime);
                if (interval.TotalSeconds <= settings.MinPostDateInterval)
                    throw new SPBException(ExceptionTypes.Instance().FloodDenied());
                else
                {
                    currentUser.LastPostedTime = DateTime.Now;
                }
            }
        }

        /// <summary>
        /// ǲǺϷ
        /// </summary>
        /// <remarks>
        /// ڷļ
        /// </remarks>
        /// <returns></returns>
        public static bool IsAllowableReferrer(HttpRequest httpRequest)
        {
            if (httpRequest == null || httpRequest.UrlReferrer == null)
                return false;

            string urlReferrerDomain = WebUtils.GetServerDomain(httpRequest.UrlReferrer, SPBConfig.Instance().DomainRules);
            string urlDomain = WebUtils.GetServerDomain(httpRequest.Url, SPBConfig.Instance().DomainRules);

            if (urlReferrerDomain.Equals(urlDomain, StringComparison.CurrentCultureIgnoreCase))
                return true;
            else
            {
                foreach (string allowableDomain in SPBConfig.Instance().AllowableDomainsForRefers)
                {
                    if (urlDomain.IndexOf(allowableDomain.ToLower()) >= 0)
                        return true;
                }
            }

            return false;
        }


        #region ȡ

        /// <summary>
        /// վ
        /// </summary>
        public static string SiteName
        {
            get { return SiteSettingsManager.GetSiteSettings().SiteName; }
        }

        /// <summary>
        /// ķַָ
        /// </summary>
        public static string BrowserTitleSeparator
        {
            get { return ResourceManager.GetString("Common_BrowserTitleSeparator", Globals.GetCurrentUserLanguage()); }
        }

        #endregion


        ///// <summary>
        ///// ֤Ƿʹ˰ȫӣδʹתȫ
        ///// </summary>
        ///// <example>
        ///// 磺ǰhttp://www.spacebuilder.cn/login.aspxø÷תhttps://www.spacebuilder.cn/login.aspx
        ///// </example>
        ///// <param name="context"><see cref="HttpContext"/></param>
        //public static void ValidateSecureConnection(HttpContext context)
        //{
        //    //Validate we have a secure connection as early as possible
        //    if (SPBConfig.Instance().RequireSLL && !context.Request.IsSecureConnection)
        //    {
        //        Uri url = context.Request.Url;
        //        context.Response.Redirect("https://" + url.ToString().Substring(7));
        //        context.Response.End();
        //    }
        //}

        public static string ConvertUBB2HtmlFromBody(string body, Func<int, string> getAttachmentUrl, IList<Attachment> attachments)
        {
            if (attachments == null)
                return body;
            Match m;
            Regex r;

            string imagePatternFormat = @"\[attachimg\]{0}\[/attachimg\]";
            string attachmentPatternFormat = @"\[attach\]{0}\[/attach\]";

            SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();

            foreach (Attachment attachment in attachments)
            {
                string replacement = string.Empty;
                string attachmentUrl = getAttachmentUrl(attachment.AttachmentID);
                if (attachment.IsImage)
                {
                    if (siteSettings.InlinedImageWidth > 0 && attachment.Width > siteSettings.InlinedImageWidth)
                        replacement = string.Format("<a href=\"{0}\" target=\"_blank\"><img src=\"{0}\" alt=\"{1}\" border=\"0\" width=\"{2}\" /></a>", attachmentUrl, attachment.FriendlyFileName, siteSettings.InlinedImageWidth);
                    else if (siteSettings.InlinedImageHeight > 0 && attachment.Height > siteSettings.InlinedImageHeight)
                        replacement = string.Format("<a href=\"{0}\" target=\"_blank\"><img src=\"{0}\" alt=\"{1}\" border=\"0\" height=\"{2}\" /></a>", attachmentUrl, attachment.FriendlyFileName, siteSettings.InlinedImageHeight);
                    else
                        replacement = string.Format("<a href=\"{0}\" target=\"_blank\"><img src=\"{0}\" alt=\"{1}\" border=\"0\" /></a>", attachmentUrl, attachment.FriendlyFileName);

                    r = new Regex(string.Format(imagePatternFormat, attachment.AttachmentID), RegexOptions.IgnoreCase);
                    body = r.Replace(body, replacement);
                    for (m = r.Match(body); m.Success; m = m.NextMatch())
                    {
                        body = r.Replace(body, replacement);
                    }
                }
                else
                {
                    replacement = string.Format("<a href=\"{0}\" taget=\"_blank\">{1}</a>", attachmentUrl, attachment.FriendlyFileName);
                    r = new Regex(string.Format(attachmentPatternFormat, attachment.AttachmentID), RegexOptions.IgnoreCase);
                    for (m = r.Match(body); m.Success; m = m.NextMatch())
                    {
                        body = r.Replace(body, replacement);
                    }
                }
            }
            return body;
        }

    }
}
