﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Web;
using SpaceBuilder.Utils;
using System.IO;

namespace SpaceBuilder.Common.Handlers
{
    /// <summary>
    /// 显示广告位图示
    /// </summary>
    public class ADPositionPhotoHandler : DownloadFileHandlerBase
    {
        public override void ProcessRequest(HttpContext context)
        {
            string positionCode = context.Request.QueryString.GetString("positionCode", string.Empty);
            bool enableCaching = context.Request.QueryString.GetBool("enableCaching", true);

            if (string.IsNullOrEmpty(positionCode))
            {
                WebUtils.Return404(context);
                return;
            }

            IFile advertisingPositionPhoto = Advertisings.GetAdvertisingPositionPhoto(positionCode);
            if (advertisingPositionPhoto == null)
            {
                WebUtils.Return404(context);
                return;
            }
            else
            {
                DateTime lastModified = advertisingPositionPhoto.LastModified.ToUniversalTime();
                if (enableCaching && IsCacheOK(context, lastModified))
                {
                    WebUtils.Return304(context);
                    return;
                }
                else
                {
                    //context.Response.Clear();
                    context.Response.ContentType = "image/jpeg";
                    FileSystemFile fileSystemFile = advertisingPositionPhoto as FileSystemFile;
                    if (fileSystemFile != null && (!fileSystemFile.FullLocalPath.StartsWith(@"\")))
                    {
                        // Send files stored on UNC paths explicitly to avoid a bug with TransmitFile.
                        context.Response.TransmitFile(fileSystemFile.FullLocalPath);
                    }
                    else
                    {
                        context.Response.AddHeader("Content-Length", advertisingPositionPhoto.ContentLength.ToString("0"));
                        using (Stream stream = advertisingPositionPhoto.OpenReadStream())
                        {
                            if (stream == null)
                            {
                                WebUtils.Return404(context);
                                return;
                            }

                            int bufferLength = advertisingPositionPhoto.ContentLength <= DownloadFileHandlerBase.BufferLength ? advertisingPositionPhoto.ContentLength : DownloadFileHandlerBase.BufferLength;
                            byte[] buffer = new byte[bufferLength];
                            int readedSize;
                            while ((readedSize = stream.Read(buffer, 0, bufferLength)) > 0)
                            {
                                if (!context.Response.IsClientConnected)
                                    break;

                                context.Response.OutputStream.Write(buffer, 0, readedSize);
                            }

                            stream.Close();
                            stream.Dispose();

                            context.Response.OutputStream.Flush();
                            context.Response.Flush();
                        }
                    }

                    if (enableCaching)
                    {
                        // Browser cache settings
                        context.Response.Cache.SetCacheability(HttpCacheability.Private);
                        context.Response.Cache.SetLastModified(lastModified);
                        context.Response.Cache.SetETag(lastModified.Ticks.ToString());
                        context.Response.Cache.SetAllowResponseInBrowserHistory(true);
                        context.Response.Cache.SetValidUntilExpires(true);
                    }
                    else
                    {
                        context.Response.Cache.SetExpires(DateTime.Now.AddMonths(-1));
                    }
                }
            }

            context.Response.Cache.VaryByParams["positionCode"] = true;
            context.Response.Cache.VaryByParams["enableCaching"] = true;
            context.Response.End ();
        }
    }
}
