﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using SpaceBuilder.Utils;
using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Handlers
{
    /// <summary>
    /// 处理rss阅读计数
    /// </summary>
    /// <remarks>
    /// 每次rss用户阅读时自动生成一个1x1像素的图片，并对浏览的rss内容进行计数
    /// </remarks>
    public class AggViewHandler : IHttpHandler
    {
        private static byte[] _bytes = Convert.FromBase64String("R0lGODlhAQABAIAAANvf7wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==");

        #region IHttpHandler Members

        /// <summary>
        /// 输出一个1x1像素的空白图片（在客户端缓存12小时），并且对rss内容进行rss阅读计数，
        /// </summary>
        public void ProcessRequest(HttpContext context)
        {
            int itemID = context.Request.QueryString.GetInt("ItemID", 0);

            string conterType = WebUtils.UrlDecode(context.Request.QueryString.GetString("ConterType", string.Empty));

            if (itemID == 0 || string.IsNullOrEmpty(conterType))
            {
                return;
            }
            else
            {
                Type type = Type.GetType(conterType, false);
                if (type != null)
                {
                    Counter counter = CounterFactory.GetCounter(type);
                    if (counter != null)
                        counter.IncreaseCount(IncreasableCountTypes.RssView, itemID);
                }
            }

            context.Response.ContentType = "image/gif";
            context.Response.AppendHeader("Content-Length", _bytes.Length.ToString());
            context.Response.Cache.SetLastModified(DateTime.Now);
            context.Response.Cache.SetCacheability(HttpCacheability.Public);
            context.Response.Cache.SetExpires(DateTime.Now.AddHours(12));
            context.Response.BinaryWrite(_bytes);
            context.Response.StatusCode = 200;
            context.Response.End();
        }

        /// <summary>
        /// 是否可以重用
        /// </summary>
        public bool IsReusable
        {
            get { return true; }
        }

        #endregion
    }
}