﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Utils;
using System.IO;
using System.Web;
using SpaceBuilder.Web;

namespace SpaceBuilder.Common.Handlers
{
    /// <summary>
    /// 显示企业Logo
    /// </summary>
    public class CompanyLogoHandler : DownloadFileHandlerBase
    {
        public override void ProcessRequest(HttpContext context)
        {
            int userID = context.Request.QueryString.GetInt("UserID", -1);
            bool enableCaching = context.Request.QueryString.GetBool("enableCaching", true);
            if (userID <= 0)
                return;

            IFile avatarFile = Avatars.GetCompanyLogo(userID);
            if (avatarFile == null)
                return;

            DateTime lastModified = avatarFile.LastModified.ToUniversalTime();
            if (enableCaching && IsCacheOK(context, lastModified))
            {
                WebUtils.Return304(context);
                return;
            }
            else
            {
                //context.Response.Clear();
                context.Response.ContentType = "image/jpeg";
                FileSystemFile fileSystemFile = avatarFile as FileSystemFile;
                if (fileSystemFile != null && (!fileSystemFile.FullLocalPath.StartsWith(@"\")))
                {
                    // Send files stored on UNC paths explicitly to avoid a bug with TransmitFile.
                    context.Response.TransmitFile(fileSystemFile.FullLocalPath);
                }
                else
                {
                    context.Response.AddHeader("Content-Length", avatarFile.ContentLength.ToString("0"));
                    using (Stream stream = avatarFile.OpenReadStream())
                    {
                        if (stream == null)
                        {
                            WebUtils.Return404(context);
                            return;
                        }

                        int bufferLength = avatarFile.ContentLength <= DownloadFileHandlerBase.BufferLength ? avatarFile.ContentLength : DownloadFileHandlerBase.BufferLength;
                        byte[] buffer = new byte[bufferLength];
                        int readedSize;
                        while ((readedSize = stream.Read(buffer, 0, bufferLength)) > 0)
                        {
                            if (!context.Response.IsClientConnected)
                                break;

                            context.Response.OutputStream.Write(buffer, 0, readedSize);
                        }

                        stream.Close();
                        stream.Dispose();

                        context.Response.OutputStream.Flush();
                        context.Response.Flush();
                    }
                }
                if (enableCaching)
                {
                    // Browser cache settings
                    context.Response.Cache.SetCacheability(HttpCacheability.Private);
                    context.Response.Cache.SetLastModified(lastModified);
                    context.Response.Cache.SetETag(lastModified.Ticks.ToString());
                    context.Response.Cache.SetAllowResponseInBrowserHistory(true);
                    context.Response.Cache.SetValidUntilExpires(true);
                }
                else
                {
                    context.Response.Cache.SetExpires(DateTime.Now.AddMonths(-1));
                }

                context.Response.Cache.VaryByParams["UserID"] = true;
                context.Response.Cache.VaryByParams["enableCaching"] = true;
                context.Response.End();
            }
        }
    }
}
