﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

namespace SpaceBuilder.Common.Handlers
{
    /// <summary>
    /// 下载文件Handler基类
    /// </summary>
    public abstract class DownloadFileHandlerBase : IHttpHandler
    {
        //输出附件时缓冲区大小
        protected static readonly int BufferLength = 32 * 1024;

        /// <summary>
        /// 是否已经在客户端缓存
        /// </summary>
        /// <param name="context"></param>
        /// <param name="lastModified">必须是utc时间</param>
        /// <returns></returns>
        protected static bool IsCacheOK(HttpContext context, DateTime lastModified)
        {
            DateTime lastModifiedInClient = DateTime.MinValue;

            #region If-Modified-Since(Last-Modified)
            string ifModifiedSince = context.Request.Headers["If-Modified-Since"];
            if (!string.IsNullOrEmpty(ifModifiedSince))
            {
                if (DateTime.TryParse(ifModifiedSince, out lastModifiedInClient))
                {
                    if (Math.Abs(((TimeSpan)lastModified.Subtract(lastModifiedInClient.ToUniversalTime())).TotalSeconds) <= 1)
                    {
                        return true;
                    }
                }
            }
            #endregion

            #region If-None-Match(ETag)
            string etagInClient = context.Request.Headers["If-None-Match"];
            if (!string.IsNullOrEmpty(etagInClient) && (etagInClient == lastModified.Ticks.ToString()))
            {
                return true;
            }

            #endregion

            return false;
        }


        /// <summary>
        /// 设置ContentType以及缓存
        /// </summary>
        protected void SetResponsesDetails(HttpContext context, string contentType, string fileName, DateTime lastModified)
        {
            //可能导致IE6.0死掉
            //context.Response.Clear();

            contentType = contentType.ToLower();
            //string disposition;
            if (contentType.IndexOf("image") > -1 || contentType.IndexOf("application/x-shockwave-flash") > -1 || contentType.IndexOf("audio/x-pn-realaudio-plugin") > -1 || contentType.IndexOf("video/x-ms-wmv") > -1 || contentType.IndexOf("video/quicktime") > -1)
            {
                context.Response.ContentType = contentType;
                //disposition = "inline";
            }
            else
            {
                //context.Response.ContentType = contentType + "; name=\"" + HttpUtility.UrlPathEncode(fileName) + "\"";
                //string disposition = "attachment";
                //if (context.Request.Browser.Browser.IndexOf("Netscape") != -1)
                //    context.Response.AddHeader("Content-disposition", disposition + "; filename*0*=" + context.Server.UrlEncode(fileName).Replace("+", "%20") + "");
                //else
                //    context.Response.AddHeader("Content-disposition", disposition + "; filename=" + context.Server.UrlEncode(fileName).Replace("+", "%20") + "");

                //解决下载中文文件和特殊字符文件名称乱码的问题 By小蔡 
                context.Response.ContentType = contentType;
                //当客户端使用IE时，对其进行编码；使用 ToHexString 代替传统的 UrlEncode()
                if (context.Request.UserAgent.ToLower().IndexOf("msie") > -1)
                    fileName = ToHexString(fileName);

                //为了向客户端输出空格，需要在当客户端使用 Firefox 时特殊处理
                if (context.Request.UserAgent.ToLower().IndexOf("firefox") > -1)
                    context.Response.AddHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
                else
                    context.Response.AddHeader("Content-Disposition", "attachment;filename=" + fileName);
            }

            // Browser cache settings
            context.Response.Cache.SetCacheability(HttpCacheability.Private);
            //context.Response.Cache.SetLastModified(lastModified);
            context.Response.Cache.SetETag(lastModified.Ticks.ToString());
            context.Response.Cache.SetAllowResponseInBrowserHistory(true);
            context.Response.Cache.SetValidUntilExpires(true);
        }


        #region 基于分布式附件存储-获取加密URL

        //////定义有效时间
        ////private static readonly int URL_TIMEOUT = 3600;
        ////格林威治时间
        //private static readonly DateTime GMT = new DateTime(1970, 1, 1);

        ///// <summary>
        ///// 获取NginxLinkModuleUrl基于时间戳的防盗链URl
        ///// </summary>
        ///// <param name="urlHost">可被客户端访问的用于存储附件的根路径地址，例如：“http://img.spacebuilder.cn”</param>
        ///// <param name="fileRelativePath">包含文件名称的相对于根路径的地址，例如：“000/000/000/001/a.jpg”</param>
        ///// <param name="urlSecret">用于Url加密的密钥，必须与Nginx-Link-Module配置一致</param>
        ///// <returns></returns>
        //protected string GetNginxLinkModuleUrl(string urlHost, string fileRelativePath, string urlSecret)
        //{
        //    //This patch enhances Nginx 0.7 secure link download by adding url expiration.
        //    //The url should be formed like this (php example):
        //    //define(DOWNLOAD_SECRET,"secret");
        //    //define(URL_TIMEOUT, 3600);
        //    //$pathtofile = 'path/to/file.txt';
        //    //$time = pack('N', time() + URL_TIMEOUT);
        //    //$timeout = bin2hex($time);
        //    //$key = md5($url.$time.DOWNLOAD_SECRET);
        //    //return $prefix . '/' . $key . $timeout . '/' . $pathtofile;


        //    //获取格林威治时间到当前时间的秒数,加1是为了保证每一天的URL是相同的 用做客户端缓存
        //    //TimeSpan timeSpan = DateTime.Now.Date.AddDays(1) - GMT;
        //    TimeSpan timeSpan = DateTime.UtcNow.Date.AddDays(1) - new DateTime(1970, 1, 1);
        //    int expirationTime = (int)timeSpan.TotalSeconds; //+ URL_TIMEOUT;
        //    //压缩成二进制流,转换php中对应pack函数
        //    byte[] time = BitConverter.GetBytes(expirationTime);
        //    if (BitConverter.IsLittleEndian)
        //        Array.Reverse(time);
        //    //转换成十六进制
        //    string timeOut = Convert.ToString(expirationTime, 16).PadLeft(8, '0');

        //    //加密
        //    byte[] binary_fileRelativePath = Encoding.UTF8.GetBytes(fileRelativePath);
        //    byte[] binary_urlSecret = Encoding.UTF8.GetBytes(urlSecret);
        //    byte[] binary_Key = new byte[time.Length + binary_fileRelativePath.Length + binary_urlSecret.Length];
        //    int i = 0;
        //    foreach (var item in binary_fileRelativePath)
        //        binary_Key[i++] = item;
        //    foreach (var item in time)
        //        binary_Key[i++] = item;
        //    foreach (var item in binary_urlSecret)
        //        binary_Key[i++] = item;
        //    System.Security.Cryptography.MD5 md5 = System.Security.Cryptography.MD5.Create();
        //    string md5Key = BitConverter.ToString(md5.ComputeHash(binary_Key)).ToLower().Replace("-", "");
        //    //string md5Key = EncryptManager.MD5(fileRelativePath + urlSecret);

        //    return string.Join("/", new string[] { urlHost, md5Key + timeOut, fileRelativePath });
        //    //return string.Join("/", new string[] { urlHost, md5Key, fileRelativePath });

        //}
        ///// <summary>
        ///// 生成相对路径 是根据ID填充12位字符，拆分四层路径，如果不符合，需重写该方法
        ///// </summary>
        ///// <param name="AssociateID">相关ID</param>
        ///// <param name="fileName">文件名称</param>
        ///// <returns></returns>
        //protected virtual string MakeFileRelativePath(int associateID, string fileName)
        //{
        //    string idString = associateID.ToString().PadLeft(12, '0');
        //    string path = string.Join("/", new string[] { idString.Substring(0, 3), idString.Substring(3, 3), idString.Substring(6, 3), idString.Substring(9, 3), fileName });
        //    return path;
        //}


        #endregion

        #region IHttpHandler 成员

        /// <exclude/>
        public virtual bool IsReusable
        {
            get { return true; }
        }

        public virtual void ProcessRequest(HttpContext context)
        {
        }

        #endregion

        #region 文件名编码
        /// <summary>
        /// Encodes non-US-ASCII characters in a string.
        /// </summary>
        /// <param name="s"></param>
        /// <returns></returns>
        public static string ToHexString(string s)
        {
            char[] chars = s.ToCharArray();
            StringBuilder builder = new StringBuilder();
            for (int index = 0; index < chars.Length; index++)
            {
                bool needToEncode = NeedToEncode(chars[index]);
                if (needToEncode)
                {
                    string encodedString = ToHexString(chars[index]);
                    builder.Append(encodedString);
                }
                else
                {
                    builder.Append(chars[index]);
                }
            }

            return builder.ToString();
        }

        /// <summary>
        /// Determines if the character needs to be encoded.
        /// </summary>
        /// <param name="chr"></param>
        /// <returns></returns>
        private static bool NeedToEncode(char chr)
        {
            string reservedChars = "$-_.+!*'(),@=&";

            if (chr > 127)
                return true;
            if (char.IsLetterOrDigit(chr) || reservedChars.IndexOf(chr) >= 0)
                return false;

            return true;
        }

        /// <summary>
        /// Encodes a non-US-ASCII character.
        /// </summary>
        /// <param name="chr"></param>
        /// <returns></returns>
        private static string ToHexString(char chr)
        {
            UTF8Encoding utf8 = new UTF8Encoding();
            byte[] encodedBytes = utf8.GetBytes(chr.ToString());
            StringBuilder builder = new StringBuilder();
            for (int index = 0; index < encodedBytes.Length; index++)
            {
                builder.AppendFormat("%{0}", Convert.ToString(encodedBytes[index], 16));
            }

            return builder.ToString();
        }


        #endregion
    }
}
