﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Web;
using SpaceBuilder.Utils;
using System.IO;

namespace SpaceBuilder.Common.Handlers
{
    /// <summary>
    /// 礼品图片
    /// </summary>
    public class giftPhotoHandler : DownloadFileHandlerBase
    {
        public override void ProcessRequest(HttpContext context)
        {
            int giftID = context.Request.QueryString.GetInt("giftID", -1);
            bool enableCaching = context.Request.QueryString.GetBool("enableCaching", true);

            if (giftID <= 0)
            {
                WebUtils.Return404(context);
                return;
            }


            IFile giftPhoto = ConvertibleGifts.GetGiftPhoto(giftID);
            if (giftPhoto != null)
            {
                DateTime lastModified = giftPhoto.LastModified.ToUniversalTime();
                if (enableCaching && IsCacheOK(context,lastModified))
                {
                    WebUtils.Return304(context);
                    return;
                }
                else
                {
                    context.Response.ContentType = "image/jpeg";

                    FileSystemFile fileSystemFile = giftPhoto as FileSystemFile;
                    if (fileSystemFile != null && (!fileSystemFile.FullLocalPath.StartsWith(@"\")))
                    {
                        context.Response.TransmitFile(fileSystemFile.FullLocalPath);
                    }
                    else
                    {
                        context.Response.AddHeader("Content-Length", giftPhoto.ContentLength.ToString("0"));
                        using (Stream stream = giftPhoto.OpenReadStream())
                        {
                            if (stream == null)
                            {
                                WebUtils.Return404(context);
                                return;
                            }
                            int bufferLength = giftPhoto.ContentLength <= DownloadFileHandlerBase.BufferLength ? giftPhoto.ContentLength : DownloadFileHandlerBase.BufferLength;
                            byte[] buffer = new byte[bufferLength];
                            int readedSize;
                            while ((readedSize = stream.Read(buffer, 0, bufferLength)) > 0)
                            {
                                if (!context.Response.IsClientConnected)
                                    break;

                                context.Response.OutputStream.Write(buffer, 0, readedSize);
                            }
                            stream.Close();
                            stream.Dispose();
                            context.Response.OutputStream.Flush();
                            context.Response.Flush();
                        }
                    }
                    if (enableCaching)
                    {
                        context.Response.Cache.SetCacheability(HttpCacheability.Private);
                        context.Response.Cache.SetLastModified(lastModified);
                        context.Response.Cache.SetETag(lastModified.Ticks.ToString());
                        context.Response.Cache.SetAllowResponseInBrowserHistory(true);
                        context.Response.Cache.SetValidUntilExpires(true);
                    }

                    else
                    {
                        context.Response.Cache.SetExpires(DateTime.Now.AddMonths(-1));
                    }
                }
            }

            context.Response.Cache.VaryByParams["giftID"] = true;
            context.Response.Cache.VaryByParams["enableCaching"] = true;
            context.Response.End();
        }

    }
}
