﻿using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Web;
using SpaceBuilder.Utils;
using System.IO;
using System;

namespace SpaceBuilder.Common.Handlers
{
     //<summary>
     //身份认证图片
     //</summary>
   public  class IdentityIconHandler:DownloadFileHandlerBase
    {
       public override void ProcessRequest(HttpContext context)
       {
           int identityID = context.Request.QueryString.GetInt("IdentityID",-1);
           if (identityID <= 0)
           {
               WebUtils.Return404(context);
               return;
           }
           Identity identity=Identities.GetIdentity(identityID);
           if(identity==null)
           {
               WebUtils.Return404(context);
               return;
           }

           IdentityIconTypes iconType = IdentityIconTypes.Small;
            if (!string.IsNullOrEmpty(context.Request.QueryString["iconType"]))
            {
                try
                {
                    iconType = (IdentityIconTypes)Enum.Parse(typeof(IdentityIconTypes), context.Request.QueryString["iconType"], true);
                }
                catch { }
            }

            IFile file = Identities.GetIdentityIcon(identityID, iconType);
                        if (file == null)
            {
                WebUtils.Return404(context);
                return;
            }

                       DateTime lastModified = file.LastModified.ToUniversalTime();
            if (IsCacheOK(context, lastModified))
            {
                WebUtils.Return304(context);
                return;
            }
            else
            {
                SetResponsesDetails(context, "image/jpeg", file.FileName, lastModified);
                FileSystemFile fileSystemFile = file as FileSystemFile;
                if (fileSystemFile != null && (!fileSystemFile.FullLocalPath.StartsWith(@"\")))
                {
                    // Send files stored on UNC paths explicitly to avoid a bug with TransmitFile.
                    context.Response.TransmitFile(fileSystemFile.FullLocalPath);
                }
                else
                {
                    context.Response.AddHeader("Content-Length", file.ContentLength.ToString("0"));
                    using (Stream stream = file.OpenReadStream())
                    {
                        if (stream == null)
                        {
                            WebUtils.Return404(context);
                            return;
                        }

                        int bufferLength = file.ContentLength <= DownloadFileHandlerBase.BufferLength ? file.ContentLength : DownloadFileHandlerBase.BufferLength;
                        byte[] buffer = new byte[bufferLength];
                        int readedSize;
                        while ((readedSize = stream.Read(buffer, 0, bufferLength)) > 0)
                        {
                            if (!context.Response.IsClientConnected)
                                break;

                            context.Response.OutputStream.Write(buffer, 0, readedSize);
                        }

                        stream.Close();
                        stream.Dispose();

                        context.Response.OutputStream.Flush();
                        context.Response.Flush();
                    }
                }
            }

            context.Response.Cache.VaryByParams["IdentityID"] = true;
            context.Response.Cache.VaryByParams["iconType"] = true;
            context.Response.End();
       }

    }
}
